/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.ws;

import com.genexus.diagnostics.core.ILogger;
import com.genexus.servlet.ServletContext;
import com.genexus.specific.java.LogManager;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class GXHandlerChain
implements SOAPHandler<SOAPMessageContext> {
    private static ILogger logger = null;
    public static final String GX_SOAP_BODY = "GXSoapBody";

    public Set<QName> getHeaders() {
        return Collections.emptySet();
    }

    public boolean handleMessage(SOAPMessageContext messageContext) {
        this.initialize(messageContext);
        Boolean outboundProperty = (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            if (logger.isDebugEnabled()) {
                messageContext.getMessage().writeTo((OutputStream)out);
                String messageBody = new String(out.toByteArray(), "utf-8");
                if (Boolean.FALSE.equals(outboundProperty)) {
                    messageContext.put((Object)GX_SOAP_BODY, (Object)messageBody);
                    messageContext.setScope(GX_SOAP_BODY, MessageContext.Scope.APPLICATION);
                }
                logger.debug(messageBody);
            }
        }
        catch (Exception e) {
            logger.error("Exception in handler: ", (Throwable)e);
        }
        return true;
    }

    private void initialize(SOAPMessageContext messageContext) {
        if (logger == null) {
            ServletContext servletContext = new ServletContext(messageContext.get((Object)"javax.xml.ws.servlet.context"));
            logger = LogManager.initialize((String)servletContext.getRealPath("/"), GXHandlerChain.class);
        }
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        return true;
    }

    public void close(MessageContext messageContext) {
    }
}

