/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.ws;

import com.genexus.common.interfaces.IGXWSAddressing;
import com.genexus.common.interfaces.IGXWSAddressingEndPoint;
import com.genexus.common.interfaces.IGXWSEncryption;
import com.genexus.common.interfaces.IGXWSSignature;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.internet.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.message.WSSecEncrypt;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecTimestamp;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GXHandlerConsumerChain
implements SOAPHandler<SOAPMessageContext> {
    public static final ILogger logger = LogManager.getLogger(GXHandlerConsumerChain.class);
    private Location location;
    private String soapHeaderRaw;
    private static final String WSSECURITY_ADDRESSING_URL = "http://www.w3.org/2005/08/addressing";
    private SOAPMessage message;
    private SOAPEnvelope envelope;
    private SOAPHeader header;

    public Set<QName> getHeaders() {
        QName securityHeader = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security", "wsse");
        QName actionAddressingHeader = new QName(WSSECURITY_ADDRESSING_URL, "Action");
        QName messageAddressingHeader = new QName(WSSECURITY_ADDRESSING_URL, "MessageID");
        QName fromAddressingHeader = new QName(WSSECURITY_ADDRESSING_URL, "From");
        QName toAddressingHeader = new QName(WSSECURITY_ADDRESSING_URL, "To");
        HashSet<QName> headers = new HashSet<QName>();
        headers.add(securityHeader);
        headers.add(actionAddressingHeader);
        headers.add(messageAddressingHeader);
        headers.add(fromAddressingHeader);
        headers.add(toAddressingHeader);
        return headers;
    }

    private void getMessageData(SOAPMessageContext messageContext) {
        if (this.message == null) {
            this.message = messageContext.getMessage();
            try {
                this.envelope = this.message.getSOAPPart().getEnvelope();
                this.header = this.envelope.getHeader();
            }
            catch (SOAPException e) {
                logger.error("Exception in getMessageData: ", (Throwable)e);
            }
        }
    }

    public boolean handleMessage(SOAPMessageContext messageContext) {
        Boolean outboundProperty = (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IGXWSAddressing wsAddressing;
            if (Boolean.TRUE.equals(outboundProperty) && this.soapHeaderRaw != null) {
                this.getMessageData(messageContext);
                Document doc = this.parseXML(this.soapHeaderRaw);
                this.header.detachNode();
                SOAPHeader sh = this.envelope.addHeader();
                Node node = sh.getOwnerDocument().importNode(doc.getDocumentElement(), true);
                sh.appendChild(node);
                this.message.saveChanges();
            }
            if ((wsAddressing = this.location.getWSAddressing()) != null && Boolean.TRUE.equals(outboundProperty) && this.soapHeaderRaw == null && !wsAddressing.getMessageID().isEmpty()) {
                this.getMessageData(messageContext);
                this.header.addNamespaceDeclaration("wsa", WSSECURITY_ADDRESSING_URL);
                if (!wsAddressing.getAction().isEmpty()) {
                    SOAPHeaderElement actionElement = this.header.addHeaderElement(this.header.createQName("Action", "wsa"));
                    actionElement.addTextNode(wsAddressing.getAction());
                }
                if (!wsAddressing.getMessageID().isEmpty()) {
                    this.header.addHeaderElement(this.header.createQName("MessageID", "wsa")).addTextNode(wsAddressing.getMessageID());
                }
                if (!wsAddressing.getTo().isEmpty()) {
                    SOAPHeaderElement toElement = this.header.addHeaderElement(this.header.createQName("To", "wsa"));
                    toElement.addTextNode(wsAddressing.getTo());
                }
                if (!wsAddressing.getFrom().getAddress().isEmpty()) {
                    this.processEndPoint(this.header, "From", wsAddressing.getFrom());
                }
                if (!wsAddressing.getReplyTo().getAddress().isEmpty()) {
                    this.processEndPoint(this.header, "ReplyTo", wsAddressing.getReplyTo());
                }
                if (!wsAddressing.getFaultTo().getAddress().isEmpty()) {
                    this.processEndPoint(this.header, "FaultTo", wsAddressing.getFaultTo());
                }
                this.message.saveChanges();
            }
            IGXWSSignature wsSignature = null;
            IGXWSEncryption wsEncryption = null;
            int expirationTimeout = 0;
            if (this.location.getWSSecurity() != null) {
                wsSignature = this.location.getWSSecurity().getSignature();
                wsEncryption = this.location.getWSSecurity().getEncryption();
                expirationTimeout = this.location.getWSSecurity().getExpirationTimeout();
            }
            if (Boolean.TRUE.equals(outboundProperty) && this.soapHeaderRaw == null && (wsSignature != null && !wsSignature.getAlias().isEmpty() || wsEncryption != null && !wsEncryption.getAlias().isEmpty())) {
                this.getMessageData(messageContext);
                Document doc = this.messageToDocument(messageContext.getMessage());
                WSSecHeader secHeader = new WSSecHeader();
                secHeader.insertSecurityHeader(doc);
                Document signedDoc = null;
                if (!wsSignature.getAlias().isEmpty()) {
                    Properties signatureProperties = new Properties();
                    signatureProperties.put("org.apache.ws.security.crypto.merlin.keystore.type", wsSignature.getKeystore().getType());
                    signatureProperties.put("org.apache.ws.security.crypto.merlin.keystore.password", wsSignature.getKeystore().getPassword());
                    signatureProperties.put("org.apache.ws.security.crypto.merlin.file", wsSignature.getKeystore().getSource());
                    Crypto signatureCrypto = CryptoFactory.getInstance((Properties)signatureProperties);
                    WSSecSignature sign = new WSSecSignature();
                    sign.setKeyIdentifierType(wsSignature.getKeyIdentifierType());
                    sign.setUserInfo(wsSignature.getAlias(), wsSignature.getKeystore().getPassword());
                    if (wsSignature.getCanonicalizationalgorithm() != null) {
                        sign.setSigCanonicalization(wsSignature.getCanonicalizationalgorithm());
                    }
                    if (wsSignature.getDigest() != null) {
                        sign.setDigestAlgo(wsSignature.getDigest());
                    }
                    if (wsSignature.getSignaturealgorithm() != null) {
                        sign.setSignatureAlgorithm(wsSignature.getSignaturealgorithm());
                    }
                    signedDoc = sign.build(doc, signatureCrypto, secHeader);
                    if (expirationTimeout > 0) {
                        WSSecTimestamp timestamp = new WSSecTimestamp();
                        timestamp.setTimeToLive(expirationTimeout);
                        signedDoc = timestamp.build(signedDoc, secHeader);
                    }
                }
                if (!wsEncryption.getAlias().isEmpty()) {
                    Properties encryptionProperties = new Properties();
                    encryptionProperties.put("org.apache.ws.security.crypto.merlin.keystore.type", wsEncryption.getKeystore().getType());
                    encryptionProperties.put("org.apache.ws.security.crypto.merlin.keystore.password", wsEncryption.getKeystore().getPassword());
                    encryptionProperties.put("org.apache.ws.security.crypto.merlin.file", wsEncryption.getKeystore().getSource());
                    Crypto encryptionCrypto = CryptoFactory.getInstance((Properties)encryptionProperties);
                    WSSecEncrypt builder = new WSSecEncrypt();
                    builder.setUserInfo(wsEncryption.getAlias(), wsEncryption.getKeystore().getPassword());
                    builder.setKeyIdentifierType(wsEncryption.getKeyIdentifierType());
                    if (signedDoc == null) {
                        signedDoc = doc;
                    }
                    builder.build(signedDoc, encryptionCrypto, secHeader);
                }
                Document securityDoc = doc;
                DOMSource domSource = new DOMSource(securityDoc);
                this.message.getSOAPPart().setContent((Source)domSource);
                this.message.saveChanges();
            }
            if (logger.isDebugEnabled()) {
                messageContext.getMessage().writeTo((OutputStream)out);
                String messageBody = new String(out.toByteArray(), "utf-8");
                logger.debug(messageBody);
            }
        }
        catch (Exception e) {
            logger.error("Exception in handler: ", (Throwable)e);
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    public void setSoapheadersraw(Location location, String soapHeaderRaw) {
        this.location = location;
        this.soapHeaderRaw = soapHeaderRaw;
    }

    private void processEndPoint(SOAPHeader header, String elementName, IGXWSAddressingEndPoint endpoint) throws Exception {
        Node importedNode;
        Document doc;
        SOAPElement parametersElement;
        SOAPHeaderElement fromElement = header.addHeaderElement(header.createQName(elementName, "wsa"));
        fromElement.addChildElement(header.createQName("Address", "wsa")).addTextNode(endpoint.getAddress());
        if (!endpoint.getPortType().isEmpty()) {
            fromElement.addChildElement(header.createQName("PortType", "wsa")).addTextNode(endpoint.getPortType());
        }
        if (!endpoint.getServiceName().isEmpty()) {
            fromElement.addChildElement(header.createQName("ServiceName", "wsa")).addTextNode(endpoint.getServiceName());
        }
        if (!endpoint.getParameters().isEmpty()) {
            parametersElement = fromElement.addChildElement(header.createQName("ReferenceParameters", "wsa"));
            doc = this.parseXML(endpoint.getParameters());
            importedNode = parametersElement.getOwnerDocument().importNode(doc.getDocumentElement(), true);
            parametersElement.appendChild(importedNode);
        }
        if (!endpoint.getProperties().isEmpty()) {
            parametersElement = fromElement.addChildElement(header.createQName("ReferenceProperties", "wsa"));
            doc = this.parseXML(endpoint.getProperties());
            importedNode = parametersElement.getOwnerDocument().importNode(doc.getDocumentElement(), true);
            parametersElement.appendChild(importedNode);
        }
    }

    private Document parseXML(String xml) throws Exception {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes());
        return builderFactory.newDocumentBuilder().parse(stream);
    }

    private Document messageToDocument(SOAPMessage message) throws SOAPException, TransformerException {
        Source src = message.getSOAPPart().getContent();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        DOMResult result = new DOMResult();
        transformer.transform(src, result);
        return (Document)result.getNode();
    }
}

