/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthSchemeNotImplException;
import HTTPClient.AuthorizationHandler;
import HTTPClient.AuthorizationInfo;
import HTTPClient.AuthorizationPrompter;
import HTTPClient.Codecs;
import HTTPClient.DESAlgorithm;
import HTTPClient.GlobalConstants;
import HTTPClient.HttpHeaderElement;
import HTTPClient.Log;
import HTTPClient.MD4;
import HTTPClient.MD5;
import HTTPClient.MD5InputStream;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import HTTPClient.SimpleAuthPrompt;
import HTTPClient.URI;
import HTTPClient.Util;
import HTTPClient.VerifyDigest;
import HTTPClient.VerifyRspAuth;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.util.Vector;

public class DefaultAuthHandler
implements AuthorizationHandler,
GlobalConstants {
    private static final byte[] NUL = new byte[0];
    private static final byte[] zeros = new byte[24];
    private static final int DI_A1 = 0;
    private static final int DI_A1S = 1;
    private static final int DI_QOP = 2;
    private static byte[] digest_secret = null;
    private static boolean send_lm_auth = false;
    private static AuthorizationPrompter prompter = null;
    private static boolean prompterSet = false;
    private static DESAlgorithm DES = new DESAlgorithm(false);

    @Override
    public AuthorizationInfo fixupAuthInfo(AuthorizationInfo info, RoRequest req, AuthorizationInfo challenge, RoResponse resp) throws AuthSchemeNotImplException {
        if (info.getScheme().equalsIgnoreCase("Basic") || info.getScheme().equalsIgnoreCase("SOCKS5")) {
            return info;
        }
        if (!info.getScheme().equalsIgnoreCase("Digest") && !info.getScheme().equalsIgnoreCase("NTLM")) {
            throw new AuthSchemeNotImplException(info.getScheme());
        }
        if (Log.isEnabled(8)) {
            Log.write(8, "Auth:  fixing up Authorization for host " + info.getHost() + ":" + info.getPort() + "; scheme: " + info.getScheme() + "; realm: " + info.getRealm());
        }
        if (info.getScheme().equalsIgnoreCase("Digest")) {
            return DefaultAuthHandler.digest_fixup(info, req, challenge, resp);
        }
        return DefaultAuthHandler.ntlm_fixup(info, req, challenge, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthorizationInfo getAuthorization(AuthorizationInfo challenge, RoRequest req, RoResponse resp, boolean proxy) throws AuthSchemeNotImplException, IOException {
        NVPair answer;
        AuthorizationInfo cred;
        if (Log.isEnabled(8)) {
            Log.write(8, "Auth:  Requesting Authorization for host " + challenge.getHost() + ":" + challenge.getPort() + "; scheme: " + challenge.getScheme() + "; realm: " + challenge.getRealm());
        }
        if (!(challenge.getScheme().equalsIgnoreCase("Basic") || challenge.getScheme().equalsIgnoreCase("Digest") || challenge.getScheme().equalsIgnoreCase("NTLM") || challenge.getScheme().equalsIgnoreCase("SOCKS5"))) {
            return null;
        }
        if (challenge.getScheme().equalsIgnoreCase("Digest") ? (cred = DefaultAuthHandler.digest_check_stale(challenge, req, resp)) != null : challenge.getScheme().equalsIgnoreCase("NTLM") && (cred = DefaultAuthHandler.ntlm_check_step2(challenge, req, resp, proxy)) != null) {
            return cred;
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!req.allowUI() || prompterSet && prompter == null) {
                return null;
            }
            if (prompter == null) {
                DefaultAuthHandler.setDefaultPrompter();
            }
            answer = prompter.getUsernamePassword(challenge, resp.getStatusCode() == 407);
        }
        if (answer == null) {
            return null;
        }
        if (challenge.getScheme().equalsIgnoreCase("basic")) {
            cred = new AuthorizationInfo(challenge.getHost(), challenge.getPort(), challenge.getScheme(), challenge.getRealm(), Codecs.base64Encode(answer.getName() + ":" + answer.getValue()));
        } else if (challenge.getScheme().equalsIgnoreCase("Digest")) {
            cred = DefaultAuthHandler.digest_gen_auth_info(challenge.getHost(), challenge.getPort(), challenge.getRealm(), answer.getName(), answer.getValue(), req.getConnection().getContext());
            cred = DefaultAuthHandler.digest_fixup(cred, req, challenge, null);
        } else if (challenge.getScheme().equalsIgnoreCase("NTLM")) {
            cred = DefaultAuthHandler.ntlm_gen_auth_info(challenge, answer, req);
        } else {
            NVPair[] upwd = new NVPair[]{answer};
            cred = new AuthorizationInfo(challenge.getHost(), challenge.getPort(), challenge.getScheme(), challenge.getRealm(), upwd, null);
        }
        answer = null;
        System.gc();
        Log.write(8, "Auth:  Got Authorization");
        return cred;
    }

    @Override
    public void handleAuthHeaders(Response resp, RoRequest req, AuthorizationInfo prev, AuthorizationInfo prxy) throws IOException {
        String auth_info = resp.getHeader("Authentication-Info");
        String prxy_info = resp.getHeader("Proxy-Authentication-Info");
        if (auth_info == null && prev != null && DefaultAuthHandler.hasParam(prev.getParams(), "qop", "auth-int")) {
            auth_info = "";
        }
        if (prxy_info == null && prxy != null && DefaultAuthHandler.hasParam(prxy.getParams(), "qop", "auth-int")) {
            prxy_info = "";
        }
        try {
            DefaultAuthHandler.handleAuthInfo(auth_info, "Authentication-Info", prev, resp, req, true);
            DefaultAuthHandler.handleAuthInfo(prxy_info, "Proxy-Authentication-Info", prxy, resp, req, true);
        }
        catch (ParseException pe) {
            throw new IOException(pe.toString());
        }
    }

    @Override
    public void handleAuthTrailers(Response resp, RoRequest req, AuthorizationInfo prev, AuthorizationInfo prxy) throws IOException {
        String auth_info = resp.getTrailer("Authentication-Info");
        String prxy_info = resp.getTrailer("Proxy-Authentication-Info");
        try {
            DefaultAuthHandler.handleAuthInfo(auth_info, "Authentication-Info", prev, resp, req, false);
            DefaultAuthHandler.handleAuthInfo(prxy_info, "Proxy-Authentication-Info", prxy, resp, req, false);
        }
        catch (ParseException pe) {
            throw new IOException(pe.toString());
        }
    }

    private static void handleAuthInfo(String auth_info, String hdr_name, AuthorizationInfo prev, Response resp, RoRequest req, boolean in_headers) throws ParseException, IOException {
        if (auth_info == null) {
            return;
        }
        Vector<HttpHeaderElement> pai = Util.parseHeader(auth_info);
        HttpHeaderElement elem = Util.getElement(pai, "nextnonce");
        if (DefaultAuthHandler.handle_nextnonce(prev, req, elem)) {
            pai.removeElement(elem);
        }
        if (DefaultAuthHandler.handle_discard(prev, req, elem = Util.getElement(pai, "discard"))) {
            pai.removeElement(elem);
        }
        if (in_headers) {
            HttpHeaderElement qop = null;
            if (pai != null && (qop = Util.getElement(pai, "qop")) != null && qop.getValue() != null) {
                DefaultAuthHandler.handle_rspauth(prev, resp, req, pai, hdr_name);
            } else if (prev != null && (Util.hasToken(resp.getHeader("Trailer"), hdr_name) && DefaultAuthHandler.hasParam(prev.getParams(), "qop", null) || DefaultAuthHandler.hasParam(prev.getParams(), "qop", "auth-int"))) {
                DefaultAuthHandler.handle_rspauth(prev, resp, req, null, hdr_name);
            } else if (pai != null && qop == null && pai.contains(new HttpHeaderElement("digest")) || Util.hasToken(resp.getHeader("Trailer"), hdr_name) && prev != null && !DefaultAuthHandler.hasParam(prev.getParams(), "qop", null)) {
                DefaultAuthHandler.handle_digest(prev, resp, req, hdr_name);
            }
        }
        if (pai.size() > 0) {
            resp.setHeader(hdr_name, Util.assembleHeader(pai));
        } else {
            resp.deleteHeader(hdr_name);
        }
    }

    private static final boolean hasParam(NVPair[] params, String name, String val) {
        for (int idx = 0; idx < params.length; ++idx) {
            if (!params[idx].getName().equalsIgnoreCase(name) || val != null && !params[idx].getValue().equalsIgnoreCase(val)) continue;
            return true;
        }
        return false;
    }

    private static AuthorizationInfo digest_gen_auth_info(String host, int port, String realm, String user, String pass, Object context) {
        NVPair[] params;
        String A1 = user + ":" + realm + ":" + pass;
        String[] info = new String[]{MD5.hexDigest(A1), null, null};
        AuthorizationInfo prev = AuthorizationInfo.getAuthorization(host, port, "Digest", realm, context);
        if (prev == null) {
            params = new NVPair[]{new NVPair("username", user), new NVPair("uri", ""), new NVPair("nonce", ""), new NVPair("response", "")};
        } else {
            params = prev.getParams();
            for (int idx = 0; idx < params.length; ++idx) {
                if (!params[idx].getName().equalsIgnoreCase("username")) continue;
                params[idx] = new NVPair("username", user);
                break;
            }
        }
        return new AuthorizationInfo(host, port, "Digest", realm, params, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AuthorizationInfo digest_fixup(AuthorizationInfo info, RoRequest req, AuthorizationInfo challenge, RoResponse resp) throws AuthSchemeNotImplException {
        AuthorizationInfo tmp;
        boolean from_server;
        AuthorizationInfo new_info;
        String[] extra;
        NVPair[] params;
        int ch_domain = -1;
        int ch_nonce = -1;
        int ch_alg = -1;
        int ch_opaque = -1;
        int ch_stale = -1;
        int ch_dreq = -1;
        int ch_qop = -1;
        NVPair[] ch_params = null;
        if (challenge != null) {
            ch_params = challenge.getParams();
            for (int idx = 0; idx < ch_params.length; ++idx) {
                String name = ch_params[idx].getName().toLowerCase();
                if (name.equals("domain")) {
                    ch_domain = idx;
                    continue;
                }
                if (name.equals("nonce")) {
                    ch_nonce = idx;
                    continue;
                }
                if (name.equals("opaque")) {
                    ch_opaque = idx;
                    continue;
                }
                if (name.equals("algorithm")) {
                    ch_alg = idx;
                    continue;
                }
                if (name.equals("stale")) {
                    ch_stale = idx;
                    continue;
                }
                if (name.equals("digest-required")) {
                    ch_dreq = idx;
                    continue;
                }
                if (!name.equals("qop")) continue;
                ch_qop = idx;
            }
        }
        int uri = -1;
        int user = -1;
        int alg = -1;
        int response = -1;
        int nonce = -1;
        int cnonce = -1;
        int nc = -1;
        int opaque = -1;
        int digest = -1;
        int dreq = -1;
        int qop = -1;
        AuthorizationInfo authorizationInfo = info;
        synchronized (authorizationInfo) {
            params = info.getParams();
            for (int idx = 0; idx < params.length; ++idx) {
                String name = params[idx].getName().toLowerCase();
                if (name.equals("uri")) {
                    uri = idx;
                    continue;
                }
                if (name.equals("username")) {
                    user = idx;
                    continue;
                }
                if (name.equals("algorithm")) {
                    alg = idx;
                    continue;
                }
                if (name.equals("nonce")) {
                    nonce = idx;
                    continue;
                }
                if (name.equals("cnonce")) {
                    cnonce = idx;
                    continue;
                }
                if (name.equals("nc")) {
                    nc = idx;
                    continue;
                }
                if (name.equals("response")) {
                    response = idx;
                    continue;
                }
                if (name.equals("opaque")) {
                    opaque = idx;
                    continue;
                }
                if (name.equals("digest")) {
                    digest = idx;
                    continue;
                }
                if (name.equals("digest-required")) {
                    dreq = idx;
                    continue;
                }
                if (!name.equals("qop")) continue;
                qop = idx;
            }
            extra = (String[])info.getExtraInfo();
            if (alg != -1 && !params[alg].getValue().equalsIgnoreCase("MD5") && !params[alg].getValue().equalsIgnoreCase("MD5-sess")) {
                throw new AuthSchemeNotImplException("Digest auth scheme: Algorithm " + params[alg].getValue() + " not implemented");
            }
            if (ch_alg != -1 && !ch_params[ch_alg].getValue().equalsIgnoreCase("MD5") && !ch_params[ch_alg].getValue().equalsIgnoreCase("MD5-sess")) {
                throw new AuthSchemeNotImplException("Digest auth scheme: Algorithm " + ch_params[ch_alg].getValue() + " not implemented");
            }
            params[uri] = new NVPair("uri", URI.escape(req.getRequestURI(), URI.escpdPathChar, false));
            String old_nonce = params[nonce].getValue();
            if (ch_nonce != -1 && !old_nonce.equals(ch_params[ch_nonce].getValue())) {
                params[nonce] = ch_params[ch_nonce];
            }
            if (ch_opaque != -1) {
                if (opaque == -1) {
                    params = Util.resizeArray(params, params.length + 1);
                    opaque = params.length - 1;
                }
                params[opaque] = ch_params[ch_opaque];
            }
            if (ch_alg != -1) {
                if (alg == -1) {
                    params = Util.resizeArray(params, params.length + 1);
                    alg = params.length - 1;
                }
                params[alg] = ch_params[ch_alg];
            }
            if (ch_qop != -1 || ch_alg != -1 && ch_params[ch_alg].getValue().equalsIgnoreCase("MD5-sess")) {
                if (cnonce == -1) {
                    params = Util.resizeArray(params, params.length + 1);
                    cnonce = params.length - 1;
                }
                if (digest_secret == null) {
                    digest_secret = DefaultAuthHandler.gen_random_bytes(20);
                }
                long l_time = System.currentTimeMillis();
                byte[] time = new byte[]{(byte)(l_time & 0xFFL), (byte)(l_time >> 8 & 0xFFL), (byte)(l_time >> 16 & 0xFFL), (byte)(l_time >> 24 & 0xFFL), (byte)(l_time >> 32 & 0xFFL), (byte)(l_time >> 40 & 0xFFL), (byte)(l_time >> 48 & 0xFFL), (byte)(l_time >> 56 & 0xFFL)};
                params[cnonce] = new NVPair("cnonce", MD5.hexDigest(digest_secret, time));
            }
            if (ch_qop != -1) {
                int idx;
                if (qop == -1) {
                    params = Util.resizeArray(params, params.length + 1);
                    qop = params.length - 1;
                }
                extra[2] = ch_params[ch_qop].getValue();
                String[] qops = DefaultAuthHandler.splitList(extra[2], ",");
                String p = null;
                for (idx = 0; idx < qops.length; ++idx) {
                    if (qops[idx].equalsIgnoreCase("auth-int") && (req.getStream() == null || req.getConnection().ServProtVersKnown && req.getConnection().ServerProtocolVersion >= 65537)) {
                        p = "auth-int";
                        break;
                    }
                    if (!qops[idx].equalsIgnoreCase("auth")) continue;
                    p = "auth";
                }
                if (p == null) {
                    for (idx = 0; idx < qops.length; ++idx) {
                        if (!qops[idx].equalsIgnoreCase("auth-int")) continue;
                        throw new AuthSchemeNotImplException("Digest auth scheme: Can't comply with qop option 'auth-int' because an HttpOutputStream is being used and the server doesn't speak HTTP/1.1");
                    }
                    throw new AuthSchemeNotImplException("Digest auth scheme: None of the available qop options '" + ch_params[ch_qop].getValue() + "' implemented");
                }
                params[qop] = new NVPair("qop", p);
            }
            if (qop != -1) {
                if (nc == -1) {
                    params = Util.resizeArray(params, params.length + 1);
                    nc = params.length - 1;
                    params[nc] = new NVPair("nc", "00000001");
                } else if (old_nonce.equals(params[nonce].getValue())) {
                    String c = Long.toHexString(Long.parseLong(params[nc].getValue(), 16) + 1L);
                    params[nc] = new NVPair("nc", "00000000".substring(c.length()) + c);
                } else {
                    params[nc] = new NVPair("nc", "00000001");
                }
            }
            if (challenge != null && (ch_stale == -1 || !ch_params[ch_stale].getValue().equalsIgnoreCase("true")) && alg != -1 && params[alg].getValue().equalsIgnoreCase("MD5-sess")) {
                extra[1] = MD5.hexDigest(extra[0] + ":" + params[nonce].getValue() + ":" + params[cnonce].getValue());
            }
            info.setParams(params);
            info.setExtraInfo(extra);
        }
        String hash = null;
        if (qop != -1 && params[qop].getValue().equalsIgnoreCase("auth-int") && req.getStream() == null) {
            hash = MD5.hexDigest(req.getData() == null ? NUL : req.getData());
        }
        if (req.getStream() == null) {
            params[response] = new NVPair("response", DefaultAuthHandler.calcResponseAttr(hash, extra, params, alg, uri, qop, nonce, nc, cnonce, req.getMethod()));
        }
        boolean ch_dreq_val = false;
        if (ch_dreq != -1 && (ch_params[ch_dreq].getValue() == null || ch_params[ch_dreq].getValue().equalsIgnoreCase("true"))) {
            ch_dreq_val = true;
        }
        if ((ch_dreq_val || digest != -1) && req.getStream() == null) {
            NVPair[] d_params;
            if (digest == -1) {
                d_params = Util.resizeArray(params, params.length + 1);
                digest = params.length;
            } else {
                d_params = params;
            }
            d_params[digest] = new NVPair("digest", DefaultAuthHandler.calc_digest(req, extra[0], params[nonce].getValue()));
            if (dreq == -1) {
                dreq = d_params.length;
                d_params = Util.resizeArray(d_params, d_params.length + 1);
                d_params[dreq] = new NVPair("digest-required", "true");
            }
            new_info = new AuthorizationInfo(info.getHost(), info.getPort(), info.getScheme(), info.getRealm(), d_params, extra);
        } else {
            new_info = ch_dreq_val ? null : new AuthorizationInfo(info.getHost(), info.getPort(), info.getScheme(), info.getRealm(), params, extra);
        }
        boolean bl = from_server = challenge != null && challenge.getHost().equalsIgnoreCase(req.getConnection().getHost());
        if (ch_domain != -1) {
            URI base = null;
            try {
                base = new URI(req.getConnection().getProtocol(), req.getConnection().getHost(), req.getConnection().getPort(), req.getRequestURI());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            StringTokenizer tok = new StringTokenizer(ch_params[ch_domain].getValue());
            while (tok.hasMoreTokens()) {
                URI Uri;
                try {
                    Uri = new URI(base, tok.nextToken());
                }
                catch (ParseException pe) {
                    continue;
                }
                if (Uri.getHost() == null) continue;
                AuthorizationInfo tmp2 = AuthorizationInfo.getAuthorization(Uri.getHost(), Uri.getPort(), info.getScheme(), info.getRealm(), req.getConnection().getContext());
                if (tmp2 == null) {
                    params[uri] = new NVPair("uri", Uri.getPathAndQuery());
                    tmp2 = new AuthorizationInfo(Uri.getHost(), Uri.getPort(), info.getScheme(), info.getRealm(), params, extra);
                    AuthorizationInfo.addAuthorization(tmp2);
                }
                if (!from_server) continue;
                tmp2.addPath(Uri.getPathAndQuery());
            }
        } else if (from_server && challenge != null && (tmp = AuthorizationInfo.getAuthorization(challenge.getHost(), challenge.getPort(), info.getScheme(), info.getRealm(), req.getConnection().getContext())) != null) {
            tmp.addPath("/");
        }
        return new_info;
    }

    private static AuthorizationInfo digest_check_stale(AuthorizationInfo challenge, RoRequest req, RoResponse resp) throws AuthSchemeNotImplException, IOException {
        AuthorizationInfo cred = null;
        NVPair[] params = challenge.getParams();
        for (int idx = 0; idx < params.length; ++idx) {
            String name = params[idx].getName();
            if (!name.equalsIgnoreCase("stale") || !params[idx].getValue().equalsIgnoreCase("true")) continue;
            cred = AuthorizationInfo.getAuthorization(challenge, req, resp, false, false);
            if (cred == null) break;
            return DefaultAuthHandler.digest_fixup(cred, req, challenge, resp);
        }
        return cred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean handle_nextnonce(AuthorizationInfo prev, RoRequest req, HttpHeaderElement nextnonce) throws IOException {
        AuthorizationInfo ai;
        if (prev == null || nextnonce == null || nextnonce.getValue() == null) {
            return false;
        }
        try {
            ai = AuthorizationInfo.getAuthorization(prev, req, null, false, false);
        }
        catch (AuthSchemeNotImplException asnie) {
            ai = prev;
        }
        AuthorizationInfo authorizationInfo = ai;
        synchronized (authorizationInfo) {
            NVPair[] params = ai.getParams();
            params = DefaultAuthHandler.setValue(params, "nonce", nextnonce.getValue());
            params = DefaultAuthHandler.setValue(params, "nc", "00000000");
            ai.setParams(params);
        }
        return true;
    }

    private static boolean handle_digest(AuthorizationInfo prev, Response resp, RoRequest req, String hdr_name) throws IOException {
        if (prev == null) {
            return false;
        }
        NVPair[] params = prev.getParams();
        VerifyDigest verifier = new VerifyDigest(((String[])prev.getExtraInfo())[0], DefaultAuthHandler.getValue(params, "nonce"), req.getMethod(), DefaultAuthHandler.getValue(params, "uri"), hdr_name, resp);
        if (resp.hasEntity()) {
            Log.write(8, "Auth:  pushing md5-check-stream to verify digest from " + hdr_name);
            resp.inp_stream = new MD5InputStream(resp.inp_stream, verifier);
        } else {
            Log.write(8, "Auth:  verifying digest from " + hdr_name);
            verifier.verifyHash(MD5.digest(NUL), 0L);
        }
        return true;
    }

    private static boolean handle_rspauth(AuthorizationInfo prev, Response resp, RoRequest req, Vector<HttpHeaderElement> auth_info, String hdr_name) throws IOException {
        if (prev == null) {
            return false;
        }
        NVPair[] params = prev.getParams();
        int uri = -1;
        int alg = -1;
        int nonce = -1;
        int cnonce = -1;
        int nc = -1;
        for (int idx = 0; idx < params.length; ++idx) {
            String name = params[idx].getName().toLowerCase();
            if (name.equals("uri")) {
                uri = idx;
                continue;
            }
            if (name.equals("algorithm")) {
                alg = idx;
                continue;
            }
            if (name.equals("nonce")) {
                nonce = idx;
                continue;
            }
            if (name.equals("cnonce")) {
                cnonce = idx;
                continue;
            }
            if (!name.equals("nc")) continue;
            nc = idx;
        }
        VerifyRspAuth verifier = new VerifyRspAuth(params[uri].getValue(), ((String[])prev.getExtraInfo())[0], alg == -1 ? null : params[alg].getValue(), params[nonce].getValue(), cnonce == -1 ? "" : params[cnonce].getValue(), nc == -1 ? "" : params[nc].getValue(), hdr_name, resp);
        HttpHeaderElement qop = null;
        if (auth_info != null && (qop = Util.getElement(auth_info, "qop")) != null && qop.getValue() != null && (qop.getValue().equalsIgnoreCase("auth") || !resp.hasEntity() && qop.getValue().equalsIgnoreCase("auth-int"))) {
            Log.write(8, "Auth:  verifying rspauth from " + hdr_name);
            verifier.verifyHash(MD5.digest(NUL), 0L);
        } else {
            Log.write(8, "Auth:  pushing md5-check-stream to verify rspauth from " + hdr_name);
            resp.inp_stream = new MD5InputStream(resp.inp_stream, verifier);
        }
        return true;
    }

    private static String calcResponseAttr(String hash, String[] extra, NVPair[] params, int alg, int uri, int qop, int nonce, int nc, int cnonce, String method) {
        String A1 = alg != -1 && params[alg].getValue().equalsIgnoreCase("MD5-sess") ? extra[1] : extra[0];
        String A2 = method + ":" + params[uri].getValue();
        if (qop != -1 && params[qop].getValue().equalsIgnoreCase("auth-int")) {
            A2 = A2 + ":" + hash;
        }
        A2 = MD5.hexDigest(A2);
        String resp_val = qop == -1 ? MD5.hexDigest(A1 + ":" + params[nonce].getValue() + ":" + A2) : MD5.hexDigest(A1 + ":" + params[nonce].getValue() + ":" + params[nc].getValue() + ":" + params[cnonce].getValue() + ":" + params[qop].getValue() + ":" + A2);
        return resp_val;
    }

    private static String calc_digest(RoRequest req, String A1_hash, String nonce) {
        if (req.getStream() != null) {
            return "";
        }
        int ct = -1;
        int ce = -1;
        int lm = -1;
        int ex = -1;
        int dt = -1;
        for (int idx = 0; idx < req.getHeaders().length; ++idx) {
            String name = req.getHeaders()[idx].getName();
            if (name.equalsIgnoreCase("Content-type")) {
                ct = idx;
                continue;
            }
            if (name.equalsIgnoreCase("Content-Encoding")) {
                ce = idx;
                continue;
            }
            if (name.equalsIgnoreCase("Last-Modified")) {
                lm = idx;
                continue;
            }
            if (name.equalsIgnoreCase("Expires")) {
                ex = idx;
                continue;
            }
            if (!name.equalsIgnoreCase("Date")) continue;
            dt = idx;
        }
        NVPair[] hdrs = req.getHeaders();
        byte[] entity_body = req.getData() == null ? NUL : req.getData();
        String entity_hash = MD5.hexDigest(entity_body);
        String entity_info = MD5.hexDigest(req.getRequestURI() + ":" + (ct == -1 ? "" : hdrs[ct].getValue()) + ":" + entity_body.length + ":" + (ce == -1 ? "" : hdrs[ce].getValue()) + ":" + (lm == -1 ? "" : hdrs[lm].getValue()) + ":" + (ex == -1 ? "" : hdrs[ex].getValue()));
        String entity_digest = A1_hash + ":" + nonce + ":" + req.getMethod() + ":" + (dt == -1 ? "" : hdrs[dt].getValue()) + ":" + entity_info + ":" + entity_hash;
        if (Log.isEnabled(8)) {
            Log.write(8, "Auth:  Entity-Info: '" + req.getRequestURI() + ":" + (ct == -1 ? "" : hdrs[ct].getValue()) + ":" + entity_body.length + ":" + (ce == -1 ? "" : hdrs[ce].getValue()) + ":" + (lm == -1 ? "" : hdrs[lm].getValue()) + ":" + (ex == -1 ? "" : hdrs[ex].getValue()) + "'");
            Log.write(8, "Auth:  Entity-Body: '" + entity_hash + "'");
            Log.write(8, "Auth:  Entity-Digest: '" + entity_digest + "'");
        }
        return MD5.hexDigest(entity_digest);
    }

    private static boolean handle_discard(AuthorizationInfo prev, RoRequest req, HttpHeaderElement discard) {
        if (discard != null && prev != null) {
            AuthorizationInfo.removeAuthorization(prev, req.getConnection().getContext());
            return true;
        }
        return false;
    }

    private static byte[] gen_random_bytes(int num) {
        try {
            FileInputStream rnd = new FileInputStream("/dev/random");
            DataInputStream din = new DataInputStream(rnd);
            byte[] data = new byte[num];
            din.readFully(data);
            try {
                din.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return data;
        }
        catch (Throwable rnd) {
            byte[] data = new byte[num];
            try {
                long fm = Runtime.getRuntime().freeMemory();
                data[0] = (byte)(fm & 0xFFL);
                data[1] = (byte)(fm >> 8 & 0xFFL);
                int h = data.hashCode();
                data[2] = (byte)(h & 0xFF);
                data[3] = (byte)(h >> 8 & 0xFF);
                data[4] = (byte)(h >> 16 & 0xFF);
                data[5] = (byte)(h >> 24 & 0xFF);
                long time = System.currentTimeMillis();
                data[6] = (byte)(time & 0xFFL);
                data[7] = (byte)(time >> 8 & 0xFFL);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            return data;
        }
    }

    private static AuthorizationInfo ntlm_gen_auth_info(AuthorizationInfo challenge, NVPair answer, RoRequest req) throws AuthSchemeNotImplException {
        int dot;
        byte[] lm_hpw = DefaultAuthHandler.calc_lm_hpw(answer.getValue());
        byte[] nt_hpw = DefaultAuthHandler.calc_ntcr_hpw(answer.getValue());
        String host = null;
        try {
            host = System.getProperty("HTTPClient.defAuthHandler.NTLM.host");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (host == null) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (host == null) {
            host = "localhost";
        }
        if ((dot = host.indexOf(46)) != -1) {
            host = host.substring(0, dot);
        }
        String domain = null;
        int slash = answer.getName().indexOf(92);
        if (slash != -1) {
            domain = answer.getName().substring(0, slash);
        } else {
            try {
                domain = System.getProperty("HTTPClient.defAuthHandler.NTLM.domain");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (domain == null) {
                domain = host;
            }
        }
        String user = answer.getName().substring(slash + 1);
        Object[] info = new Object[]{user, host.toUpperCase().trim(), domain.toUpperCase().trim(), lm_hpw, nt_hpw};
        AuthorizationInfo cred = new AuthorizationInfo(challenge.getHost(), challenge.getPort(), challenge.getScheme(), challenge.getRealm(), null, info);
        return DefaultAuthHandler.ntlm_fixup(cred, req, challenge, null);
    }

    private static AuthorizationInfo ntlm_fixup(AuthorizationInfo info, RoRequest req, AuthorizationInfo challenge, RoResponse resp) throws AuthSchemeNotImplException {
        byte[] msg;
        if (challenge == null) {
            return info;
        }
        Object[] extra = (Object[])info.getExtraInfo();
        String user = (String)extra[0];
        String host = (String)extra[1];
        String dom = (String)extra[2];
        byte[] lm_hpw = (byte[])extra[3];
        byte[] nt_hpw = (byte[])extra[4];
        if (challenge.getCookie() == null) {
            msg = new byte[32 + host.length() + dom.length()];
            "NTLMSSP".getBytes(0, 7, msg, 0);
            msg[8] = 1;
            int off = 32;
            msg[12] = 3;
            msg[13] = -78;
            int len = host.length();
            msg[24] = (byte)len;
            msg[25] = (byte)(len >> 8);
            msg[26] = (byte)len;
            msg[27] = (byte)(len >> 8);
            msg[28] = (byte)off;
            msg[29] = (byte)(off >> 8);
            host.getBytes(0, len, msg, off);
            off += len;
            len = dom.length();
            msg[16] = (byte)len;
            msg[17] = (byte)(len >> 8);
            msg[18] = (byte)len;
            msg[19] = (byte)(len >> 8);
            msg[20] = (byte)off;
            msg[21] = (byte)(off >> 8);
            dom.getBytes(0, len, msg, off);
            off += len;
        } else {
            String enc_msg = challenge.getCookie();
            byte[] tmp = new byte[enc_msg.length()];
            enc_msg.getBytes(0, tmp.length, tmp, 0);
            msg = Codecs.base64Decode(tmp);
            if (msg.length < 32 || msg[8] != 2 || msg[16] != msg.length) {
                throw new AuthSchemeNotImplException("NTLM auth scheme: received invalid message");
            }
            byte[] nonce = new byte[8];
            System.arraycopy(msg, 24, nonce, 0, 8);
            msg = new byte[64 + 2 * dom.length() + 2 * user.length() + 2 * host.length() + 48];
            "NTLMSSP".getBytes(0, 7, msg, 0);
            msg[8] = 3;
            int off = 64;
            msg[60] = 1;
            msg[61] = -126;
            int len = 2 * dom.length();
            msg[28] = (byte)len;
            msg[29] = (byte)(len >> 8);
            msg[30] = (byte)len;
            msg[29] = (byte)(len >> 8);
            msg[32] = (byte)off;
            msg[33] = (byte)(off >> 8);
            off = DefaultAuthHandler.writeUnicode(dom, msg, off);
            len = 2 * user.length();
            msg[36] = (byte)len;
            msg[37] = (byte)(len >> 8);
            msg[38] = (byte)len;
            msg[39] = (byte)(len >> 8);
            msg[40] = (byte)off;
            msg[41] = (byte)(off >> 8);
            off = DefaultAuthHandler.writeUnicode(user, msg, off);
            len = 2 * host.length();
            msg[44] = (byte)len;
            msg[45] = (byte)(len >> 8);
            msg[46] = (byte)len;
            msg[47] = (byte)(len >> 8);
            msg[48] = (byte)off;
            msg[49] = (byte)(off >> 8);
            off = DefaultAuthHandler.writeUnicode(host, msg, off);
            msg[12] = 24;
            msg[13] = 0;
            msg[14] = 24;
            msg[15] = 0;
            msg[16] = (byte)off;
            msg[17] = (byte)(off >> 8);
            if (send_lm_auth) {
                System.arraycopy(DefaultAuthHandler.calc_ntcr_resp(lm_hpw, nonce), 0, msg, off, 24);
            } else {
                System.arraycopy(zeros, 0, msg, off, 24);
            }
            msg[20] = 24;
            msg[21] = 0;
            msg[22] = 24;
            msg[23] = 0;
            msg[24] = (byte)(off += 24);
            msg[25] = (byte)(off >> 8);
            System.arraycopy(DefaultAuthHandler.calc_ntcr_resp(nt_hpw, nonce), 0, msg, off, 24);
            msg[56] = (byte)(off += 24);
            msg[57] = (byte)(off >> 8);
        }
        String cookie = new String(Codecs.base64Encode(msg), 0);
        AuthorizationInfo cred = new AuthorizationInfo(challenge.getHost(), challenge.getPort(), challenge.getScheme(), challenge.getRealm(), cookie);
        cred.setExtraInfo(extra);
        info.setCookie(cookie);
        return cred;
    }

    private static AuthorizationInfo ntlm_check_step2(AuthorizationInfo challenge, RoRequest req, RoResponse resp, boolean proxy) throws AuthSchemeNotImplException, IOException {
        NVPair[] hdrs = req.getHeaders();
        String auth = null;
        for (int idx = 0; idx < hdrs.length; ++idx) {
            if ((!proxy || !hdrs[idx].getName().equalsIgnoreCase("Proxy-Authorization")) && (proxy || !hdrs[idx].getName().equalsIgnoreCase("Authorization"))) continue;
            auth = hdrs[idx].getValue();
            break;
        }
        AuthorizationInfo cred = AuthorizationInfo.getAuthorization(challenge, req, resp, false, proxy);
        if (challenge.getCookie() != null && cred != null && auth != null && auth.startsWith("NTLM TlRMTVNTUAAB")) {
            return DefaultAuthHandler.ntlm_fixup(cred, req, challenge, null);
        }
        return null;
    }

    private static int writeUnicode(String str, byte[] buf, int off) {
        int len = str.length();
        for (int idx = 0; idx < len; ++idx) {
            char c = str.charAt(idx);
            buf[off++] = (byte)c;
            buf[off++] = (byte)(c >> 8);
        }
        return off;
    }

    static byte[] calc_ntcr_hpw(String passw) {
        byte[] uc = new byte[passw.length() * 2];
        int dst = 0;
        for (int idx = 0; idx < passw.length(); ++idx) {
            char ch = passw.charAt(idx);
            uc[dst++] = (byte)(ch & 0xFF);
            uc[dst++] = (byte)(ch >>> 8);
        }
        byte[] hash = new MD4(uc).getHash();
        return Util.resizeArray(hash, 21);
    }

    static byte[] calc_lm_hpw(String passw) {
        passw = passw.toUpperCase();
        byte[] keys = new byte[14];
        passw.getBytes(0, Math.min(passw.length(), 14), keys, 0);
        byte[] resp = new byte[21];
        byte[] magic = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
        byte[] crypt = new byte[8];
        int[] ks = DefaultAuthHandler.setup_key(keys, 0);
        DES.des_ecb_encrypt(magic, crypt, ks, true);
        System.arraycopy(crypt, 0, resp, 0, 8);
        ks = DefaultAuthHandler.setup_key(keys, 7);
        DES.des_ecb_encrypt(magic, crypt, ks, true);
        System.arraycopy(crypt, 0, resp, 8, 8);
        return resp;
    }

    private static byte[] calc_ntcr_resp(byte[] hpw, byte[] nonce) {
        byte[] resp = new byte[24];
        byte[] crypt = new byte[8];
        int[] ks = DefaultAuthHandler.setup_key(hpw, 0);
        DES.des_ecb_encrypt(nonce, crypt, ks, true);
        System.arraycopy(crypt, 0, resp, 0, 8);
        ks = DefaultAuthHandler.setup_key(hpw, 7);
        DES.des_ecb_encrypt(nonce, crypt, ks, true);
        System.arraycopy(crypt, 0, resp, 8, 8);
        ks = DefaultAuthHandler.setup_key(hpw, 14);
        DES.des_ecb_encrypt(nonce, crypt, ks, true);
        System.arraycopy(crypt, 0, resp, 16, 8);
        return resp;
    }

    private static int[] setup_key(byte[] k_56, int off) {
        byte[] key = new byte[8];
        int[] ks = new int[32];
        key[0] = k_56[off];
        key[1] = (byte)(k_56[off + 0] << 7 | (k_56[off + 1] & 0xFF) >> 1);
        key[2] = (byte)(k_56[off + 1] << 6 | (k_56[off + 2] & 0xFF) >> 2);
        key[3] = (byte)(k_56[off + 2] << 5 | (k_56[off + 3] & 0xFF) >> 3);
        key[4] = (byte)(k_56[off + 3] << 4 | (k_56[off + 4] & 0xFF) >> 4);
        key[5] = (byte)(k_56[off + 4] << 3 | (k_56[off + 5] & 0xFF) >> 5);
        key[6] = (byte)(k_56[off + 5] << 2 | (k_56[off + 6] & 0xFF) >> 6);
        key[7] = (byte)(k_56[off + 6] << 1);
        DES.des_set_odd_parity(key);
        DES.des_set_key(key, ks);
        return ks;
    }

    private static final String getValue(NVPair[] list, String key) {
        int len = list.length;
        for (int idx = 0; idx < len; ++idx) {
            if (!list[idx].getName().equalsIgnoreCase(key)) continue;
            return list[idx].getValue();
        }
        return null;
    }

    private static final int getIndex(NVPair[] list, String key) {
        int len = list.length;
        for (int idx = 0; idx < len; ++idx) {
            if (!list[idx].getName().equalsIgnoreCase(key)) continue;
            return idx;
        }
        return -1;
    }

    private static final NVPair[] setValue(NVPair[] list, String key, String val) {
        int idx = DefaultAuthHandler.getIndex(list, key);
        if (idx == -1) {
            idx = list.length;
            list = Util.resizeArray(list, list.length + 1);
        }
        list[idx] = new NVPair(key, val);
        return list;
    }

    private static String[] splitList(String str, String sep) {
        if (str == null) {
            return new String[0];
        }
        StringTokenizer tok = new StringTokenizer(str, sep);
        String[] list = new String[tok.countTokens()];
        for (int idx = 0; idx < list.length; ++idx) {
            list[idx] = tok.nextToken().trim();
        }
        return list;
    }

    static String hex(byte[] buf) {
        StringBuffer str = new StringBuffer(buf.length * 3);
        for (int idx = 0; idx < buf.length; ++idx) {
            str.append(Character.forDigit(buf[idx] >> 4 & 0xF, 16));
            str.append(Character.forDigit(buf[idx] & 0xF, 16));
            str.append(':');
        }
        str.setLength(str.length() - 1);
        return str.toString();
    }

    static final byte[] unHex(String hex) {
        byte[] digest = new byte[hex.length() / 2];
        for (int idx = 0; idx < digest.length; ++idx) {
            digest[idx] = (byte)(0xFF & Integer.parseInt(hex.substring(2 * idx, 2 * (idx + 1)), 16));
        }
        return digest;
    }

    public static synchronized AuthorizationPrompter setAuthorizationPrompter(AuthorizationPrompter prompt) {
        AuthorizationPrompter prev = prompter;
        prompter = prompt;
        prompterSet = true;
        return prev;
    }

    private static void setDefaultPrompter() {
        prompter = new SimpleAuthPrompt();
    }

    private static final boolean isAWTRunning() {
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        Thread[] t_list = new Thread[root.activeCount() + 5];
        int t_num = root.enumerate(t_list);
        for (int idx = 0; idx < t_num; ++idx) {
            if (!t_list[idx].getName().startsWith("AWT-")) continue;
            return true;
        }
        return false;
    }

    static {
        send_lm_auth = true;
    }
}

