/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class FileResponse
extends HTTPResponse {
    private FileInputStream inp = null;
    private long size;
    private String file;
    private byte[] Data = null;

    public FileResponse(String file) throws IOException {
        this.file = file.replace('/', '\\');
        if (!new File(this.file).canRead()) {
            throw new IOException(file + " not found");
        }
        this.size = new File(this.file).length();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inp == null) {
            this.inp = new FileInputStream(this.file);
        }
        return this.inp;
    }

    @Override
    public synchronized byte[] getData() throws IOException {
        if (this.Data != null) {
            return this.Data;
        }
        this.Data = new byte[(int)this.size];
        if (this.inp == null) {
            try {
                this.getInputStream().read(this.Data);
            }
            finally {
                this.getInputStream().close();
            }
        }
        return this.Data;
    }

    @Override
    synchronized boolean handleResponse() throws IOException, ModuleException {
        return false;
    }
}

