/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.ISSLConnection;
import com.genexus.common.interfaces.SpecificImplementation;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class JSSESSLConnection
implements ISSLConnection {
    private static SSLSocketFactory defaultSSLFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    private SSLSocketFactory sslFactory = defaultSSLFactory;

    @Override
    public Socket processSSLSocket(Socket fromSocket, String host, int port) throws IOException {
        SSLSocket sock = (SSLSocket)this.sslFactory.createSocket(fromSocket, host, port, true);
        if (SpecificImplementation.HttpClient != null) {
            SpecificImplementation.HttpClient.prepareSSLSocket(sock);
        }
        return sock;
    }

    @Override
    public Socket getSSLSocket(InetAddress addr, int port) throws IOException {
        return new Socket(addr, port);
    }

    @Override
    public Socket getSSLSocket(InetAddress addr, int port, InetAddress localAddr, int localPort) throws IOException {
        return new Socket(addr, port, localAddr, localPort);
    }

    @Override
    public Object clone() {
        return this;
    }

    public String toString() {
        return "JSSE SSL Connection, using: " + this.sslFactory;
    }

    public static void setDefaultSSLSocketFactory(SSLSocketFactory sslFactory) {
        defaultSSLFactory = sslFactory;
    }

    public static SSLSocketFactory getDefaultSSLSocketFactory() {
        return defaultSSLFactory;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslFactory) {
        this.sslFactory = sslFactory;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslFactory;
    }
}

