/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.BatchErrorManager;
import com.genexus.ErrorManager;
import java.io.File;
import java.util.HashMap;

public class ApplicationContext {
    private static ApplicationContext instance;
    private String currentLocation = "";
    private boolean poolConnections = false;
    private boolean isReorganization = false;
    private boolean isEJB = false;
    private boolean isApplicationServer = false;
    private boolean isGXUtility = false;
    private boolean isMsgsToUI = true;
    private boolean isServletEngine = false;
    private boolean isEJBEngine = false;
    private boolean isDeveloperMenu = false;
    private static Object syncObject;
    private static HashMap<String, String> customCSSContent;
    private String servletEngineDefaultPath = "";
    public static final String SUBMIT_THREAD = "SubmitThread-";

    private ApplicationContext() {
    }

    public static HashMap<String, String> getcustomCSSContent() {
        return customCSSContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationContext getInstance() {
        if (instance == null) {
            Object object = syncObject;
            synchronized (object) {
                if (instance == null) {
                    instance = new ApplicationContext();
                }
            }
        }
        return instance;
    }

    public static void endApplicationContext() {
        instance = null;
    }

    public void setCurrentLocation(String location) {
        if (this.currentLocation == null || this.currentLocation.trim().length() == 0) {
            this.currentLocation = location;
        }
    }

    public String getCurrentLocation() {
        return this.currentLocation;
    }

    public void setPoolConnections(boolean poolConnections) {
        this.poolConnections = poolConnections;
    }

    public boolean getPoolConnections() {
        return this.poolConnections;
    }

    public void setReorganization(boolean isReorganization) {
        this.isReorganization = isReorganization;
    }

    public boolean getReorganization() {
        return this.isReorganization;
    }

    public boolean getEJB() {
        return this.isEJB;
    }

    public void setEJB(boolean isEJB) {
        this.isEJB = isEJB;
    }

    public void setApplicationServer(boolean isApplicationServer) {
        this.isApplicationServer = isApplicationServer;
        this.setMsgsToUI(false);
        this.setPoolConnections(true);
    }

    public boolean isApplicationServer() {
        return this.isApplicationServer;
    }

    public void setServletEngine(boolean isServletEngine) {
        this.isServletEngine = isServletEngine;
        this.setMsgsToUI(false);
    }

    public boolean isServletEngine() {
        return this.isServletEngine;
    }

    public void setEJBEngine(boolean isEJBEngine) {
        this.isEJBEngine = isEJBEngine;
        this.setMsgsToUI(false);
    }

    public boolean isEJBEngine() {
        return this.isEJBEngine;
    }

    public void setServletEngineDefaultPath(String servletEngineDefaultPath) {
        if (servletEngineDefaultPath != null) {
            this.servletEngineDefaultPath = servletEngineDefaultPath.trim();
            if (this.servletEngineDefaultPath.endsWith(File.separator)) {
                this.servletEngineDefaultPath = this.servletEngineDefaultPath.substring(0, this.servletEngineDefaultPath.length() - 1);
            }
        }
    }

    public String getServletEngineDefaultPath() {
        return this.servletEngineDefaultPath;
    }

    public void setGXUtility(boolean isGXUtility) {
        this.isGXUtility = isGXUtility;
    }

    public boolean isGXUtility() {
        return this.isGXUtility;
    }

    public void setMsgsToUI(boolean isMsgsToUI) {
        this.isMsgsToUI = isMsgsToUI;
    }

    public boolean isMsgsToUI() {
        if (this.isMsgsToUI) {
            String currentThreadName = Thread.currentThread().getName();
            return currentThreadName == null || !currentThreadName.startsWith(SUBMIT_THREAD);
        }
        return false;
    }

    public boolean isDeveloperMenu() {
        return this.isDeveloperMenu;
    }

    public void setDeveloperMenu(boolean isDeveloperMenu) {
        this.isDeveloperMenu = isDeveloperMenu;
    }

    public ErrorManager getErrorManager() {
        return new BatchErrorManager();
    }

    static {
        syncObject = new Object();
        customCSSContent = new HashMap();
    }
}

