/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.CommonUtil;
import com.genexus.GXSmartCacheProvider;
import com.genexus.ICacheService;
import com.genexus.common.classes.AbstractGXFile;
import com.genexus.common.interfaces.IGXSmartCacheProvider;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.util.GXDirectory;
import com.genexus.util.GXFileCollection;
import com.genexus.xml.XMLReader;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;

public abstract class BaseProvider
implements IGXSmartCacheProvider {
    ConcurrentHashMap<String, Vector<String>> queryTables;
    protected Date startupDate;
    Object syncLock = new Object();
    protected static final String FORCED_INVALIDATE = "SD";

    protected String normalizeKey(String key) {
        if (StringUtils.isNotEmpty((String)key)) {
            return key.toLowerCase();
        }
        return key;
    }

    protected void normalizeKey(List<String> keys) {
        ListIterator<String> iterator = keys.listIterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            iterator.set(this.normalizeKey(s));
        }
    }

    private void loadQueryTables() {
        if (this.isEnabled()) {
            String path = SpecificImplementation.Application.getModelContext().getHttpContext().getDefaultPath();
            String configurationDirectoryPath = path + File.separatorChar + "Metadata" + File.separatorChar + "TableAccess";
            ConcurrentHashMap qTables = new ConcurrentHashMap();
            GXDirectory configurationDirectory = new GXDirectory(configurationDirectoryPath);
            GXFileCollection files = configurationDirectory.getFiles();
            XMLReader reader = new XMLReader();
            for (int i = 1; i <= files.getItemCount(); ++i) {
                Vector<String> lst = new Vector<String>();
                lst.add(FORCED_INVALIDATE);
                AbstractGXFile xmlFile = files.item(i);
                reader.open(xmlFile.getAbsoluteName());
                short ok = reader.readType(1, "Table");
                while (ok == 1) {
                    lst.add(this.normalizeKey(reader.getAttributeByName("name")));
                    ok = reader.readType(1, "Table");
                }
                reader.close();
                qTables.put(this.normalizeKey(xmlFile.getNameNoExt()), lst);
            }
            this.startupDate = CommonUtil.now(false, false);
            this.queryTables = qTables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConcurrentHashMap<String, Vector<String>> queryTables() {
        if (this.queryTables == null) {
            Object object = this.syncLock;
            synchronized (object) {
                if (this.queryTables == null) {
                    this.loadQueryTables();
                }
            }
        }
        return this.queryTables;
    }

    @Override
    public void invalidateAll() {
    }

    @Override
    public void invalidate(String item) {
    }

    @Override
    public void recordUpdates(int handle) {
    }

    @Override
    public Object CheckDataStatus(String queryId, Date dateLastModified, Date[] dateUpdated_arr) {
        return GXSmartCacheProvider.DataUpdateStatus.Unknown;
    }

    @Override
    public void discardUpdates(int handle) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public ICacheService getUpdatedTables() {
        return null;
    }

    @Override
    public void setUpdated(String table, int handle) {
    }
}

