/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.util.GXTimeZone;
import java.util.Date;
import java.util.TimeZone;

public final class DateUtils {
    private static final long SEC_MIN = 60L;
    private static final long MIN_HOUR = 60L;
    private static final long MILLI_HOUR = 3600000L;
    private static TimeZone defaultTimeZone;
    private static long timeZoneOffset;
    private static boolean useDaylightTime;

    public static long getDateAsTime(Date date) {
        long baseTime = date.getTime() + timeZoneOffset;
        if (useDaylightTime && defaultTimeZone.inDaylightTime(date)) {
            baseTime += 3600000L;
        }
        return baseTime;
    }

    public static Date getTimeAsDate(long time) {
        long baseTime = time - timeZoneOffset;
        if (useDaylightTime && defaultTimeZone.inDaylightTime(new Date(baseTime))) {
            baseTime -= 3600000L;
        }
        return new Date(baseTime);
    }

    static {
        try {
            defaultTimeZone = GXTimeZone.getDefault();
            timeZoneOffset = defaultTimeZone.getRawOffset();
            useDaylightTime = defaultTimeZone.useDaylightTime();
        }
        catch (Exception e) {
            System.err.println("PrivateUtilities static constructor error:" + e.getMessage());
            throw new ExceptionInInitializerError("PrivateUtilities static constructor error:" + e.getMessage());
        }
    }
}

