/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.CommonUtil;
import java.math.BigDecimal;

public class DecimalUtil {
    public static final BigDecimal ZERO = new BigDecimal(0);
    private static final int DOUBLE_SCALE = 18;

    public static int compareTo(BigDecimal left, BigDecimal right) {
        if (left == null) {
            left = ZERO;
        }
        if (right == null) {
            right = ZERO;
        }
        return left.compareTo(right);
    }

    public static BigDecimal pow(BigDecimal base, BigDecimal p) {
        return DecimalUtil.doubleToDec(Math.pow(DecimalUtil.decToDouble(base), DecimalUtil.decToDouble(p)));
    }

    public static BigDecimal doubleToDec(double d) {
        return DecimalUtil.unexponentString(Double.toString(d));
    }

    public static BigDecimal doubleToDec(long l) {
        return DecimalUtil.unexponentString(Long.toString(l));
    }

    public static BigDecimal stringToDec(String d) {
        return DecimalUtil.unexponentString(d);
    }

    public static String decToString(BigDecimal d) {
        return d.toString();
    }

    public static String decToString(BigDecimal[] d) {
        return DecimalUtil.decToString(d[0]);
    }

    public static String decToString(BigDecimal[][] d) {
        return DecimalUtil.decToString(d[0][0]);
    }

    public static BigDecimal doubleToDec(double d, int len, int dec) {
        return new BigDecimal(CommonUtil.ltrim(CommonUtil.str(d, len, dec)));
    }

    public static double decToDouble(BigDecimal decimal) {
        if (decimal.scale() >= 18) {
            return decimal.setScale(18, 5).doubleValue();
        }
        return decimal.doubleValue();
    }

    public static BigDecimal unexponentString(String num) {
        int scale;
        num = num.trim();
        int scaleAdj = 0;
        int epos = num.indexOf(69);
        if (epos == -1) {
            epos = num.indexOf(101);
        }
        if (epos != -1) {
            String exponent = num.charAt(epos + 1) == '+' ? num.substring(epos + 2) : num.substring(epos + 1);
            scaleAdj = Integer.parseInt(exponent);
            num = num.substring(0, epos);
        }
        int point = num.indexOf(46);
        StringBuffer val = new StringBuffer(point == -1 ? num : num.substring(0, point) + num.substring(point + 1));
        for (scale = num.length() - (point == -1 ? num.length() : point + 1) - scaleAdj; scale < 0; ++scale) {
            val.append("0");
        }
        try {
            return new BigDecimal(val.toString()).movePointLeft(scale);
        }
        catch (NumberFormatException e) {
            return ZERO;
        }
    }
}

