/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.CommonUtil;
import com.genexus.DateUtils;
import com.genexus.GXSimpleCollection;
import com.genexus.util.Codecs;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.zip.GZIPOutputStream;

public final class GXParameterPacker {
    private static final int expandSize = 512;
    private int count;
    private byte[] buf;
    static boolean COMPRESS = true;

    public GXParameterPacker() {
        this(512);
    }

    public GXParameterPacker(int size) {
        this.reset(size);
    }

    public int getLength() {
        return this.count;
    }

    public final void reset(int size) {
        this.buf = new byte[size];
        this.count = 0;
    }

    public final void reset() {
        this.buf = new byte[512];
        this.count = 0;
    }

    public final int size() {
        return this.count;
    }

    private final void expand() {
        this.expand(512);
    }

    private final void expand(int step) {
        int exp_val = step > 512 ? step : 512;
        byte[] newbuf = new byte[this.buf.length + exp_val];
        System.arraycopy(this.buf, 0, newbuf, 0, this.buf.length);
        this.buf = newbuf;
    }

    public final void writeBoolean(boolean data) {
        if (this.count >= this.buf.length) {
            this.expand();
        }
        this.buf[this.count++] = (byte)(data ? 1 : 0);
    }

    public final void writeByte(int data) {
        if (this.count >= this.buf.length) {
            this.expand();
        }
        this.buf[this.count++] = (byte)data;
    }

    public final void writeLongByte(byte[] data) {
        this.writeByte(data);
    }

    public final void writeByte(byte[] data) {
        this.writeInt(data.length);
        for (int i = data.length - 1; i >= 0; --i) {
            this.writeByte(data[i]);
        }
    }

    public final void writeByteArray(byte[] data) {
        this.writeByte(data);
    }

    public final void writeByte(byte[][] data) {
        this.writeInt(data.length);
        this.writeInt(data[0].length);
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                this.writeByte(data[i][j]);
            }
        }
    }

    public final void writeByteArray2(byte[][] data) {
        this.writeByte(data);
    }

    public final void writeShort(int data) {
        if (this.count + 2 > this.buf.length) {
            this.expand();
        }
        this.buf[this.count++] = (byte)(data >>> 8 & 0xFF);
        this.buf[this.count++] = (byte)(data >>> 0 & 0xFF);
    }

    public final void writeShort(short[] data) {
        this.writeInt(data.length);
        for (int i = data.length - 1; i >= 0; --i) {
            this.writeShort(data[i]);
        }
    }

    public final void writeShortArray(short[] data) {
        this.writeShort(data);
    }

    public final void writeShort(short[][] data) {
        this.writeInt(data.length);
        this.writeInt(data[0].length);
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                this.writeShort(data[i][j]);
            }
        }
    }

    public final void writeShortArray2(short[][] data) {
        this.writeShort(data);
    }

    public final void writeChar(int data) {
        if (this.count + 2 > this.buf.length) {
            this.expand();
        }
        this.buf[this.count++] = (byte)(data >>> 8 & 0xFF);
        this.buf[this.count++] = (byte)(data >>> 0 & 0xFF);
    }

    public final void writeChar(int[] data) {
        this.writeInt(data.length);
        for (int i = data.length - 1; i >= 0; --i) {
            this.writeChar(data[i]);
        }
    }

    public final void writeCharArray(char[] data) {
        this.writeInt(data.length);
        for (int i = data.length - 1; i >= 0; --i) {
            this.writeChar(data[i]);
        }
    }

    public final void writeChar(int[][] data) {
        this.writeInt(data.length);
        this.writeInt(data[0].length);
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                this.writeChar(data[i][j]);
            }
        }
    }

    public final void writeCharArray2(char[][] data) {
        this.writeInt(data.length);
        this.writeInt(data[0].length);
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                this.writeChar(data[i][j]);
            }
        }
    }

    public final void writeInt(int data) {
        if (this.count + 4 > this.buf.length) {
            this.expand();
        }
        this.buf[this.count++] = (byte)(data >> 24 & 0xFF);
        this.buf[this.count++] = (byte)(data >> 16 & 0xFF);
        this.buf[this.count++] = (byte)(data >> 8 & 0xFF);
        this.buf[this.count++] = (byte)(data >> 0);
    }

    public final void writeInt(int[] data) {
        this.writeInt(data.length);
        for (int i = data.length - 1; i >= 0; --i) {
            this.writeInt(data[i]);
        }
    }

    public final void writeIntArray(int[] data) {
        this.writeInt(data);
    }

    public final void writeInt(int[][] data) {
        this.writeInt(data.length);
        this.writeInt(data[0].length);
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                this.writeInt(data[i][j]);
            }
        }
    }

    public final void writeIntArray2(int[][] data) {
        this.writeInt(data);
    }

    public final void writeLong(long data) {
        if (this.count + 8 > this.buf.length) {
            this.expand();
        }
        this.buf[this.count++] = (byte)(data >>> 56 & 0xFFL);
        this.buf[this.count++] = (byte)(data >>> 48 & 0xFFL);
        this.buf[this.count++] = (byte)(data >>> 40 & 0xFFL);
        this.buf[this.count++] = (byte)(data >>> 32 & 0xFFL);
        this.buf[this.count++] = (byte)(data >>> 24 & 0xFFL);
        this.buf[this.count++] = (byte)(data >>> 16 & 0xFFL);
        this.buf[this.count++] = (byte)(data >>> 8 & 0xFFL);
        this.buf[this.count++] = (byte)(data >>> 0 & 0xFFL);
    }

    public final void writeLong(long[] data) {
        this.writeInt(data.length);
        for (int i = data.length - 1; i >= 0; --i) {
            this.writeLong(data[i]);
        }
    }

    public final void writeLongArray(long[] data) {
        this.writeLong(data);
    }

    public final void writeLong(long[][] data) {
        this.writeInt(data.length);
        this.writeInt(data[0].length);
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                this.writeLong(data[i][j]);
            }
        }
    }

    public final void writeLongArray2(long[][] data) {
        this.writeLong(data);
    }

    public final void writeFloat(float data) {
        this.writeInt(Float.floatToIntBits(data));
    }

    public final void writeFloat(float[] data) {
        this.writeInt(data.length);
        for (int i = data.length - 1; i >= 0; --i) {
            this.writeFloat(data[i]);
        }
    }

    public final void writeFloatArray(float[] data) {
        this.writeFloat(data);
    }

    public final void writeFloat(float[][] data) {
        this.writeInt(data.length);
        this.writeInt(data[0].length);
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                this.writeFloat(data[i][j]);
            }
        }
    }

    public final void writeFloatArray2(float[][] data) {
        this.writeFloat(data);
    }

    public final void writeDouble(double data) {
        this.writeLong(Double.doubleToLongBits(data));
    }

    public final void writeDouble(double[] data) {
        this.writeInt(data.length);
        for (int i = data.length - 1; i >= 0; --i) {
            this.writeDouble(data[i]);
        }
    }

    public final void writeDoubleArray(double[] data) {
        this.writeDouble(data);
    }

    public final void writeDouble(double[][] data) {
        this.writeInt(data.length);
        this.writeInt(data[0].length);
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                this.writeDouble(data[i][j]);
            }
        }
    }

    public final void writeDoubleArray2(double[][] data) {
        this.writeDouble(data);
    }

    public final void writeString(String data) {
        int length = data.length();
        this.writeInt(length);
        if (this.count + length * 2 >= this.buf.length) {
            this.expand(length);
        }
        for (int i = 0; i < length; ++i) {
            this.writeChar(data.charAt(i));
        }
    }

    public final void writeStringTrim(String data) {
        this.writeString(CommonUtil.rtrim(data));
    }

    public final void writeBlobfile(String fileName) {
        byte[] data = new byte[]{};
        if (fileName.trim().length() > 0) {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(fileName)));){
                data = CommonUtil.readToByteArray(bis);
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading " + fileName + " : " + e.getMessage());
            }
        }
        this.writeInt(data.length);
        for (int i = data.length - 1; i >= 0; --i) {
            this.writeByte(data[i]);
        }
    }

    public final void writeString(String[] data) {
        this.writeInt(data.length);
        for (int i = data.length - 1; i >= 0; --i) {
            this.writeString(data[i]);
        }
    }

    public final void writeStringArray(String[] data) {
        this.writeString(data);
    }

    public final void writeString(String[][] data) {
        this.writeInt(data.length);
        this.writeInt(data[0].length);
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                this.writeString(data[i][j]);
            }
        }
    }

    public final void writeStringArray2(String[][] data) {
        this.writeString(data);
    }

    public final void writeDate(Date data) {
        this.writeLong(DateUtils.getDateAsTime(data));
    }

    public final void writeDate(Date[] data) {
        this.writeInt(data.length);
        for (int i = data.length - 1; i >= 0; --i) {
            this.writeDate(data[i]);
        }
    }

    public final void writeDateArray(Date[] data) {
        this.writeDate(data);
    }

    public final void writeDate(Date[][] data) {
        this.writeInt(data.length);
        this.writeInt(data[0].length);
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                this.writeDate(data[i][j]);
            }
        }
    }

    public final void writeDateArray2(Date[][] data) {
        this.writeDate(data);
    }

    public final void writeDecimal(BigDecimal data) {
        this.writeString(data.toString());
    }

    public final void writeDecimal(BigDecimal[] data) {
        this.writeInt(data.length);
        for (int i = data.length - 1; i >= 0; --i) {
            this.writeDecimal(data[i]);
        }
    }

    public final void writeDecimalArray(BigDecimal[] data) {
        this.writeDecimal(data);
    }

    public final void writeDecimal(BigDecimal[][] data) {
        this.writeInt(data.length);
        this.writeInt(data[0].length);
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                this.writeDecimal(data[i][j]);
            }
        }
    }

    public final void writeDecimalArray2(BigDecimal[][] data) {
        this.writeDecimal(data);
    }

    public String getAsString() {
        return new String(Codecs.base64Encode(this.toByteArray()));
    }

    public final byte[] toByteArray() {
        byte[] returnBuffer;
        if (COMPRESS) {
            if (GXParameterPacker.needsCompressing(this.count)) {
                try {
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream(this.count);
                    GZIPOutputStream zip = new GZIPOutputStream(bytes);
                    zip.write(this.buf, 0, this.count);
                    zip.close();
                    byte[] zipped = bytes.toByteArray();
                    returnBuffer = new byte[zipped.length + 1];
                    returnBuffer[0] = 1;
                    System.arraycopy(zipped, 0, returnBuffer, 1, zipped.length);
                }
                catch (IOException e) {
                    System.err.println("Exception compressing output - sending uncompressed");
                    returnBuffer = new byte[this.count + 1];
                    System.arraycopy(this.buf, 0, returnBuffer, 1, this.count);
                }
            } else {
                if (this.count == 0) {
                    return new byte[0];
                }
                returnBuffer = new byte[this.count + 1];
                System.arraycopy(this.buf, 0, returnBuffer, 1, this.count);
            }
        } else {
            returnBuffer = new byte[this.count];
            System.arraycopy(this.buf, 0, returnBuffer, 0, this.count);
        }
        return returnBuffer;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.count; ++i) {
            ret.append(this.buf[i]);
            ret.append(',');
        }
        return ret.toString();
    }

    private static boolean needsCompressing(int count) {
        return count > 512;
    }

    public void writeGeneric(int[] types, Object[] data) {
        int len = types.length;
        block13: for (int i = 0; i < len; ++i) {
            switch (types[i]) {
                case 1: {
                    this.writeByte(((Byte)data[i]).byteValue());
                    continue block13;
                }
                case 2: {
                    this.writeShort(((Short)data[i]).shortValue());
                    continue block13;
                }
                case 3: {
                    this.writeInt((Integer)data[i]);
                    continue block13;
                }
                case 4: {
                    this.writeLong((Long)data[i]);
                    continue block13;
                }
                case 5: {
                    this.writeFloat(((Float)data[i]).floatValue());
                    continue block13;
                }
                case 6: {
                    this.writeDouble((Double)data[i]);
                    continue block13;
                }
                case 7: {
                    this.writeString((String)data[i]);
                    continue block13;
                }
                case 8: {
                    this.writeDate((Date)data[i]);
                    continue block13;
                }
                case 9: {
                    this.writeDecimal((BigDecimal)data[i]);
                    continue block13;
                }
                case 10: {
                    this.writeBoolean((Boolean)data[i]);
                    continue block13;
                }
                case 11: {
                    this.writeBlobfile((String)data[i]);
                    continue block13;
                }
                default: {
                    System.err.println("Unrecognized parm2 " + types[i]);
                }
            }
        }
    }

    public void writeGeneric2(int[] types, Object[] data) {
        int len = types.length;
        this.writeShort(len);
        block13: for (int i = 0; i < len; ++i) {
            this.writeByte((byte)types[i]);
            switch (types[i]) {
                case 1: {
                    this.writeByte(((Byte)data[i]).byteValue());
                    continue block13;
                }
                case 2: {
                    this.writeShort(((Short)data[i]).shortValue());
                    continue block13;
                }
                case 3: {
                    this.writeInt((Integer)data[i]);
                    continue block13;
                }
                case 4: {
                    this.writeLong((Long)data[i]);
                    continue block13;
                }
                case 5: {
                    this.writeFloat(((Float)data[i]).floatValue());
                    continue block13;
                }
                case 6: {
                    this.writeDouble((Double)data[i]);
                    continue block13;
                }
                case 7: {
                    this.writeString((String)data[i]);
                    continue block13;
                }
                case 8: {
                    this.writeDate((Date)data[i]);
                    continue block13;
                }
                case 9: {
                    this.writeDecimal((BigDecimal)data[i]);
                    continue block13;
                }
                case 10: {
                    this.writeBoolean((Boolean)data[i]);
                    continue block13;
                }
                case 11: {
                    this.writeBlobfile((String)data[i]);
                    continue block13;
                }
                default: {
                    System.err.println("Unrecognized parm2 " + types[i]);
                }
            }
        }
    }

    public void writeObject(Object obj) {
        try {
            ByteArrayOutputStream tempStream = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(tempStream);
            out.writeObject(obj);
            out.close();
            tempStream.close();
            this.writeByte(tempStream.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing object " + obj.toString() + " --> " + e.toString());
        }
    }

    public void writeGxObjectCollection(GXSimpleCollection col) {
        this.writeObject(col);
    }
}

