/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.CommonUtil;
import com.genexus.PictureFormatter;

public abstract class GXPicture {
    private String nullMask;
    protected String mask;
    protected int pos;
    protected boolean cambio;
    protected int length;

    public abstract String format(String var1);

    protected abstract int getPos(int var1);

    protected abstract int getAnt(int var1);

    public GXPicture(String pic) {
        this(pic, pic.length());
    }

    public GXPicture(String picture, int len) {
        if (picture.startsWith("@") && picture.indexOf(33) > 0) {
            this.cambio = true;
            this.setMask(CommonUtil.replicate("!", len));
        } else {
            this.cambio = false;
            this.setMask(picture);
        }
        this.length = len;
    }

    protected void setMask(String mask) {
        this.mask = mask;
        this.nullMask = PictureFormatter.getNullMask(mask);
    }

    public boolean isValid(char c, int pos) {
        if (pos < 0 || !Character.isLetterOrDigit(c)) {
            return false;
        }
        switch (this.mask.charAt(pos)) {
            case '9': {
                return Character.isDigit(c);
            }
            case 'X': {
                return true;
            }
            case '!': {
                return true;
            }
            case 'Z': {
                return Character.isDigit(c);
            }
            case ' ': {
                return c == ' ';
            }
            case 'A': {
                return c == 'A' || c == 'P' || c == 'a' || c == 'p';
            }
            case 'M': {
                return c == 'M' || c == 'm';
            }
        }
        return false;
    }

    public char getCaret(char cIn, int pos, StringBuffer b) {
        switch (this.mask.charAt(pos)) {
            case '9': {
                if (!Character.isDigit(cIn)) {
                    return ' ';
                }
                return cIn;
            }
            case 'X': {
                return cIn;
            }
            case '!': 
            case 'A': 
            case 'M': {
                return Character.toUpperCase(cIn);
            }
            case 'Z': {
                if (Character.isDigit(cIn) && cIn != '0') {
                    return cIn;
                }
                if (cIn != '0') break;
                boolean first = true;
                for (int i = 0; i < pos; ++i) {
                    if (b.charAt(i) == ' ') continue;
                    first = false;
                    break;
                }
                if (first) {
                    return ' ';
                }
                return '0';
            }
        }
        return ' ';
    }

    public String space(String s, int inicio, int fin) {
        return CommonUtil.left(s, inicio) + this.nullMask.substring(inicio, fin) + s.substring(Math.min(fin, s.length()));
    }

    public String nullMask() {
        return this.nullMask;
    }

    public static boolean isSeparator(char c) {
        return c != '9' && c != 'X' && c != '!' && c != 'Z' && c != 'A' && c != 'M';
    }
}

