/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.CommonUtil;
import com.genexus.IHttpContext;
import com.genexus.common.interfaces.SpecificImplementation;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Hashtable;

public class ImagesPath {
    static Hashtable<String, String> imageId = new Hashtable();
    static Hashtable<String, String> loadedTXT = new Hashtable();
    static Hashtable<String, HashSet<String>> imagesDensity = new Hashtable();
    static Hashtable<String, String> imageList = null;
    public static final String RESOURCENAME = "Images.txt";
    private static boolean parseLocations = false;

    public static String getImagePath(String image, String theme, String KBId, IHttpContext httpContext) {
        String realImage;
        if (loadedTXT.get(KBId) == null) {
            ImagesPath.loadImageList(KBId);
            loadedTXT.put(KBId, KBId);
        }
        if ((realImage = imageId.get(image)) != null) {
            image = realImage;
        }
        return imageList.get(KBId + ImagesPath.getHashKey(image, theme, httpContext));
    }

    public static String getImageSrcSet(IHttpContext httpContext, String baseImage) {
        if (baseImage != null && baseImage.trim().length() > 0) {
            String staticContentBase = httpContext.getStaticContentBase();
            String key = baseImage;
            int pos = baseImage.lastIndexOf(staticContentBase);
            if (pos >= 0) {
                key = baseImage.substring(pos + staticContentBase.length());
            }
            if (imagesDensity.containsKey(key)) {
                HashSet<String> densities = imagesDensity.get(key);
                String srcSet = "";
                Boolean first = true;
                String fileNameWithoutExtension = CommonUtil.getFileName(baseImage);
                String fileExtension = CommonUtil.getFileType(baseImage);
                String completeFileName = fileNameWithoutExtension + "." + fileExtension;
                String basePath = baseImage.substring(0, baseImage.lastIndexOf(completeFileName));
                for (String density : densities) {
                    if (!first.booleanValue()) {
                        srcSet = srcSet + ",";
                    }
                    srcSet = srcSet + httpContext.convertURL(basePath + fileNameWithoutExtension + "-" + density.replace('.', '-') + "." + fileExtension) + " " + density;
                    first = false;
                }
                return srcSet;
            }
        }
        return "";
    }

    private static String getHashKey(String imageId, String theme, IHttpContext httpContext) {
        String language = httpContext.getLanguage();
        return imageId + "=" + language + "," + theme;
    }

    private static void loadImageList(String KBId) {
        block17: {
            if (imageList == null) {
                imageList = new Hashtable();
            }
            try {
                InputStream is = SpecificImplementation.ImagesPath.getInputStream(KBId);
                if (is == null) break block17;
                parseLocations = false;
                try (BufferedReader bufread = new BufferedReader(new InputStreamReader(is, "UTF8"));){
                    String line = bufread.readLine();
                    while (line != null) {
                        ImagesPath.parseLine(line, KBId);
                        line = bufread.readLine();
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                System.err.println(e.toString());
            }
            catch (FileNotFoundException e) {
                System.err.println(e.toString());
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
        }
    }

    private static void parseLine(String line, String KBId) {
        int finish = line.trim().length();
        if (finish == 0) {
            return;
        }
        if (line.equals("[IdName]")) {
            parseLocations = false;
            return;
        }
        if (line.equals("[Location]")) {
            parseLocations = true;
            return;
        }
        if (parseLocations) {
            String[] parts = line.split(",");
            if (parts.length >= 4) {
                String key = parts[0] + "," + parts[1];
                String imageType = parts[2];
                String value = imageType.equals("I") ? KBId + "Resources/" + parts[3] : parts[3];
                imageList.put(KBId + key, value);
                if (parts.length > 4 && parts[4].trim().length() > 0) {
                    String[] densitiesList;
                    for (String density : densitiesList = parts[4].split("\\|")) {
                        HashSet<Object> imgDensities;
                        if (density.trim().length() <= 0) continue;
                        if (!imagesDensity.containsKey(value)) {
                            imgDensities = new HashSet();
                            imagesDensity.put(value, imgDensities);
                        } else {
                            imgDensities = imagesDensity.get(value);
                        }
                        imgDensities.add(density.substring(1));
                    }
                }
            }
        } else {
            int separator = line.lastIndexOf("=");
            if (separator > 0) {
                String value = line.substring(0, separator);
                String key = line.substring(separator + 1, line.length());
                imageId.put(key, value);
            }
        }
    }
}

