/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.common.interfaces.SpecificImplementation;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;

public class Messages {
    Properties messages = new Properties();
    MessageFormat formatter;
    static Hashtable<String, Messages> messageList = new Hashtable();

    private Messages(String resourceName, Locale formatterLocale) {
        this.load(resourceName);
        this.formatter = new MessageFormat("");
        this.formatter.setLocale(formatterLocale);
    }

    public static Messages getMessages(String resourceName, Locale formatterLocale) {
        Messages msg = messageList.get(resourceName);
        if (msg == null) {
            msg = new Messages(resourceName, formatterLocale);
            messageList.put(resourceName, msg);
        }
        return msg;
    }

    public static void endMessages() {
        messageList = null;
    }

    public String getMessage(String key1) {
        boolean trimSpaces = key1 != null && key1.length() > 0 && (key1.charAt(0) == ' ' || key1.charAt(key1.length() - 1) == ' ');
        String key = trimSpaces ? key1.trim() : key1;
        String value = this.messages.getProperty(key);
        return value != null ? (trimSpaces ? this.copySpaces(key1, value) : value) : key1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage(String key1, Object[] arguments) {
        boolean trimSpaces = key1 != null && key1.length() > 0 && (key1.charAt(0) == ' ' || key1.charAt(key1.length() - 1) == ' ');
        String key = trimSpaces ? key1.trim() : key1;
        String strFormat = this.messages.getProperty(key);
        if (strFormat == null) {
            strFormat = key1;
        } else {
            Messages messages = this;
            synchronized (messages) {
                this.formatter.applyPattern(strFormat);
                strFormat = this.formatter.format(arguments);
            }
            if (trimSpaces) {
                strFormat = this.copySpaces(key1, strFormat);
            }
        }
        return strFormat;
    }

    private String copySpaces(String strId1, String strFormat) {
        int i;
        StringBuffer str = new StringBuffer();
        for (i = 0; i < strId1.length(); ++i) {
            if (strId1.charAt(i) != ' ') {
                str.append(strFormat);
                break;
            }
            str.append(' ');
        }
        for (i = strId1.length() - 1; i >= 0 && strId1.charAt(i) == ' '; --i) {
            str.append(' ');
        }
        return str.toString();
    }

    protected static final String getTab() {
        return "                ";
    }

    private void load(String resourceName) {
        block16: {
            try (InputStream is = SpecificImplementation.Messages.getInputStream(resourceName);){
                if (is == null) break block16;
                try (BufferedReader bufread = new BufferedReader(new InputStreamReader(is, "UTF8"));){
                    String line = bufread.readLine();
                    while (line != null) {
                        this.parseLine(line);
                        line = bufread.readLine();
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                System.err.println(e.toString());
            }
            catch (FileNotFoundException e) {
                System.err.println(e.toString());
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
        }
    }

    private void parseLine(String line) {
        int len = line.length();
        boolean escaped = false;
        StringBuffer builder = new StringBuffer();
        String code = null;
        boolean hasEqual = false;
        for (int i = 0; i < len; ++i) {
            char ch = line.charAt(i);
            if (ch != '=' && ch != '\\') {
                builder.append(ch);
            } else if (ch == '=' && escaped) {
                builder.append(ch);
            } else if (ch == '\\' && escaped) {
                builder.append(ch);
            }
            if (ch == '=' && !escaped) {
                code = builder.toString();
                hasEqual = true;
                builder = new StringBuffer();
            }
            if (escaped) {
                escaped = false;
                continue;
            }
            if (ch != '\\') continue;
            escaped = true;
        }
        if (len > 0 && code != null && hasEqual && builder.length() > 0) {
            this.messages.put(code, builder.toString());
        }
    }
}

