/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.CommonUtil;
import com.genexus.ModelContext;
import com.genexus.common.classes.AbstractGXFile;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.util.GXDirectory;
import com.genexus.util.GXFileCollection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.regex.Pattern;

public class URLRouter {
    public static final ILogger logger = LogManager.getLogger(URLRouter.class);
    static Hashtable<String, String> routerList;
    private static boolean serverRelative;
    private static Pattern schemeRegex;

    public static String getURLRoute(String key, String[] parms, String[] parmsName, String contextPath, String packageName) {
        return URLRouter.getURLRoute(ModelContext.getModelContext().getPreferences().getProperty("UseNamedParameters", "1").equals("1"), key, parms, parmsName, contextPath, packageName);
    }

    public static String getURLRoute(boolean useNamedParameters, String key, String[] parms, String[] parmsName, String contextPath, String packageName) {
        if (CommonUtil.isAbsoluteURL(key) || key.startsWith("/") || key.isEmpty() || schemeRegex.matcher(key).find()) {
            return parms.length > 0 ? key + "?" + String.join((CharSequence)",", parms) : key;
        }
        if (contextPath.length() > 0 || ModelContext.getModelContext().getHttpContext().isHttpContextWeb()) {
            contextPath = contextPath + "/";
        }
        String lowURL = CommonUtil.lower(key);
        if (!packageName.equals("") && !lowURL.startsWith(packageName) || packageName.equals("") && !lowURL.equals(key)) {
            if (!packageName.equals("")) {
                packageName = packageName + ".";
            }
            try {
                SpecificImplementation.Application.getConfigurationClass().getClassLoader().loadClass(packageName + lowURL);
                lowURL = key = packageName + lowURL;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!(key.split("\\.").length != 2 || !packageName.equals("") && lowURL.startsWith(packageName) || key.indexOf("?") != -1 && key.indexOf("?") <= key.indexOf("."))) {
            return contextPath + key;
        }
        if (routerList == null) {
            routerList = new Hashtable();
            URLRouter.load();
        }
        String[] urlQueryString = key.split("\\?");
        Object[] urlarray = parms;
        if (urlQueryString.length > 1) {
            urlarray = urlQueryString[1].contains("=") ? URLRouter.getParameters(urlQueryString[1].split("&")) : urlQueryString[1].replaceAll("%2C", ",").split(",");
        }
        String url = routerList.containsKey(urlQueryString[0]) ? String.format(routerList.get(urlQueryString[0]), urlarray) : urlQueryString[0];
        return (serverRelative ? contextPath : "") + url + (urlQueryString.length > 1 ? "?" + urlQueryString[1] : URLRouter.convertParmsToQueryString(useNamedParameters, parms, parmsName, routerList.get(urlQueryString[0])));
    }

    private static Object[] getParameters(String[] url) {
        Object[] urlParameters = new Object[url.length];
        for (int i = 0; i < url.length; ++i) {
            urlParameters[i] = "";
            if (url[i].split("=").length <= 1) continue;
            urlParameters[i] = url[i].split("=")[1];
        }
        return urlParameters;
    }

    private static String convertParmsToQueryString(boolean useNamedParameters, String[] parms, String[] parmsName, String routerRule) {
        if (routerRule != null && routerRule.contains("%1") || parms.length == 0) {
            return "";
        }
        String queryString = "?";
        for (int i = 0; i < parms.length; ++i) {
            queryString = !useNamedParameters || parms.length != parmsName.length ? queryString + parms[i] + (i < parms.length - 1 ? "," : "") : queryString + parmsName[i] + "=" + parms[i] + (i < parms.length - 1 ? "&" : "");
        }
        return queryString;
    }

    private static void load() {
        String classesDirectoryPath;
        GXDirectory classesDirectory;
        GXFileCollection rewriteFiles;
        InputStream is = null;
        String defaultPath = SpecificImplementation.Application.getModelContext().getHttpContext().getDefaultPath();
        String appPackage = SpecificImplementation.Application.getClientPreferences().getPACKAGE();
        if (!appPackage.equals("")) {
            appPackage = File.separatorChar + appPackage.replace('.', File.separatorChar);
        }
        if ((rewriteFiles = (classesDirectory = new GXDirectory(classesDirectoryPath = defaultPath + File.separator + "WEB-INF" + File.separatorChar + "classes" + appPackage)).getFiles(".rewrite")) != null) {
            for (int i = 1; i <= rewriteFiles.getItemCount(); ++i) {
                serverRelative = true;
                AbstractGXFile rewriteFile = rewriteFiles.item(i);
                try {
                    is = SpecificImplementation.Messages.getInputStream(rewriteFile.getName());
                    if (is == null) continue;
                    try (BufferedReader bufread = new BufferedReader(new InputStreamReader(is, "UTF8"));){
                        String line = bufread.readLine();
                        while (line != null) {
                            URLRouter.parseLine(line);
                            line = bufread.readLine();
                        }
                        continue;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e.toString(), e);
                    continue;
                }
                catch (FileNotFoundException e) {
                    logger.info("There is no URLRouter file");
                    continue;
                }
                catch (IOException e) {
                    logger.error(e.toString(), e);
                }
            }
        }
    }

    private static void parseLine(String line) {
        int len = line.length();
        boolean escaped = false;
        StringBuffer builder = new StringBuffer();
        String code = null;
        boolean hasEqual = false;
        for (int i = 0; i < len; ++i) {
            char ch = line.charAt(i);
            if (ch != '=' && ch != '\\') {
                builder.append(ch);
            } else if (ch == '=' && escaped) {
                builder.append(ch);
            } else if (ch == '\\' && escaped) {
                builder.append(ch);
            }
            if (ch == '=' && !escaped) {
                if (hasEqual) {
                    builder.append(ch);
                } else {
                    code = builder.toString();
                    hasEqual = true;
                    builder = new StringBuffer();
                }
            }
            if (escaped) {
                escaped = false;
                continue;
            }
            if (ch != '\\') continue;
            escaped = true;
        }
        if (len > 0 && code != null && hasEqual && builder.length() > 0) {
            routerList.put(code, builder.toString());
        }
    }

    static {
        serverRelative = false;
        schemeRegex = Pattern.compile("^([a-z][a-z0-9+\\-.]*):", 2);
    }
}

