/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.cryptography.hashing;

import com.genexus.cryptography.Utils;
import com.genexus.cryptography.hashing.IGXIncrementalHashing;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class IncrementalDigestProvider
implements IGXIncrementalHashing {
    MessageDigest _alg;
    final String OPEN_BRACE = "[";
    final String CLOSE_BRACE = "]";
    final String SEPARATOR = ",";

    public IncrementalDigestProvider(String algorithm) {
        try {
            this._alg = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            System.err.println("error - " + algorithm + " - " + ex.toString());
        }
    }

    @Override
    public void appendRawData(String text) {
        try {
            byte[] bytedata = text.getBytes("UTF8");
            this._alg.update(bytedata, 0, bytedata.length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initData(String text) {
        text = "[" + text;
        try {
            byte[] bytedata = text.getBytes("UTF8");
            this._alg.update(bytedata, 0, bytedata.length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void appendData(String text) {
        text = "," + text;
        try {
            byte[] bytedata = text.getBytes("UTF8");
            this._alg.update(bytedata, 0, bytedata.length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getHashRaw() {
        return Utils.toHexString(this._alg.digest());
    }

    @Override
    public String getHash() {
        String text = "]";
        try {
            byte[] bytedata = text.getBytes("UTF8");
            return Utils.toHexString(this._alg.digest(bytedata));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

