/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.cryptography.hashing;

import com.genexus.cryptography.Utils;
import com.genexus.cryptography.hashing.IGXHashing;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class KeyedHashProvider
implements IGXHashing {
    private static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";
    private String _algorithm = "HmacSHA256";
    private Mac _mac;

    public KeyedHashProvider(String algorithm) throws NoSuchAlgorithmException {
        this._algorithm = algorithm;
        this._mac = Mac.getInstance(this._algorithm);
    }

    @Override
    public String computeHash(String text) {
        throw new UnsupportedOperationException("Only key hashed algorithms are supported");
    }

    @Override
    public String computeHashKey(String data, String key) throws SignatureException, InvalidKeyException {
        SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), this._algorithm);
        this._mac.init(signingKey);
        return Utils.toHexString(this._mac.doFinal(data.getBytes()));
    }
}

