/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.common.classes.AbstractDataSource;
import com.genexus.common.classes.AbstractDataStoreProviderBase;
import com.genexus.common.classes.IGXPreparedStatement;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.db.DynamicExecute;
import com.genexus.db.SentenceProvider;
import com.genexus.db.UpdateCursor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;

public class BatchUpdateCursor
extends UpdateCursor {
    Object[] errorRecords;
    int errorRecordIndex;

    public BatchUpdateCursor(String cursorId, String sqlSentence, int errMask, String tableName) {
        super(cursorId, sqlSentence, errMask);
    }

    public BatchUpdateCursor(String cursorId, String sqlSentence, int errMask) {
        super(cursorId, sqlSentence, errMask);
    }

    public BatchUpdateCursor(String cursorId, String sqlSentence) {
        this(cursorId, sqlSentence, 0);
    }

    @Override
    byte[] preExecute(int cursorNum, AbstractDataStoreProviderBase connectionProvider, AbstractDataSource ds, Object[] params) throws SQLException {
        this.status = 0;
        this.mPreparedStatement = SentenceProvider.getPreparedStatement(connectionProvider, this.mCursorId, this.mSQLSentence, false, true);
        return null;
    }

    boolean supportsSavePoint(AbstractDataSource ds) {
        if (SpecificImplementation.BatchUpdateCursor != null) {
            return SpecificImplementation.BatchUpdateCursor.supportsSavePoint(ds);
        }
        return false;
    }

    @Override
    void postExecute(AbstractDataStoreProviderBase connectionProvider, AbstractDataSource ds) throws SQLException {
        this.errorRecordIndex = -1;
        int[] res = null;
        Object savepoint = null;
        try {
            if (!this.mPreparedStatement.getConnection().getAutoCommit() && this.supportsSavePoint(ds)) {
                savepoint = this.setSavePoint(this.mPreparedStatement, this.mCursorId);
                res = this.mPreparedStatement.executeBatch();
                this.releaseSavepoint(this.mPreparedStatement, savepoint);
            } else {
                res = this.mPreparedStatement.executeBatch();
            }
        }
        catch (SQLException ex) {
            if (savepoint != null) {
                if (!this.mPreparedStatement.getConnection().getAutoCommit() && this.supportsSavePoint(ds)) {
                    this.rollbackSavepoint(this.mPreparedStatement, savepoint);
                }
            }
            throw ex;
        }
        if (res != null && res.length == 0) {
            this.status = 1;
        }
    }

    private Object setSavePoint(IGXPreparedStatement stmt, String savepointName) throws SQLException {
        Class[] parmTypes = new Class[]{String.class};
        Method setSavepointMethod = null;
        try {
            setSavepointMethod = stmt.getConnection().getClass().getMethod("setSavepoint", parmTypes);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (SecurityException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (NoSuchMethodException ex) {
            throw new SQLException(ex.getMessage());
        }
        Object[] argList = new Object[]{this.mCursorId};
        try {
            return setSavepointMethod.invoke((Object)stmt.getConnection(), argList);
        }
        catch (SQLException ex1) {
            throw ex1;
        }
        catch (InvocationTargetException ex1) {
            throw new SQLException(ex1.getTargetException().getMessage());
        }
        catch (IllegalArgumentException ex1) {
            throw new SQLException(ex1.getMessage());
        }
        catch (IllegalAccessException ex1) {
            throw new SQLException(ex1.getMessage());
        }
    }

    private void releaseSavepoint(IGXPreparedStatement stmt, Object savepoint) throws SQLException {
    }

    private void rollbackSavepoint(IGXPreparedStatement stmt, Object savepoint) throws SQLException {
        Class[] parmTypes = new Class[1];
        Class<?> savepointClass = null;
        Method setSavepointMethod = null;
        try {
            savepointClass = Class.forName("java.sql.Savepoint");
        }
        catch (ClassNotFoundException ex2) {
            throw new SQLException(ex2.getMessage());
        }
        parmTypes = new Class[]{savepointClass};
        try {
            setSavepointMethod = stmt.getConnection().getClass().getMethod("rollback", parmTypes);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (SecurityException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (NoSuchMethodException ex) {
            throw new SQLException(ex.getMessage());
        }
        Object[] argList = new Object[]{savepoint};
        try {
            setSavepointMethod.invoke((Object)stmt.getConnection(), argList);
        }
        catch (SQLException ex1) {
            throw ex1;
        }
        catch (InvocationTargetException ex1) {
            throw new SQLException(ex1.getTargetException().getMessage());
        }
        catch (IllegalArgumentException ex1) {
            throw new SQLException(ex1.getMessage());
        }
        catch (IllegalAccessException ex1) {
            throw new SQLException(ex1.getMessage());
        }
    }

    public void notInUse() {
        this.mPreparedStatement.notInUse();
    }

    void addBatch(Object[] parms) throws SQLException {
        this.mPreparedStatement.addBatch(parms);
    }

    int getBatchSize() {
        if (this.mPreparedStatement != null) {
            return this.mPreparedStatement.getBatchSize();
        }
        return 0;
    }

    void setBatchSize(int size) {
        this.mPreparedStatement.setBatchSize(size);
    }

    void onCommitEvent(Object instance, String method) {
        this.mPreparedStatement.setOnCommitInstance(instance);
        this.mPreparedStatement.setOnCommitMethod(method);
    }

    int getRecordCount() {
        return this.mPreparedStatement.getRecordCount();
    }

    int readNextErrorRecord() {
        if (this.errorRecordIndex < this.mPreparedStatement.getRecordCount() - 1) {
            ++this.errorRecordIndex;
            return 1;
        }
        return 0;
    }

    @Override
    protected void close() {
        this.mPreparedStatement.resetRecordCount();
    }

    public boolean pendingRecords() {
        return this.mPreparedStatement.getRecordCount() > 0;
    }

    public boolean isValidOwner(Object o) throws SQLException {
        return o == null || o == this.mPreparedStatement.getOnCommitInstance();
    }

    public boolean beforeCommitEvent() throws SQLException {
        boolean done = false;
        try {
            DynamicExecute.dynamicInstaceExecute(this.mPreparedStatement.getOnCommitInstance(), this.mPreparedStatement.getOnCommitMethod(), null);
            done = true;
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage());
        }
        return done;
    }

    public Object[] getBlockRecords() {
        return this.mPreparedStatement.getBatchRecords();
    }

    @Override
    public boolean isBatchCursor() {
        return true;
    }
}

