/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.common.classes.AbstractDataSource;
import com.genexus.common.classes.AbstractDataStoreProviderBase;
import com.genexus.common.classes.IGXPreparedStatement;
import com.genexus.db.IFieldSetter;
import com.genexus.db.IGXCallableStatement;
import com.genexus.db.IGXResultSet;
import com.genexus.db.ILocalDataStoreHelper;
import com.genexus.db.SentenceProvider;
import com.genexus.db.UpdateCursor;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class BlobUpdateCursor
extends UpdateCursor {
    private static final int BLOB_CURSOR_IDX_BASE = 65536;
    private static final String BLOB_SEL_ID = "Sel";
    private static final String BLOB_SET_NULL_ID = "SetNull";
    private String blobStmt2;
    private String type;
    private int cantNoBlobParms;
    private int cursorIdx;
    private Object[] params;

    public BlobUpdateCursor(String cursorId, String blobStmt1, String blobStmt2, String type, int cantNoBlobParms, int errMask, String tableName) {
        this(cursorId, blobStmt1, blobStmt2, type, cantNoBlobParms, errMask);
    }

    public BlobUpdateCursor(String cursorId, String blobStmt1, String blobStmt2, String type, int cantNoBlobParms, int errMask) {
        super(cursorId, blobStmt1, errMask);
        this.blobStmt2 = blobStmt2;
        this.type = type;
        this.cantNoBlobParms = cantNoBlobParms;
    }

    @Override
    byte[] preExecute(int cursorNum, AbstractDataStoreProviderBase connectionProvider, AbstractDataSource ds, Object[] params) throws SQLException {
        if (this.type.equalsIgnoreCase("ins")) {
            this.preExecuteInsert(cursorNum, connectionProvider, ds, params);
        } else {
            this.preExecuteUpdate(cursorNum, connectionProvider, ds, params);
        }
        return null;
    }

    private void preExecuteInsert(int cursorNum, AbstractDataStoreProviderBase connectionProvider, AbstractDataSource ds, Object[] params) throws SQLException {
        this.mPreparedStatement = (IGXPreparedStatement)((Object)SentenceProvider.getCallableStatement(connectionProvider, this.mCursorId, this.mSQLSentence));
        ((IGXCallableStatement)((Object)this.mPreparedStatement)).registerOutParameter(this.cantNoBlobParms + 1, 1);
        this.mPreparedStatement.skipSetBlobs(true);
    }

    private void preExecuteUpdate(int cursorNum, AbstractDataStoreProviderBase connectionProvider, AbstractDataSource ds, Object[] params) throws SQLException {
        super.preExecute(cursorNum, connectionProvider, ds, params);
        this.cursorIdx = cursorNum;
        this.params = params;
        this.mPreparedStatement.skipSetBlobs(true);
    }

    @Override
    void postExecute(AbstractDataStoreProviderBase connectionProvider, AbstractDataSource ds) throws SQLException {
        if (this.type.equalsIgnoreCase("ins")) {
            this.postExecuteInsert(connectionProvider, ds);
        } else {
            this.postExecuteUpdate(connectionProvider, ds);
        }
    }

    void postExecuteInsert(AbstractDataStoreProviderBase connectionProvider, AbstractDataSource ds) throws SQLException {
        this.mPreparedStatement.executeUpdate();
        this.mPreparedStatement.skipSetBlobs(false);
        IGXPreparedStatement selStmt = SentenceProvider.getPreparedStatement(connectionProvider, this.mCursorId + BLOB_SEL_ID, this.blobStmt2, false);
        String rowId = ((IGXCallableStatement)((Object)this.mPreparedStatement)).getString(this.cantNoBlobParms + 1).trim();
        selStmt.setString(1, rowId);
        IGXResultSet resultSet = (IGXResultSet)((Object)selStmt.executeQuery());
        resultSet.next();
        this.updateBlobs(connectionProvider, resultSet, selStmt, rowId);
    }

    void postExecuteUpdate(AbstractDataStoreProviderBase connectionProvider, AbstractDataSource ds) throws SQLException {
        this.mPreparedStatement.executeUpdate();
        this.mPreparedStatement.skipSetBlobs(false);
        IGXPreparedStatement selStmt = SentenceProvider.getPreparedStatement(connectionProvider, this.mCursorId + BLOB_SEL_ID, this.blobStmt2, false);
        ((ILocalDataStoreHelper)connectionProvider.getHelper()).setParameters(this.cursorIdx + 65536, (IFieldSetter)((Object)selStmt), this.params);
        IGXResultSet resultSet = (IGXResultSet)((Object)selStmt.executeQuery());
        resultSet.next();
        this.updateBlobs(connectionProvider, resultSet, selStmt, null);
    }

    private void updateBlobs(AbstractDataStoreProviderBase connectionProvider, IGXResultSet resultSet, IGXPreparedStatement selStmt, String rowId) throws SQLException {
        int countSetNulls = 0;
        String[] blobFiles = this.mPreparedStatement.getBlobFiles();
        for (int index = 1; index <= blobFiles.length; ++index) {
            if (blobFiles[index - 1] == null) {
                ++countSetNulls;
                continue;
            }
            selStmt.setBLOBFile(resultSet.getBlob(index), blobFiles[index - 1].substring(blobFiles[index - 1].indexOf(44) + 1));
        }
        resultSet.close();
        connectionProvider.getConnection().dropCursor(selStmt);
        if (countSetNulls != 0) {
            String tmp1 = this.blobStmt2.substring(this.blobStmt2.indexOf(" FROM ") + 6);
            String tmp2 = tmp1.substring(tmp1.indexOf(" WHERE "));
            String tmp3 = this.blobStmt2.substring(7, this.blobStmt2.length() - tmp1.length() - 6);
            String tmp4 = tmp2.substring(0, tmp2.indexOf(" FOR UPDATE"));
            String setNullBlobStmt = "UPDATE " + tmp1.substring(0, tmp1.length() - tmp2.length()) + " SET ";
            StringTokenizer tokenizer = new StringTokenizer(tmp3, ",", false);
            for (int index = 1; index <= blobFiles.length; ++index) {
                String nextToken = tokenizer.nextToken();
                if (blobFiles[index - 1] != null) continue;
                setNullBlobStmt = setNullBlobStmt + nextToken + " = NULL";
                if (--countSetNulls == 0) continue;
                setNullBlobStmt = setNullBlobStmt + ", ";
            }
            setNullBlobStmt = setNullBlobStmt + tmp4;
            IGXPreparedStatement setNullStmt = SentenceProvider.getPreparedStatement(connectionProvider, this.mCursorId + BLOB_SET_NULL_ID, setNullBlobStmt, false);
            ((ILocalDataStoreHelper)connectionProvider.getHelper()).setParameters(this.cursorIdx + 65536, (IFieldSetter)((Object)setNullStmt), this.params);
            if (rowId != null) {
                setNullStmt.setString(1, rowId);
            }
            setNullStmt.execute();
            connectionProvider.getConnection().dropCursor(setNullStmt);
            connectionProvider.getConnection().dropCursor(this.mPreparedStatement);
        }
    }
}

