/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.CommonUtil;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.db.IFieldGetter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.UUID;

public class CachedIFieldGetter
implements IFieldGetter,
Serializable {
    private static final long serialVersionUID = 1L;
    private Object[] value;
    private int wasNullHits;
    private TimeZone mTimeZone;
    private Hashtable<Integer, Integer> realColIdx;
    private transient ThreadLocal<Integer> lastIndex = new ThreadLocal();

    public CachedIFieldGetter() {
    }

    public CachedIFieldGetter(Object[] value) {
        this.value = value;
        this.wasNullHits = 0;
        this.realColIdx = new Hashtable(value.length);
    }

    public void setTimeZone(TimeZone cachedValueTimeZone) {
        this.mTimeZone = cachedValueTimeZone;
    }

    public Object[] getValue() {
        return this.value;
    }

    public <T> T getValue(int index) {
        if (this.value[index] instanceof ArrayList) {
            return (T)((ArrayList)this.value[index]).get(0);
        }
        return (T)((Object[])this.value[index])[0];
    }

    @Override
    public void resetWasNullHits() {
        this.wasNullHits = 0;
    }

    private int getColumnIndex(int colIdx) {
        int returnVal;
        if (this.realColIdx.containsKey(colIdx)) {
            returnVal = this.realColIdx.get(colIdx);
        } else {
            returnVal = colIdx + this.wasNullHits - 1;
            this.realColIdx.put(colIdx, returnVal);
        }
        if (this.lastIndex == null) {
            this.lastIndex = new ThreadLocal();
        }
        this.lastIndex.set(returnVal + 1);
        return returnVal;
    }

    @Override
    public boolean wasNull() throws SQLException {
        boolean result = this.value[this.lastIndex.get()] instanceof ArrayList ? (Boolean)((ArrayList)this.value[this.lastIndex.get()]).get(0) : ((boolean[])this.value[this.lastIndex.get()])[0];
        ++this.wasNullHits;
        return result;
    }

    @Override
    public String getLongVarchar(int columnIndex) throws SQLException {
        return this.getVarchar(columnIndex);
    }

    @Override
    public String getVarchar(int columnIndex) throws SQLException {
        Object result = this.getValue(this.getColumnIndex(columnIndex));
        if (result.getClass().getName().equals("com.genexus.GXGeospatial")) {
            return result.toString();
        }
        return (String)result;
    }

    @Override
    public String getString(int columnIndex, int length) throws SQLException {
        return this.getVarchar(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        int index = this.getColumnIndex(columnIndex);
        if (this.value[index] instanceof ArrayList) {
            return (Byte)CommonUtil.convertObjectTo(((ArrayList)this.value[index]).get(0), 1);
        }
        if (this.value[index] instanceof String) {
            byte[] decodedBytes = Base64.getDecoder().decode((String)this.value[index]);
            return decodedBytes[0];
        }
        return ((byte[])this.value[index])[0];
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        int index = this.getColumnIndex(columnIndex);
        if (this.value[index] instanceof ArrayList) {
            return (Short)CommonUtil.convertObjectTo(((ArrayList)this.value[index]).get(0), 2);
        }
        return ((short[])this.value[index])[0];
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        int index = this.getColumnIndex(columnIndex);
        if (this.value[index] instanceof ArrayList) {
            return (Integer)CommonUtil.convertObjectTo(((ArrayList)this.value[index]).get(0), 3);
        }
        return ((int[])this.value[index])[0];
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        int index = this.getColumnIndex(columnIndex);
        if (this.value[index] instanceof ArrayList) {
            return (Long)CommonUtil.convertObjectTo(((ArrayList)this.value[index]).get(0), 4);
        }
        return ((long[])this.value[index])[0];
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        int index = this.getColumnIndex(columnIndex);
        if (this.value[index] instanceof ArrayList) {
            return ((Float)CommonUtil.convertObjectTo(((ArrayList)this.value[index]).get(0), 5)).floatValue();
        }
        return ((float[])this.value[index])[0];
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        int index = this.getColumnIndex(columnIndex);
        if (this.value[index] instanceof ArrayList) {
            return (Double)CommonUtil.convertObjectTo(((ArrayList)this.value[index]).get(0), 6);
        }
        return ((double[])this.value[index])[0];
    }

    @Override
    public java.util.Date getGXDateTime(int columnIndex) throws SQLException {
        return this.getGXDateTime(columnIndex, false);
    }

    @Override
    public java.util.Date getGXDateTime(int columnIndex, boolean hasMilliSeconds) throws SQLException {
        java.util.Date val = this.getGXDate(columnIndex);
        if (CommonUtil.nullDate().equals(val)) {
            return val;
        }
        if (SpecificImplementation.Application.getModelContext() != null && SpecificImplementation.Application.getModelContext().getClientTimeZone() != null && this.mTimeZone != null && !CommonUtil.resetTime(val).equals(CommonUtil.nullDate())) {
            val = CommonUtil.ConvertDateTime(val, this.mTimeZone, SpecificImplementation.Application.getModelContext().getClientTimeZone());
        }
        return val;
    }

    @Override
    public java.util.Date getGXDate(int columnIndex) throws SQLException {
        int index = this.getColumnIndex(columnIndex);
        if (this.value[index] instanceof Long[]) {
            return new java.util.Date(((Long[])this.value[index])[0]);
        }
        if (this.value[index] instanceof ArrayList) {
            ArrayList valueArray = (ArrayList)this.value[index];
            if (valueArray.get(0) instanceof Long) {
                return new java.util.Date((Long)valueArray.get(0));
            }
            return (java.util.Date)CommonUtil.convertObjectTo(valueArray.get(0), 8);
        }
        return ((java.util.Date[])this.value[index])[0];
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getVarchar(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        int index = this.getColumnIndex(columnIndex);
        if (this.value[index] instanceof ArrayList) {
            return (Boolean)CommonUtil.convertObjectTo(((ArrayList)this.value[index]).get(0), 10);
        }
        return ((boolean[])this.value[index])[0];
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (this.getValue(this.getColumnIndex(columnIndex)) instanceof Double) {
            return new BigDecimal((Double)this.getValue(this.getColumnIndex(columnIndex)));
        }
        return (BigDecimal)this.getValue(this.getColumnIndex(columnIndex));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        int index = this.getColumnIndex(columnIndex);
        if (this.value[index] instanceof ArrayList) {
            return (byte[])((ArrayList)this.value[index]).get(0);
        }
        return ((byte[][])this.value[index])[0];
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return (Date)this.getValue(this.getColumnIndex(columnIndex));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.getValue(this.getColumnIndex(columnIndex));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.getValue(this.getColumnIndex(columnIndex));
    }

    @Override
    public String getBLOBFile(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getBLOBFile(int columnIndex, String extension) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getBLOBFile(int columnIndex, String extension, String name) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getMultimediaFile(int columnIndex, String name) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getMultimediaUri(int columnIndex) throws SQLException {
        return this.getMultimediaUri(columnIndex, true);
    }

    @Override
    public String getMultimediaUri(int columnIndex, boolean absPath) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public UUID getGUID(int columnIndex) throws SQLException {
        Object value = this.getValue(this.getColumnIndex(columnIndex));
        if (value instanceof UUID) {
            return (UUID)this.getValue(this.getColumnIndex(columnIndex));
        }
        return (UUID)CommonUtil.convertObjectTo(value, 13);
    }
}

