/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.ApplicationContext;
import com.genexus.common.classes.AbstractDataSource;
import com.genexus.common.classes.AbstractDataStoreProviderBase;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.db.Cursor;
import com.genexus.db.SentenceProvider;
import java.sql.SQLException;

public class UpdateCursor
extends Cursor {
    protected boolean retryExecute = false;

    public UpdateCursor(String cursorId, String sqlSentence, int errMask, String tableName) {
        this(cursorId, sqlSentence, errMask);
    }

    public UpdateCursor(String cursorId, String sqlSentence, int errMask) {
        super(cursorId, sqlSentence, errMask);
    }

    public UpdateCursor(String cursorId, String sqlSentence) {
        this(cursorId, sqlSentence, 0);
    }

    @Override
    byte[] preExecute(int cursorNum, AbstractDataStoreProviderBase connectionProvider, AbstractDataSource ds, Object[] params) throws SQLException {
        this.mPreparedStatement = SentenceProvider.getPreparedStatement(connectionProvider, this.mCursorId, this.mSQLSentence, false);
        return null;
    }

    @Override
    void postExecute(AbstractDataStoreProviderBase connectionProvider, AbstractDataSource ds) throws SQLException {
        try {
            this.retryExecute = false;
            int res = this.mPreparedStatement.executeUpdate();
            this.status = res > 0 ? 0 : 101;
            if (ApplicationContext.getInstance().getReorganization()) {
                SpecificImplementation.Application.addExecutedStatement(this.mCursorId);
            }
        }
        catch (SQLException e) {
            try {
                if ((this.errMask & 0x40) > 0) {
                    SentenceProvider.executeStatement(connectionProvider, "ROLLBACK TO SAVEPOINT gxupdate");
                }
            }
            catch (Exception ex) {
                System.err.println("ROLLBACK TO SAVEPOINT error " + ex.getMessage());
                ex.printStackTrace();
            }
            throw e;
        }
    }

    public boolean getRetryExecute() {
        return this.retryExecute;
    }
}

