/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.diagnostics;

import com.genexus.ModelContext;
import com.genexus.diagnostics.GXDebugManager;

public class GXDebugInfo {
    final ModelContext context;
    final GXDebugManager.IntPair key;
    GXDebugInfo parent;
    final int sId;
    GXDebugManager.GXDebugItem lastItem;
    final GXDebugManager.Stopwatch stopwatch;

    public GXDebugInfo(int sId, ModelContext context, GXDebugManager.IntPair dbgKey) {
        this.sId = sId;
        this.context = context;
        this.key = dbgKey;
        this.lastItem = null;
        this.stopwatch = new GXDebugManager.Stopwatch();
    }

    public void trk(int lineNro) {
        this.updateTicks();
        this.lastItem = GXDebugManager.getInstance().push(this, lineNro, 0);
        this.stopwatch.restart();
    }

    public void trk(int lineNro, int colNro) {
        this.updateTicks();
        this.lastItem = GXDebugManager.getInstance().push(this, lineNro, colNro);
        this.stopwatch.restart();
    }

    public void trkRng(int lineNro, int colNro, int lineNro2, int colNro2) {
        this.updateTicks();
        this.lastItem = GXDebugManager.getInstance().pushRange(this, lineNro, colNro, lineNro2, colNro2);
        this.stopwatch.restart();
    }

    public void onExit() {
        this.updateTicks();
        GXDebugManager.getInstance().onExit(this);
    }

    public void registerPgm(GXDebugInfo parentDbgInfo) {
        GXDebugManager.getInstance().pushPgm(this, parentDbgInfo != null ? parentDbgInfo.sId : 0, this.key);
        if (parentDbgInfo != null) {
            parentDbgInfo.updateTicks();
            parentDbgInfo.lastItem = null;
            parentDbgInfo.stopwatch.restart();
        }
    }

    public void onCleanup() {
        this.updateTicks();
        GXDebugManager.getInstance().onCleanup(this);
    }

    private void updateTicks() {
        if (this.lastItem != null) {
            this.lastItem.ticks = this.stopwatch.getElapsedMicroSecs();
        }
    }
}

