/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.diagnostics;

import com.genexus.ModelContext;
import com.genexus.diagnostics.GXDebugInfo;
import com.genexus.diagnostics.Log;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GXDebugManager {
    public static final short GXDEBUG_VERSION = 2;
    private static final GXDebugGenId GENERATOR_ID = GXDebugGenId.JAVA;
    static final int PGM_INFO_NO_PARENT = 0;
    private static final long MICRO_FREQ = 1000L;
    private static GXDebugManager instance;
    private static final Object sessionLock;
    private static boolean initialized;
    private static int BUFFER_INITIAL_SIZE;
    private static final long TICKS_NOT_SET = Long.MAX_VALUE;
    private static final long TICKS_NOT_NEEDED = 0L;
    private static String fileName;
    private final UUID sessionGuid;
    private final AtomicInteger lastSId;
    private GXDebugItem[] current;
    private GXDebugItem[] next;
    private GXDebugItem[] toSave;
    private boolean saving = false;
    private int dbgIndex = 0;
    private final Object saveLock = new Object();
    private final Object mSaveLock = new Object();
    private final ConcurrentHashMap<String, GXDebugInfo> parentTable = new ConcurrentHashMap();
    private final HashSet<IntPair> pgmInfoTable = new HashSet();
    private static ExecutorService executorService;
    private static final int _SYSTEM = 128;
    private static final int _PGM_TRACE_RANGE = 160;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GXDebugManager getInstance() {
        if (!initialized) {
            Object object = sessionLock;
            synchronized (object) {
                if (!initialized) {
                    initialized = true;
                    instance = new GXDebugManager();
                }
            }
        }
        return instance;
    }

    private GXDebugManager() {
        fileName = System.getProperty("gxperf", fileName);
        this.current = new GXDebugItem[BUFFER_INITIAL_SIZE];
        this.next = new GXDebugItem[BUFFER_INITIAL_SIZE];
        for (int i = 0; i < BUFFER_INITIAL_SIZE; ++i) {
            this.current[i] = new GXDebugItem();
            this.next[i] = new GXDebugItem();
        }
        this.sessionGuid = UUID.randomUUID();
        this.lastSId = new AtomicInteger();
        executorService = new ThreadPoolExecutor(0, 1, 5L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>());
        this.pushSystem(GXDebugMsgCode.INITIALIZE.toByteInt(), new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GXDebugInfo getDbgInfo(ModelContext context, int objClass, int objId, int dbgLines, long hash) {
        Object object = sessionLock;
        synchronized (object) {
            GXDebugInfo parentDbgInfo;
            IntPair objKey = new IntPair(objClass, objId);
            GXDebugInfo dbgInfo = new GXDebugInfo(this.newSId(), context, objKey);
            if (!this.pgmInfoTable.contains(objKey)) {
                PgmInfo pgmInfoObj = new PgmInfo(dbgLines, hash);
                this.pgmInfoTable.add(objKey);
                this.pushSystem(GXDebugMsgCode.PGM_INFO.toByteInt(), new Object[]{objKey, pgmInfoObj});
            }
            String clientId = context.getHttpContext().getClientId();
            dbgInfo.parent = parentDbgInfo = this.parentTable.get(clientId);
            dbgInfo.registerPgm(parentDbgInfo);
            this.parentTable.put(clientId, dbgInfo);
            return dbgInfo;
        }
    }

    private int newSId() {
        return this.lastSId.incrementAndGet();
    }

    protected GXDebugItem pushSystem(int cmdCode) {
        return this.pushSystem(cmdCode, null);
    }

    protected GXDebugItem pushSystem(int cmdCode, Object arg) {
        return this.mPush(null, GXDebugMsgType.SYSTEM, cmdCode, 0, arg);
    }

    protected GXDebugItem push(GXDebugInfo dbgInfo, int lineNro, int colNro) {
        return this.mPush(dbgInfo, GXDebugMsgType.PGM_TRACE, lineNro, colNro, null);
    }

    protected GXDebugItem pushPgm(GXDebugInfo dbgInfo, int parentSId, IntPair pgmKey) {
        return this.mPush(dbgInfo, GXDebugMsgType.REGISTER_PGM, parentSId, 0, pgmKey);
    }

    protected GXDebugItem pushRange(GXDebugInfo dbgInfo, int lineNro, int colNro, int lineNro2, int colNro2) {
        if (colNro != 0 || colNro2 != 0) {
            return this.mPush(dbgInfo, GXDebugMsgType.PGM_TRACE_RANGE_WITH_COLS, lineNro, lineNro2, new IntPair(colNro, colNro2));
        }
        return this.mPush(dbgInfo, GXDebugMsgType.PGM_TRACE_RANGE, lineNro, lineNro2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GXDebugItem mPush(GXDebugInfo dbgInfo, GXDebugMsgType msgType, int arg1, int arg2, Object argObj) {
        Object object = this.saveLock;
        synchronized (object) {
            if (this.toSave != null) {
                this.save(this.toSave);
                this.toSave = null;
            }
            GXDebugItem currentItem = this.current[this.dbgIndex];
            currentItem.dbgInfo = dbgInfo;
            currentItem.msgType = msgType;
            currentItem.arg1 = arg1;
            currentItem.arg2 = arg2;
            currentItem.argObj = argObj;
            block5 : switch (msgType) {
                case SYSTEM: {
                    switch (GXDebugMsgCode.valueOf(arg1)) {
                        case INITIALIZE: 
                        case EXIT: 
                        case OBJ_CLEANUP: {
                            currentItem.ticks = 0L;
                            break block5;
                        }
                    }
                    currentItem.ticks = Long.MAX_VALUE;
                    break;
                }
                case REGISTER_PGM: {
                    currentItem.ticks = 0L;
                    break;
                }
                default: {
                    currentItem.ticks = Long.MAX_VALUE;
                }
            }
            ++this.dbgIndex;
            if (this.dbgIndex == this.current.length) {
                Object object2 = this.mSaveLock;
                synchronized (object2) {
                    while (this.saving) {
                        try {
                            this.mSaveLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                this.toSave = this.current;
                GXDebugItem[] swap = this.current;
                this.current = this.next;
                this.next = swap;
                this.pgmInfoTable.clear();
                this.dbgIndex = 0;
            }
            return currentItem;
        }
    }

    private void save(GXDebugItem[] toSave) {
        this.save(toSave, -1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(GXDebugItem[] toSave, int saveTop, boolean saveInThread) {
        int saveCount = 0;
        if (saveTop == -1) {
            toSave = this.next;
            saveTop = toSave.length;
            for (int idx = 0; idx < saveTop; ++idx) {
                if (toSave[idx].ticks == Long.MAX_VALUE) {
                    GXDebugItem swap = toSave[idx];
                    toSave[idx] = this.current[this.dbgIndex];
                    this.current[this.dbgIndex] = swap;
                    this.clearDebugItem(toSave[idx]);
                    toSave[idx].msgType = GXDebugMsgType.SKIP;
                    toSave[idx].argObj = swap;
                    ++this.dbgIndex;
                    if (this.dbgIndex != this.current.length) continue;
                    int lastTop = this.current.length;
                    GXDebugItem[] tempL = new GXDebugItem[lastTop + BUFFER_INITIAL_SIZE];
                    System.arraycopy(this.current, 0, tempL, 0, lastTop);
                    this.current = tempL;
                    tempL = new GXDebugItem[lastTop + BUFFER_INITIAL_SIZE];
                    System.arraycopy(this.current, 0, tempL, 0, lastTop);
                    this.next = tempL;
                    for (int i = lastTop; i < this.current.length; ++i) {
                        this.current[i] = new GXDebugItem();
                        this.next[i] = new GXDebugItem();
                    }
                    continue;
                }
                ++saveCount;
            }
        } else {
            if (saveTop == 0) {
                return;
            }
            saveCount = saveTop;
        }
        Object idx = this.mSaveLock;
        synchronized (idx) {
            this.saving = true;
        }
        if (saveInThread) {
            final GXDebugItem[] mToSave = toSave;
            final int mSaveTop = saveTop;
            final int mSaveCount = saveCount;
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    GXDebugManager.this.mSave(mToSave, mSaveTop, mSaveCount);
                }
            });
        } else {
            this.mSave(toSave, saveTop, saveCount);
        }
    }

    protected void onExit(GXDebugInfo dbgInfo) {
        this.pushSystem(GXDebugMsgCode.EXIT.toByteInt());
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCleanup(GXDebugInfo dbgInfo) {
        this.pushSystem(GXDebugMsgCode.OBJ_CLEANUP.toByteInt(), dbgInfo.sId);
        Object object = sessionLock;
        synchronized (object) {
            if (dbgInfo.parent != null) {
                this.parentTable.put(dbgInfo.context.getHttpContext().getClientId(), dbgInfo.parent);
            } else {
                this.parentTable.remove(dbgInfo.context.getHttpContext().getClientId());
                if (!dbgInfo.context.isNullHttpContext()) {
                    this.save();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        Object object = this.saveLock;
        synchronized (object) {
            if (this.toSave != null) {
                this.save(this.toSave);
                this.toSave = null;
            }
            this.save(this.current, this.dbgIndex, false);
            this.dbgIndex = 0;
        }
    }

    private void clearDebugItem(GXDebugItem dbgItem) {
        dbgItem.msgType = GXDebugMsgType.INVALID;
        dbgItem.arg1 = 0;
        dbgItem.arg2 = 0;
        dbgItem.argObj = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void mSave(GXDebugItem[] data, int saveTop, int saveCount) {
        Object object = this.mSaveLock;
        synchronized (object) {
            GXDebugStream stream = null;
            try {
                try {
                    stream = GXDebugStream.getStream(fileName);
                    stream.writeHeader(this.sessionGuid, (short)(0x20 | GXDebugManager.GENERATOR_ID.toByteInt()), saveCount);
                    block19: for (int idx = 0; idx < saveTop; ++idx) {
                        GXDebugItem dbgItem = data[idx];
                        block4 : switch (dbgItem.msgType) {
                            case SYSTEM: {
                                stream.writeByte(dbgItem.msgType.toByteInt() | GXDebugMsgCode.valueOf(dbgItem.arg1).toByteInt());
                                switch (GXDebugMsgCode.valueOf(dbgItem.arg1)) {
                                    case INITIALIZE: {
                                        stream.writeLong(GXDebugManager.ToTicks((Date)dbgItem.argObj));
                                        break block4;
                                    }
                                    case OBJ_CLEANUP: {
                                        stream.writeVLUInt((Integer)dbgItem.argObj);
                                        break block4;
                                    }
                                    case EXIT: 
                                    case PGM_INFO: {
                                        Object[] info = (Object[])dbgItem.argObj;
                                        stream.writeVLUInt(((IntPair)info[0]).left);
                                        stream.writeVLUInt(((IntPair)info[0]).right);
                                        stream.writeVLUInt(((PgmInfo)info[1]).dbgLines);
                                        stream.writeInt(((PgmInfo)info[1]).hash);
                                        break block4;
                                    }
                                }
                                throw new IllegalArgumentException(String.format("Invalid DbgItem: %s", dbgItem));
                            }
                            case PGM_TRACE: {
                                stream.writePgmTrace(dbgItem.dbgInfo.sId, dbgItem.arg1, dbgItem.arg2, dbgItem.ticks);
                                break;
                            }
                            case PGM_TRACE_RANGE: 
                            case PGM_TRACE_RANGE_WITH_COLS: {
                                stream.writeByte(dbgItem.msgType.toByteInt());
                                stream.writeVLUInt(dbgItem.dbgInfo.sId);
                                stream.writeVLUInt(dbgItem.arg1);
                                stream.writeVLUInt(dbgItem.arg2);
                                if (dbgItem.msgType != GXDebugMsgType.PGM_TRACE_RANGE_WITH_COLS) break;
                                stream.writeVLUInt(((IntPair)dbgItem.argObj).left);
                                stream.writeVLUInt(((IntPair)dbgItem.argObj).right);
                                break;
                            }
                            case REGISTER_PGM: {
                                stream.writeByte(dbgItem.msgType.toByteInt());
                                stream.writeVLUInt(dbgItem.dbgInfo.sId);
                                stream.writeVLUInt(dbgItem.arg1);
                                stream.writeVLUInt(((IntPair)dbgItem.argObj).left);
                                stream.writeVLUInt(((IntPair)dbgItem.argObj).right);
                                break;
                            }
                            case SKIP: {
                                continue block19;
                            }
                        }
                        this.clearDebugItem(dbgItem);
                    }
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Exception e) {
                Log.warning("Cannot write debug file", "GXDebugManager", e);
            }
            this.saving = false;
            this.mSaveLock.notifyAll();
            return;
        }
    }

    private static long ToTicks(Date argObj) {
        return argObj.getTime() * 10000L + 621355968000000000L;
    }

    static {
        sessionLock = new Object();
        initialized = false;
        BUFFER_INITIAL_SIZE = 16383;
        fileName = "gxperf.gxd";
    }

    static class GXDebugStream
    extends FilterOutputStream {
        static final byte[] PROLOG = new byte[]{-1, -1, -1, 0};
        static final byte[] EPILOG = new byte[]{-1, -1, -1, 1};
        private int last = 0;
        private int lastLast = 0;
        private int LastSId;
        private int LastLine1;

        static GXDebugStream getStream(String fileName) throws IOException {
            try (FileOutputStream stream = new FileOutputStream(fileName, true);){
                GXDebugStream gXDebugStream = new GXDebugStream(new BufferedOutputStream(stream), stream.getChannel());
                return gXDebugStream;
            }
        }

        private GXDebugStream(OutputStream stream, FileChannel channel) throws IOException {
            this(stream);
            channel.lock();
        }

        GXDebugStream(OutputStream stream) {
            super(stream);
            this.initializeNewBlock();
        }

        @Override
        public void close() throws IOException {
            this.writeEpilog();
            super.close();
        }

        private void writeProlog(short version) throws IOException {
            this.writeRaw(PROLOG, 0, PROLOG.length);
            this.writeVLUShort(version);
        }

        private void writeEpilog() throws IOException {
            this.writeRaw(EPILOG, 0, EPILOG.length);
        }

        @Override
        public void write(byte[] data) throws IOException {
            this.write(data, 0, data.length);
        }

        void writeRaw(byte[] data, int from, int length) throws IOException {
            super.write(data, from, length);
        }

        void writeRaw(byte value) throws IOException {
            super.write(value);
        }

        @Override
        public void write(byte[] data, int offset, int count) throws IOException {
            while (count-- > 0) {
                this.writeByte(data[offset++]);
            }
        }

        @Override
        public void write(int value) throws IOException {
            this.writeByte(value);
        }

        void writeByte(int value) throws IOException {
            super.write(value);
            if (value == 255 && value == this.last && value == this.lastLast) {
                this.writeRaw((byte)3);
                this.lastLast = 0;
                this.last = 0;
            } else {
                this.lastLast = this.last;
                this.last = value;
            }
        }

        void writeVLUInt(int value) throws IOException {
            if (value < 0) {
                throw new IllegalArgumentException("Cannot handle negative values");
            }
            if ((long)value > 0x1FFFFFFFL) {
                throw new IllegalArgumentException("Cannot handle > 29bit values");
            }
            if (value < 128) {
                this.writeByte((byte)value);
            } else if (value < 16384) {
                this.writeVLUShort((short)(value & 0x3FFF));
            } else {
                this.writeVLUShort((short)(value & 0x3FFF | 0x4000));
                this.writeVLUShort((short)(value >> 14));
            }
        }

        void writeVLUShort(short value) throws IOException {
            if (value < 0) {
                throw new IllegalArgumentException("Cannot handle negative values");
            }
            if (value < 128) {
                this.writeByte((byte)value);
            } else {
                this.writeByte((byte)(value & 0x7F | 0x80));
                this.writeByte((byte)(value >> 7));
            }
        }

        void writeHeader(UUID sessionGuid, short version, int saveCount) throws IOException {
            this.writeProlog(version);
            this.writeVLUInt(saveCount);
            this.writeLong(sessionGuid.getLeastSignificantBits());
            this.writeLong(sessionGuid.getMostSignificantBits());
        }

        void writeLong(long value) throws IOException {
            for (int i = 0; i < 8; ++i) {
                this.writeByte((byte)(value & 0xFFL));
                value >>= 8;
            }
        }

        void writeInt(long value) throws IOException {
            for (int i = 0; i < 4; ++i) {
                this.writeByte((byte)(value & 0xFFL));
                value >>= 8;
            }
        }

        void writePgmTrace(int SId, int line1, int col, long ticks) throws IOException {
            int cmd = GXDebugMsgType.PGM_TRACE.toByteInt();
            if (col != 0) {
                cmd |= GXDebugMsgType.TRACE_HAS_COL.toByteInt();
            }
            boolean hasSId = false;
            switch (SId - this.LastSId) {
                case 0: {
                    break;
                }
                case 1: {
                    cmd |= 0x10;
                    break;
                }
                case -1: {
                    cmd |= 0x20;
                    break;
                }
                default: {
                    cmd |= GXDebugMsgType.TRACE_HAS_SID.toByteInt();
                    hasSId = true;
                }
            }
            int difLine1 = line1 - this.LastLine1;
            boolean hasLine1 = false;
            if (difLine1 < 8 && difLine1 > -8) {
                cmd |= (byte)(difLine1 & 0xF);
            } else {
                cmd |= GXDebugMsgType.TRACE_HAS_LINE1.toByteInt();
                hasLine1 = true;
            }
            this.writeByte(cmd);
            this.writeScaledLong(ticks);
            if (hasSId) {
                this.writeVLUInt(SId);
            }
            if (hasLine1) {
                this.writeVLUInt(line1);
            }
            if (col != 0) {
                this.writeVLUInt(col);
            }
            this.LastSId = SId;
            this.LastLine1 = line1;
        }

        void writeScaledLong(long N) throws IOException {
            if (N < 0L) {
                throw new IllegalArgumentException("Cannot handle negative values");
            }
            int m = 0;
            while (N > 31L) {
                N -= 32L;
                if (++m == 8) {
                    this.writeByte(0);
                    ++N;
                    m = 0;
                }
                N >>= 1;
            }
            if (m == 7 && N == 31L) {
                this.writeByte(0);
                this.writeByte(255);
            } else {
                this.writeByte((byte)(~(m << 5 | (byte)N)));
            }
        }

        void initializeNewBlock() {
            this.LastSId = 0;
            this.LastLine1 = 0;
        }

        class ESCAPE {
            static final byte PROLOG = 0;
            static final byte EPILOG = 1;
            static final byte TRIPLE_FF = 3;
            static final byte FF = -1;

            ESCAPE() {
            }
        }
    }

    static class Stopwatch {
        private long nanotime;

        public Stopwatch() {
            this.restart();
        }

        public long getElapsedMicroSecs() {
            return (System.nanoTime() - this.nanotime) / 1000L;
        }

        public final void restart() {
            this.nanotime = System.nanoTime();
        }
    }

    class PgmInfo {
        final int dbgLines;
        final long hash;

        PgmInfo(int dbgLines, long hash) {
            this.dbgLines = dbgLines;
            this.hash = hash;
        }

        public int hashCode() {
            return this.dbgLines ^ (int)this.hash;
        }

        public boolean equals(Object o) {
            return o instanceof PgmInfo && ((PgmInfo)o).dbgLines == this.dbgLines && ((PgmInfo)o).hash == this.hash;
        }
    }

    class IntPair {
        final int left;
        final int right;

        IntPair(int left, int right) {
            this.left = left;
            this.right = right;
        }

        public int hashCode() {
            return this.left ^ this.right;
        }

        public boolean equals(Object o) {
            return o instanceof IntPair && ((IntPair)o).left == this.left && ((IntPair)o).right == this.right;
        }
    }

    class GXDebugItem {
        GXDebugInfo dbgInfo;
        int arg1;
        int arg2;
        Object argObj;
        public long ticks;
        GXDebugMsgType msgType;

        GXDebugItem() {
        }

        public String toString() {
            return String.format("%s/%d:%s-%d-%s%s", new Object[]{this.msgType, this.dbgInfo != null ? this.dbgInfo.sId : 0, this.toStringArg1(), this.arg2, this.argObj != null ? this.argObj.toString() : "", this.toStringTicks()});
        }

        private String toStringArg1() {
            return this.msgType == GXDebugMsgType.SYSTEM ? GXDebugMsgCode.valueOf(this.arg1).toString() : String.format("%d", this.arg1);
        }

        private String toStringTicks() {
            return this.msgType == GXDebugMsgType.PGM_TRACE ? String.format(" elapsed:%d", this.ticks) : "";
        }
    }

    static enum GXDebugGenId {
        CSHARP(1),
        JAVA(2),
        INVALID(15);

        private final short value;

        private GXDebugGenId(int value) {
            this.value = (short)value;
        }

        private int toByteInt() {
            return this.value;
        }
    }

    static enum GXDebugMsgCode {
        INITIALIZE(0),
        OBJ_CLEANUP(1),
        EXIT(2),
        PGM_INFO(3),
        MASK_BITS(3);

        private final short value;

        private GXDebugMsgCode(int value) {
            this.value = (short)value;
        }

        static GXDebugMsgCode valueOf(int value) {
            switch (value) {
                case 0: {
                    return INITIALIZE;
                }
                case 1: {
                    return OBJ_CLEANUP;
                }
                case 2: {
                    return EXIT;
                }
                case 3: {
                    return PGM_INFO;
                }
            }
            throw new IllegalArgumentException(String.format("GXDebugMsgCode(%d)", value));
        }

        int toByteInt() {
            return this.value;
        }
    }

    static enum GXDebugMsgType {
        SYSTEM(128),
        PGM_TRACE(0),
        REGISTER_PGM(192),
        PGM_TRACE_RANGE(160),
        PGM_TRACE_RANGE_WITH_COLS(161),
        INVALID(254),
        SKIP(255),
        TRACE_HAS_COL(64),
        TRACE_HAS_SID(48),
        TRACE_HAS_LINE1(8);

        private final short value;

        private GXDebugMsgType(int value) {
            this.value = (short)value;
        }

        private int toByteInt() {
            return this.value;
        }
    }
}

