/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.internet;

import HTTPClient.ParseException;
import HTTPClient.URI;
import com.genexus.CommonUtil;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.internet.IHttpClient;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import json.org.json.JSONException;
import json.org.json.JSONObject;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class GXHttpClient
implements IHttpClient {
    protected final int BASIC = 0;
    protected final int DIGEST = 1;
    protected final int NTLM = 2;
    public final int ERROR_IO = 1;
    private String host;
    private String baseURL = "/";
    private int secure = 0;
    private int timeout = 30;
    private int port = 80;
    private boolean hostChanged = true;
    private Hashtable<String, String> headersToSend = new Hashtable();
    private String WSDLURL;
    private int errCode;
    private String errDescription = "";
    private String proxyHost = "";
    private int proxyPort = 80;
    private boolean proxyInfoChanged = false;
    private boolean includeCookies = true;
    private boolean tcpNoDelay = false;
    private Hashtable variablesToSend = new Hashtable();
    private Vector contentToSend = new Vector();
    private boolean isMultipart = false;
    private MultipartTemplate multipartTemplate = new MultipartTemplate();
    private String prevURLhost;
    private String prevURLbaseURL;
    private int prevURLport;
    private int prevURLsecure;
    private boolean isURL = false;
    private boolean authorizationChanged = false;
    private boolean authorizationProxyChanged = false;
    protected boolean isChunkedResponse;
    private Vector<HttpClientPrincipal> basicAuthorization = new Vector();
    private Vector<HttpClientPrincipal> digestAuthorization = new Vector();
    private Vector<HttpClientPrincipal> NTLMAuthorization = new Vector();
    private Vector<HttpClientPrincipal> basicProxyAuthorization = new Vector();
    private Vector<HttpClientPrincipal> digestProxyAuthorization = new Vector();
    private Vector<HttpClientPrincipal> NTLMProxyAuthorization = new Vector();
    public static boolean issuedExternalHttpClientWarning = false;
    public boolean usingExternalHttpClient = false;
    protected String contentEncoding = null;

    @Override
    public byte getBasic() {
        return 0;
    }

    @Override
    public byte getDigest() {
        return 1;
    }

    @Override
    public byte getNtlm() {
        return 2;
    }

    @Override
    public short getErrCode() {
        try {
            return (short)this.errCode;
        }
        catch (NullPointerException e) {
            this.errCode = 0;
            return 0;
        }
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    @Override
    public String getErrDescription() {
        return this.errDescription;
    }

    public void setErrDescription(String errDescription) {
        this.errDescription = errDescription;
    }

    @Override
    public void setProxyServerHost(String host) {
        this.proxyHost = host == null ? host : host.trim();
        this.proxyInfoChanged = true;
    }

    @Override
    public void setProxyServerPort(long port) {
        this.proxyPort = (int)port;
        this.proxyInfoChanged = true;
    }

    @Override
    public String getProxyServerHost() {
        return this.proxyHost;
    }

    @Override
    public short getProxyServerPort() {
        try {
            return (short)this.proxyPort;
        }
        catch (NullPointerException e) {
            this.proxyPort = 80;
            return 80;
        }
    }

    @Override
    public void setIncludeCookies(boolean value) {
        this.includeCookies = value;
        this.hostChanged = true;
    }

    @Override
    public boolean getIncludeCookies() {
        return this.includeCookies;
    }

    @Override
    public void setURL(String stringURL) {
        try {
            URI url = new URI(stringURL);
            this.setHost(url.getHost());
            this.setPort(url.getPort());
            this.setBaseURL(url.getPath());
            this.setSecure(url.getScheme().equalsIgnoreCase("https") ? 1 : 0);
        }
        catch (ParseException e) {
            System.err.println("E " + e + " " + stringURL);
            e.printStackTrace();
        }
    }

    @Override
    public void setHost(String host) {
        if (this.host == null || !this.host.equalsIgnoreCase(host)) {
            this.host = host == null ? host : host.trim();
            this.hostChanged = true;
            if (SpecificImplementation.HttpClient != null) {
                SpecificImplementation.HttpClient.addSDHeaders(this.host, this.baseURL, this.headersToSend);
            }
        }
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setWSDLURL(String WSDLURL) {
        this.WSDLURL = WSDLURL == null ? WSDLURL : WSDLURL.trim();
    }

    @Override
    public String getWSDLURL() {
        return this.WSDLURL;
    }

    @Override
    public void setBaseURL(String baseURL) {
        String string = this.baseURL = baseURL == null ? baseURL : baseURL.trim();
        if (SpecificImplementation.HttpClient != null) {
            SpecificImplementation.HttpClient.addSDHeaders(this.host, this.baseURL, this.headersToSend);
        }
    }

    @Override
    public String getBaseURL() {
        return this.baseURL;
    }

    @Override
    public void setPort(int port) {
        if (this.port != port) {
            this.port = port;
            this.hostChanged = true;
        }
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public byte getSecure() {
        return (byte)this.secure;
    }

    @Override
    public void setSecure(int secure) {
        if (this.secure != secure) {
            this.secure = secure;
            this.hostChanged = true;
        }
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public int getTimeout() {
        try {
            return this.timeout;
        }
        catch (NullPointerException e) {
            this.timeout = 30;
            return 30;
        }
    }

    @Override
    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        this.hostChanged = true;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public Hashtable<String, String> getheadersToSend() {
        return this.headersToSend;
    }

    public MultipartTemplate getMultipartTemplate() {
        return this.multipartTemplate;
    }

    public void setMultipartTemplate(MultipartTemplate multipartTemplate) {
        this.multipartTemplate = multipartTemplate;
    }

    public boolean getIsMultipart() {
        return this.isMultipart;
    }

    public void setIsMultipart(boolean isMultipart) {
        this.isMultipart = isMultipart;
    }

    public Vector<HttpClientPrincipal> getBasicAuthorization() {
        return this.basicAuthorization;
    }

    public Vector<HttpClientPrincipal> getDigestAuthorization() {
        return this.digestAuthorization;
    }

    public Vector<HttpClientPrincipal> getNTLMAuthorization() {
        return this.NTLMAuthorization;
    }

    public Vector<HttpClientPrincipal> getBasicProxyAuthorization() {
        return this.basicProxyAuthorization;
    }

    public Vector<HttpClientPrincipal> getDigestProxyAuthorization() {
        return this.digestProxyAuthorization;
    }

    public Vector<HttpClientPrincipal> getNTLMProxyAuthorization() {
        return this.NTLMProxyAuthorization;
    }

    @Override
    public void addCertificate(String fileName) {
    }

    @Override
    public void addAuthentication(int type, String realm, String name, String value) {
        this.setAuthorizationChanged(true);
        switch (type) {
            case 0: {
                if (this.basicAuthorization == null) {
                    this.basicAuthorization = new Vector();
                }
                this.basicAuthorization.addElement(new HttpClientPrincipal(realm, name, value));
                break;
            }
            case 1: {
                if (this.digestAuthorization == null) {
                    this.digestAuthorization = new Vector();
                }
                this.digestAuthorization.addElement(new HttpClientPrincipal(realm, name, value));
                break;
            }
            case 2: {
                if (this.NTLMAuthorization == null) {
                    this.NTLMAuthorization = new Vector();
                }
                this.NTLMAuthorization.addElement(new HttpClientPrincipal(realm, name, value));
            }
        }
    }

    @Override
    public void addProxyAuthentication(int type, String realm, String name, String value) {
        this.setAuthorizationProxyChanged(true);
        switch (type) {
            case 0: {
                if (this.basicProxyAuthorization == null) {
                    this.basicProxyAuthorization = new Vector();
                }
                this.basicProxyAuthorization.addElement(new HttpClientPrincipal(realm, name, value));
                break;
            }
            case 1: {
                if (this.digestProxyAuthorization == null) {
                    this.digestProxyAuthorization = new Vector();
                }
                this.digestProxyAuthorization.addElement(new HttpClientPrincipal(realm, name, value));
                break;
            }
            case 2: {
                if (this.NTLMProxyAuthorization == null) {
                    this.NTLMProxyAuthorization = new Vector();
                }
                this.NTLMProxyAuthorization.addElement(new HttpClientPrincipal(realm, name, value));
            }
        }
    }

    @Override
    public void addHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            try {
                int index = value.toLowerCase().lastIndexOf("charset");
                int equalsIndex = value.indexOf(61, index) + 1;
                String charset = value.substring(equalsIndex).trim();
                int lastIndex = charset.indexOf(32);
                if (lastIndex != -1) {
                    charset = charset.substring(0, lastIndex);
                }
                charset = charset.replace('\"', ' ').replace('\'', ' ').trim();
                this.contentEncoding = SpecificImplementation.HttpClient.normalizeEncodingName(charset, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value.toLowerCase().startsWith("multipart/form-data")) {
                this.isMultipart = true;
                value = this.multipartTemplate.contentType;
            }
        }
        if (this.headersToSend == null) {
            this.headersToSend = new Hashtable();
        }
        for (String elem : this.headersToSend.keySet()) {
            if (!elem.equalsIgnoreCase(name)) continue;
            this.headersToSend.put(elem, value);
            return;
        }
        this.headersToSend.put(name, value);
    }

    @Override
    public void addVariable(String name, String value) {
        if (this.variablesToSend == null) {
            this.variablesToSend = new Hashtable();
        }
        this.variablesToSend.put(name, value);
    }

    @Override
    public void addBytes(byte[] value) {
        if (this.contentToSend == null) {
            this.contentToSend = new Vector();
        }
        this.contentToSend.addElement(value);
    }

    @Override
    public void addString(String value) {
        if (this.contentToSend == null) {
            this.contentToSend = new Vector();
        }
        this.contentToSend.addElement(value);
    }

    @Override
    public void addFile(String fileName) {
        fileName = SpecificImplementation.HttpClient.beforeAddFile(fileName);
        this.contentToSend.addElement(new File(fileName));
    }

    @Override
    public void addFile(String fileName, String varName) {
        fileName = SpecificImplementation.HttpClient.beforeAddFile(fileName);
        this.contentToSend.addElement(new FormFile(fileName, varName));
    }

    @Override
    public void addStringWriter(StringWriter writer, StringBuffer encoding) {
        this.contentToSend.addElement(new Object[]{writer, encoding});
    }

    public boolean getHostChanged() {
        return this.hostChanged;
    }

    public void setHostChanged(boolean hostChanged) {
        this.hostChanged = hostChanged;
    }

    public Vector getContentToSend() {
        return this.contentToSend;
    }

    public void setContentToSend(Vector contentToSend) {
        this.contentToSend = contentToSend;
    }

    protected void resetState() {
        this.contentToSend.clear();
        this.variablesToSend.clear();
        this.contentToSend.removeAllElements();
        this.setMultipartTemplate(new MultipartTemplate());
        this.setIsMultipart(false);
    }

    @Override
    public abstract void execute(String var1, String var2);

    @Override
    public abstract int getStatusCode();

    @Override
    public abstract String getReasonLine();

    @Override
    public abstract void getHeader(String var1, long[] var2);

    @Override
    public abstract String getHeader(String var1);

    @Override
    public abstract void getHeader(String var1, String[] var2);

    @Override
    public abstract void getHeader(String var1, Date[] var2);

    @Override
    public abstract void getHeader(String var1, double[] var2);

    @Override
    public abstract InputStream getInputStream() throws IOException;

    @Override
    public abstract String getString();

    @Override
    public abstract String readChunk();

    @Override
    public abstract boolean getEof();

    @Override
    public abstract void toFile(String var1);

    @Override
    public abstract void cleanup();

    public void setVariablesToSend(Hashtable variablesToSend) {
        this.variablesToSend = variablesToSend;
    }

    public Hashtable getVariablesToSend() {
        return this.variablesToSend;
    }

    public boolean isMultipart() {
        return this.isMultipart;
    }

    public void setMultipart(boolean multipart) {
        this.isMultipart = multipart;
    }

    public String getPrevURLhost() {
        return this.prevURLhost;
    }

    public void setPrevURLhost(String prevURLhost) {
        this.prevURLhost = prevURLhost;
    }

    public String getPrevURLbaseURL() {
        return this.prevURLbaseURL;
    }

    public void setPrevURLbaseURL(String prevURLbaseURL) {
        this.prevURLbaseURL = prevURLbaseURL;
    }

    public int getPrevURLport() {
        return this.prevURLport;
    }

    public void setPrevURLport(int prevURLport) {
        this.prevURLport = prevURLport;
    }

    public int getPrevURLsecure() {
        return this.prevURLsecure;
    }

    public void setPrevURLsecure(int prevURLsecure) {
        this.prevURLsecure = prevURLsecure;
    }

    public boolean getIsURL() {
        return this.isURL;
    }

    public void setIsURL(boolean isURL) {
        this.isURL = isURL;
    }

    protected String setPathUrl(String url) {
        if (!this.getIsURL()) {
            if (!this.getBaseURL().isEmpty()) {
                if (!this.getBaseURL().startsWith("/") && !this.getBaseURL().startsWith("http")) {
                    this.setBaseURL("/" + this.getBaseURL());
                }
                url = url.isEmpty() ? this.getBaseURL() : (!url.startsWith("/") ? this.getBaseURL() + (this.getBaseURL().endsWith("/") ? url.trim() : "/" + url.trim()) : this.getBaseURL() + (this.getBaseURL().endsWith("/") ? url.substring(1).trim() : url.trim()));
            } else if (!url.startsWith("/")) {
                url = "/" + url.trim();
            }
        }
        return url;
    }

    protected byte[] getData() {
        byte[] out = new byte[]{};
        for (Object key : this.getVariablesToSend().keySet()) {
            String value = this.getMultipartTemplate().getFormDataTemplate((String)key, (String)this.getVariablesToSend().get(key));
            this.getContentToSend().add(0, value);
        }
        for (int idx = 0; idx < this.getContentToSend().size(); ++idx) {
            File file;
            Object curr = this.getContentToSend().elementAt(idx);
            if (curr instanceof String) {
                try {
                    if (this.contentEncoding != null) {
                        out = this.addToArray(out, ((String)curr).getBytes(this.contentEncoding));
                        continue;
                    }
                    out = this.addToArray(out, (String)curr);
                }
                catch (UnsupportedEncodingException e) {
                    System.err.println(e.toString());
                    out = this.addToArray(out, (String)curr);
                }
                continue;
            }
            if (curr instanceof Object[]) {
                StringWriter writer = (StringWriter)((Object[])curr)[0];
                StringBuffer encoding = (StringBuffer)((Object[])curr)[1];
                if (encoding == null || encoding.length() == 0) {
                    encoding = new StringBuffer("UTF-8");
                }
                try {
                    out = this.addToArray(out, writer.toString().getBytes(encoding.toString()));
                }
                catch (UnsupportedEncodingException e) {
                    out = this.addToArray(out, writer.toString());
                }
                continue;
            }
            if (curr instanceof byte[]) {
                out = this.addToArray(out, (byte[])curr);
                continue;
            }
            if (curr instanceof FormFile) {
                FormFile formFile = (FormFile)curr;
                out = this.startMultipartFile(out, formFile.name, formFile.file);
                file = new File(formFile.file);
            } else {
                file = (File)curr;
            }
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
                out = this.addToArray(out, CommonUtil.readToByteArray(bis));
                continue;
            }
            catch (FileNotFoundException e) {
                this.setErrCode(1);
                this.setErrDescription(e.getMessage());
                continue;
            }
            catch (IOException e) {
                this.setErrCode(1);
                this.setErrDescription(e.getMessage());
            }
        }
        out = this.endMultipartBoundary(out);
        return out;
    }

    private byte[] startMultipartFile(byte[] in, String name, String fileName) {
        if (this.getIsMultipart() && CommonUtil.fileExists(fileName) == 1) {
            if (name == null || name == "") {
                name = CommonUtil.getFileName(fileName);
            }
            byte[] out = this.addToArray(in, this.getMultipartTemplate().boundarybytes);
            String mimeType = SpecificImplementation.Application.getContentType(fileName);
            String header = this.getMultipartTemplate().getHeaderTemplate(name, fileName, mimeType);
            try {
                byte[] headerbytes = header.getBytes("UTF8");
                out = this.addToArray(out, headerbytes);
            }
            catch (UnsupportedEncodingException uee) {
                byte[] headerbytes = header.getBytes();
                out = this.addToArray(out, headerbytes);
            }
            return out;
        }
        return in;
    }

    private byte[] endMultipartBoundary(byte[] in) {
        if (this.getIsMultipart()) {
            return this.addToArray(in, this.getMultipartTemplate().endBoundaryBytes);
        }
        return in;
    }

    private byte[] addToArray(byte[] in, String val) {
        byte[] out = new byte[in.length + val.length()];
        System.arraycopy(in, 0, out, 0, in.length);
        out = val.getBytes();
        return out;
    }

    private byte[] addToArray(byte[] in, byte[] val) {
        byte[] out = new byte[in.length + val.length];
        System.arraycopy(in, 0, out, 0, in.length);
        System.arraycopy(val, 0, out, in.length, val.length);
        return out;
    }

    protected void setExceptionsCatch(Exception e) {
        this.setErrCode(1);
        this.setErrDescription(e.getMessage());
    }

    public boolean getAuthorizationChanged() {
        return this.authorizationChanged;
    }

    public void setAuthorizationChanged(boolean authorizationChanged) {
        this.authorizationChanged = authorizationChanged;
    }

    public boolean getAuthorizationProxyChanged() {
        return this.authorizationProxyChanged;
    }

    public void setAuthorizationProxyChanged(boolean authorizationProxyChanged) {
        this.authorizationProxyChanged = authorizationProxyChanged;
    }

    public boolean getProxyInfoChanged() {
        return this.proxyInfoChanged;
    }

    public void setProxyInfoChanged(boolean proxyInfoChanged) {
        this.proxyInfoChanged = proxyInfoChanged;
    }

    class MultipartTemplate {
        public String boundary = "----------------------------" + CommonUtil.now(false, false).getTime();
        public String formdataTemplate;
        public byte[] boundarybytes;
        public byte[] endBoundaryBytes;
        public String contentType = "multipart/form-data; boundary=" + this.boundary;

        public MultipartTemplate() {
            String boundaryStr = "\r\n--" + this.boundary + "\r\n";
            String endBoundaryStr = "\r\n--" + this.boundary + "--";
            try {
                this.boundarybytes = boundaryStr.getBytes("ASCII");
                this.endBoundaryBytes = endBoundaryStr.getBytes("ASCII");
            }
            catch (UnsupportedEncodingException uee) {
                this.boundarybytes = boundaryStr.getBytes();
                this.endBoundaryBytes = endBoundaryStr.getBytes();
            }
        }

        String getHeaderTemplate(String name, String fileName, String mimeType) {
            fileName = new File(fileName).getName();
            return "Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + fileName + "\"\r\nContent-Type: " + mimeType + "\r\n\r\n";
        }

        String getFormDataTemplate(String varName, String value) {
            String contentType = this.getContentTypeFromString(value);
            return "\r\n--" + this.boundary + "\r\nContent-Disposition: form-data; name=\"" + varName + "\";\r\n" + (contentType != null ? "Content-Type: " + contentType + "\r\n" : "") + "\r\n" + value;
        }

        private String getContentTypeFromString(String value) {
            if (this.isJsonString(value)) {
                return "application/json";
            }
            if (this.isXMLString(value)) {
                return "text/xml";
            }
            return null;
        }

        private boolean isJsonString(String value) {
            try {
                JSONObject json = new JSONObject(value);
                return true;
            }
            catch (JSONException e) {
                return false;
            }
        }

        private boolean isXMLString(String value) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                InputSource inputSource = new InputSource(new StringReader(value));
                builder.setErrorHandler(new DefaultHandler());
                Document document = builder.parse(inputSource);
                return true;
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                return false;
            }
        }
    }

    class HttpClientPrincipal {
        String realm;
        String user;
        String password;

        HttpClientPrincipal(String realm, String user, String password) {
            this.realm = realm;
            this.user = user;
            this.password = password;
        }
    }

    class FormFile {
        String file;
        String name;

        FormFile(String file, String name) {
            this.file = file;
            this.name = name;
        }
    }
}

