/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.internet;

import com.genexus.common.interfaces.SpecificImplementation;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Stack;
import json.org.json.JSONArray;

public class GXNavigationHelper
implements Serializable {
    private static final long serialVersionUID = 2608956804836620190L;
    public static String POPUP_LEVEL = "gxPopupLevel";
    public static String CALLED_AS_POPUP = "gxCalledAsPopup";
    private Hashtable<String, Stack<String>> referers = new Hashtable();

    public String toJSonString(String lvl) {
        JSONArray array = new JSONArray();
        if (this.referers.containsKey(lvl)) {
            Stack<String> levelStack = this.referers.get(lvl);
            for (int i = 0; i < levelStack.size(); ++i) {
                array.put(levelStack.get(i));
            }
        }
        return array.toString();
    }

    public void pushUrl(String url) {
        if (url.indexOf(CALLED_AS_POPUP) != -1) {
            return;
        }
        String popupLevel = this.getUrlPopupLevel(url);
        if (!this.referers.containsKey(popupLevel)) {
            Stack<String> stack = new Stack<String>();
            stack.push(url);
            this.referers.put(popupLevel, stack);
        } else {
            Stack<String> stack = this.referers.get(popupLevel);
            stack.push(url);
        }
    }

    public void popUrl(String url) {
        Stack<String> stack;
        if (url.indexOf(CALLED_AS_POPUP) != -1) {
            return;
        }
        String popupLevel = this.getUrlPopupLevel(url);
        if (this.referers.containsKey(popupLevel) && (stack = this.referers.get(popupLevel)).size() > 0) {
            stack.pop();
        }
    }

    public String peekUrl(String url) {
        Stack<String> stack;
        if (url.indexOf(CALLED_AS_POPUP) != -1) {
            return "";
        }
        String popupLevel = this.getUrlPopupLevel(url);
        if (this.referers.containsKey(popupLevel) && (stack = this.referers.get(popupLevel)).size() > 0) {
            return stack.peek();
        }
        return "";
    }

    public String getRefererUrl(String url) {
        Stack<String> stack;
        if (url.indexOf(CALLED_AS_POPUP) != -1) {
            return "";
        }
        String popupLevel = this.getUrlPopupLevel(url);
        if (this.referers.containsKey(popupLevel) && (stack = this.referers.get(popupLevel)).size() > 1) {
            String topUrl = stack.pop();
            String referer = stack.peek();
            stack.push(topUrl);
            return referer;
        }
        return "";
    }

    public int count() {
        return this.referers.size();
    }

    public void deleteStack(String popupLevel) {
        if (this.referers.containsKey(popupLevel)) {
            this.referers.remove(popupLevel);
        }
    }

    public String getUrlPopupLevel(String url) {
        int cIdx;
        int eqIdx;
        int pIdx;
        url = SpecificImplementation.GXutil.URLDecode(url);
        String popupLevel = "-1";
        if (url != null && (pIdx = url.indexOf(POPUP_LEVEL)) != -1 && (eqIdx = url.indexOf("=", pIdx)) != -1 && (cIdx = url.indexOf(";", eqIdx)) > eqIdx) {
            try {
                popupLevel = url.substring(eqIdx + 1, cIdx);
            }
            catch (Exception e) {
                popupLevel = "-1";
            }
        }
        return popupLevel;
    }
}

