/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.internet;

import java.io.UnsupportedEncodingException;

public class JapaneseMimeDecoder {
    private static String[] encodingStarts = new String[]{"\u001b$B", "\u001b$@"};
    private static String[] encodingEnds = new String[]{"\u001b(B", "\u001b(J"};

    public static String decode(String encoded) {
        int strLen = encoded.length();
        int currentIndex = 0;
        StringBuffer buffer = new StringBuffer();
        while (currentIndex < strLen) {
            int encStart = JapaneseMimeDecoder.getEncodedLimit(encodingStarts, encoded, currentIndex);
            int encEnd = JapaneseMimeDecoder.getEncodedLimit(encodingEnds, encoded, encStart + 3);
            if (encStart == -1 || encEnd == -1) break;
            if (currentIndex < encStart) {
                buffer.append(encoded.substring(currentIndex, encStart));
            }
            String encodedPart = encoded.substring(encStart, encEnd + 3);
            try {
                buffer.append(new String(encodedPart.getBytes(), "ISO-2022-JP"));
            }
            catch (UnsupportedEncodingException ex) {
                buffer.append(encodedPart);
            }
            currentIndex = encEnd + 3;
        }
        if (currentIndex < strLen) {
            buffer.append(encoded.substring(currentIndex));
        }
        return buffer.toString();
    }

    private static int getEncodedLimit(String[] limiters, String str, int fromIdx) {
        for (int i = 0; i < limiters.length; ++i) {
            int idx = str.indexOf(limiters[i], fromIdx);
            if (idx == -1) continue;
            return idx;
        }
        return -1;
    }
}

