/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.internet;

import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.internet.GXInternetConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class RFC822EndReader
extends BufferedReader
implements GXInternetConstants {
    private String lastLine;
    private boolean isEndOfMessage = false;
    private static final ILogger logger = LogManager.getLogger(RFC822EndReader.class);

    public RFC822EndReader(Reader reader) {
        super(reader);
    }

    private int log(int line) {
        logger.debug("byte: " + line);
        return line;
    }

    private String log(String line) {
        logger.debug("Line: " + line);
        return line;
    }

    @Override
    public int read() throws IOException {
        if (this.isEndOfMessage) {
            return -1;
        }
        return this.log(super.read());
    }

    @Override
    public String readLine() throws IOException {
        String out;
        if (this.isEndOfMessage) {
            return null;
        }
        if (this.lastLine == null) {
            out = this.log(super.readLine());
        } else {
            out = this.lastLine;
            this.lastLine = null;
        }
        if (out != null) {
            if (out.equals("")) {
                this.lastLine = this.log(super.readLine());
                if (this.lastLine.equals(".")) {
                    this.isEndOfMessage = true;
                    out = null;
                    this.lastLine = null;
                }
            } else if (out.startsWith(".")) {
                if (out.equals(".")) {
                    this.isEndOfMessage = true;
                    out = null;
                    this.lastLine = null;
                } else {
                    out = out.substring(1, out.length());
                }
            }
        }
        return out;
    }
}

