/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.internet;

import com.genexus.CommonUtil;
import com.genexus.GXBaseCollection;
import com.genexus.SdtMessages_Message;
import com.genexus.internet.IGxJSONAble;
import com.genexus.util.FastVector;
import java.util.Enumeration;
import java.util.StringTokenizer;
import json.org.json.IJsonFormattable;
import json.org.json.JSONArray;

public class StringCollection
implements IGxJSONAble {
    JSONArray jsonArr = new JSONArray();
    FastVector vector = new FastVector();

    public void add(String value) {
        this.vector.addElement(value);
    }

    public void insertAt(int position, String value) {
        this.vector.insertElementAt(value, position);
    }

    public void removeAllItems() {
        this.vector.removeAllElements();
    }

    public void clear() {
        this.vector.removeAllElements();
    }

    public String item(int idx) {
        return (String)this.vector.elementAt(idx - 1);
    }

    public int getCount() {
        return this.vector.size();
    }

    public String toString() {
        String result = "";
        for (int i = 1; i <= this.getCount(); ++i) {
            result = result + this.item(i);
        }
        return result;
    }

    String getString() {
        StringBuffer b = new StringBuffer();
        Enumeration en = this.vector.elements();
        while (en.hasMoreElements()) {
            b.append((String)en.nextElement());
            if (!en.hasMoreElements()) continue;
            b.append(";");
        }
        return b.toString();
    }

    static StringCollection getFromString(String list) {
        StringCollection ret = new StringCollection();
        StringTokenizer tokenizer = new StringTokenizer(list, ";");
        while (tokenizer.hasMoreTokens()) {
            ret.add(tokenizer.nextToken());
        }
        return ret;
    }

    public boolean fromJSonString(String list) {
        return this.fromJSonString(list, null);
    }

    public boolean fromJSonString(String list, GXBaseCollection<SdtMessages_Message> messages) {
        try {
            if (list.startsWith("[") && list.endsWith("]")) {
                StringTokenizer tokenizer = new StringTokenizer(list.substring(1, list.length() - 1), ",");
                while (tokenizer.hasMoreTokens()) {
                    this.add(this.removeStringDelimiters(tokenizer.nextToken()));
                }
            }
            return true;
        }
        catch (Exception ex) {
            CommonUtil.ErrorToMessages("fromjson error", ex.getMessage(), messages);
            return false;
        }
    }

    public String removeStringDelimiters(String token) {
        if (token.startsWith("\"") && token.endsWith("\"")) {
            token = token.substring(1, token.length() - 1);
        }
        return token;
    }

    @Override
    public void tojson() {
        this.jsonArr = new JSONArray();
        for (int i = 0; i < this.getCount(); ++i) {
            this.AddObjectProperty(this.vector.elementAt(i));
        }
    }

    @Override
    public void AddObjectProperty(String name, Object prop) {
        this.AddObjectProperty(prop);
    }

    public void AddObjectProperty(Object prop) {
        if (prop instanceof IGxJSONAble) {
            this.jsonArr.put(((IGxJSONAble)prop).GetJSONObject());
        } else {
            this.jsonArr.put(prop.toString());
        }
    }

    @Override
    public Object GetJSONObject(boolean includeState) {
        return this.GetJSONObject();
    }

    @Override
    public Object GetJSONObject() {
        this.tojson();
        return this.jsonArr;
    }

    @Override
    public void FromJSONObject(IJsonFormattable obj) {
    }

    @Override
    public String ToJavascriptSource() {
        return this.GetJSONObject().toString();
    }
}

