/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.reports;

import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ParseINI {
    public static final ILogger logger = LogManager.getLogger(ParseINI.class);
    private static final int MAX_LINE_LENGTH = 255;
    private static final byte SECTION_SEPARATOR_CHAR = 38;
    private static final String SECTION_SEPARATOR = "&";
    private static final String GENERAL = "&General&";
    private String entryName;
    private InputStreamReader inputStream;
    private Hashtable<String, Hashtable<String, String>> sections = new Hashtable();
    private Hashtable sectionEntries;
    private Hashtable<String, String> general;
    private Hashtable<String, String> aliased = new Hashtable();
    private Hashtable<String, String> alias = new Hashtable();
    private boolean need2Save = false;
    private boolean autoSave = true;
    private String filename = null;
    int[] tempBytes = new int[16384];

    public ParseINI() {
        this.general = new Hashtable();
        this.filename = null;
    }

    public ParseINI(String filename) throws IOException {
        this.init(filename);
    }

    public ParseINI(String filename, String configurationTemplateFile) throws IOException {
        try {
            File templateFile;
            File file = new File(filename);
            if (!file.exists() && (templateFile = new File(configurationTemplateFile)).exists()) {
                SpecificImplementation.FileUtils.copyFile(templateFile, file);
            }
        }
        catch (IOException ex) {
            logger.error("Error parsing ini " + filename + " template:" + configurationTemplateFile, ex);
        }
        this.init(filename);
    }

    private void init(String filename) throws IOException {
        this.filename = new File(filename).getAbsolutePath();
        try (FileInputStream inputStream = new FileInputStream(filename);){
            this.load(inputStream);
        }
        catch (FileNotFoundException fnfe) {
            new FileWriter(filename).close();
            this.general = new Hashtable();
        }
    }

    public ParseINI(InputStream inputStream) throws IOException {
        this.load(inputStream);
    }

    public boolean need2Save() {
        return this.need2Save;
    }

    public void finalize() {
        if (this.autoSave && this.need2Save) {
            try {
                this.save();
            }
            catch (IOException e) {
                System.out.println("ParseINI (" + this.filename + "):" + e);
            }
        }
    }

    public Enumeration sectionElements() {
        return this.sections.elements();
    }

    public Enumeration sectionNames() {
        return this.sections.keys();
    }

    public Hashtable getSection(String section) {
        if (this.sections.containsKey(section)) {
            return (Hashtable)this.sections.get(section).clone();
        }
        return null;
    }

    public boolean getBooleanProperty(String section, String property, boolean byDefault) {
        if (byDefault) {
            return !this.getProperty(section, property, "true").equalsIgnoreCase("false");
        }
        return this.getProperty(section, property, "false").equalsIgnoreCase("true");
    }

    public boolean getBooleanGeneralProperty(String property, boolean byDefault) {
        if (byDefault) {
            return !this.getGeneralProperty(property, "true").equalsIgnoreCase("false");
        }
        return this.getGeneralProperty(property, "false").equalsIgnoreCase("true");
    }

    public boolean sectionExists(String section) {
        return this.sections.containsKey(section);
    }

    public void removeSection(String section) {
        this.need2Save |= this.sections.remove(section) != null;
    }

    public void removeProperty(String section, String prop) {
        if (this.sections.containsKey(section)) {
            this.need2Save |= this.sections.get(section).remove(prop) != null;
        }
    }

    public void removeGeneralProperty(String prop) {
        this.need2Save |= this.general.remove(prop) != null;
    }

    public String getGeneralProperty(String prop) {
        return this.getProperty(this.general, prop, null);
    }

    public String getGeneralProperty(String prop, String defecto) {
        return this.getProperty(this.general, prop, defecto);
    }

    public void setGeneralProperty(String prop, String value) {
        this.need2Save |= !value.equals(this.general.put(prop, value));
    }

    public boolean setupGeneralProperty(String prop, String value) {
        if (this.general.containsKey(prop)) {
            return false;
        }
        this.setGeneralProperty(prop, value);
        return true;
    }

    public boolean setupProperty(String section, String prop, String value) {
        if (this.getProperty(section, prop) != null) {
            return false;
        }
        this.setProperty(section, prop, value);
        return true;
    }

    public void setProperty(String section, String prop, String value) {
        if (!this.sections.containsKey(section)) {
            this.sections.put(section, new Hashtable());
        }
        this.need2Save |= !value.equals(this.sections.get(section).put(prop, value)) && value.length() != 0;
    }

    public String getProperty(String section, String prop) {
        return this.getProperty(this.sections.get(section), prop, null);
    }

    public String getProperty(String section, String prop, String defecto) {
        return this.getProperty(this.sections.get(section), prop, defecto);
    }

    private String getProperty(Hashtable<String, String> section, String prop, String defecto) {
        if (section != null && section.containsKey(prop)) {
            return section.get(prop);
        }
        if (section != null && this.alias.containsKey(prop)) {
            return this.getProperty(section, this.alias.get(prop), defecto);
        }
        return defecto;
    }

    public boolean addItemToProperty(String section, String prop, String item, String separator) {
        Vector<String> tempVector = ParseINI.parseLine(this.getProperty(section, prop), separator);
        if (tempVector.contains(item)) {
            return false;
        }
        tempVector.addElement(item);
        String temp = "";
        Enumeration<String> enumera = tempVector.elements();
        while (enumera.hasMoreElements()) {
            temp = temp + enumera.nextElement() + separator;
        }
        this.setProperty(section, prop, temp);
        return true;
    }

    public boolean addItemToGeneralProperty(String prop, String item, String separator) {
        Vector<String> tempVector = ParseINI.parseLine(this.getGeneralProperty(prop), separator);
        if (tempVector.contains(item)) {
            return false;
        }
        tempVector.addElement(item);
        String temp = "";
        Enumeration<String> enumera = tempVector.elements();
        while (enumera.hasMoreElements()) {
            temp = temp + enumera.nextElement() + separator;
        }
        this.setGeneralProperty(prop, temp);
        return true;
    }

    public boolean removeItemFromProperty(String section, String prop, String item, String separator) {
        Vector<String> tempVector = ParseINI.parseLine(this.getProperty(section, prop), separator);
        if (!tempVector.contains(item)) {
            return false;
        }
        tempVector.removeElement(item);
        String temp = "";
        Enumeration<String> enumera = tempVector.elements();
        while (enumera.hasMoreElements()) {
            temp = temp + enumera.nextElement() + separator;
        }
        if (temp.equals("")) {
            this.removeProperty(section, prop);
        } else {
            this.setProperty(section, prop, temp);
        }
        return true;
    }

    public boolean removeItemFromGeneralProperty(String prop, String item, String separator) {
        Vector<String> tempVector = ParseINI.parseLine(this.getGeneralProperty(prop), separator);
        if (!tempVector.contains(item)) {
            return false;
        }
        tempVector.removeElement(item);
        String temp = "";
        Enumeration<String> enumera = tempVector.elements();
        while (enumera.hasMoreElements()) {
            temp = temp + enumera.nextElement() + separator;
        }
        if (temp.equals("")) {
            this.removeGeneralProperty(prop);
        } else {
            this.setGeneralProperty(prop, temp);
        }
        return true;
    }

    public boolean setAlias(String alias, String original) {
        if (!this.sections.containsKey(original)) {
            return false;
        }
        this.aliased.put(original, alias);
        this.alias.put(alias, original);
        return true;
    }

    public boolean renameSection(String nuevo, String original) {
        if (!this.sections.containsKey(original) || this.sections.containsKey(nuevo)) {
            return false;
        }
        if (!original.equals(nuevo)) {
            this.sections.put(nuevo, this.sections.get(original));
            this.sections.remove(original);
            this.need2Save = true;
        }
        return true;
    }

    public boolean isAliased(String original) {
        return this.aliased.containsKey(original);
    }

    public String getAlias(String original) {
        if (this.isAliased(original)) {
            return this.aliased.get(original);
        }
        return original;
    }

    public void load(InputStream iStream) throws IOException {
        this.inputStream = new InputStreamReader(iStream, "UTF8");
        this.sectionEntries = new Hashtable();
        this.sections.put(GENERAL, this.sectionEntries);
        try {
            while ((this.entryName = this.readEntryName()) != null) {
                this.sectionEntries.put(this.entryName, this.readEntry());
            }
            this.inputStream.close();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.general = this.sections.get(GENERAL);
        this.sections.remove(GENERAL);
    }

    public void save() throws IOException {
        if (this.need2Save && this.filename != null) {
            try (FileOutputStream fos = new FileOutputStream(this.filename);){
                this.save(fos);
            }
        }
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public boolean serializeSection(String section, OutputStream out, boolean sendGeneral) throws IOException {
        if (!this.sections.containsKey(section)) {
            return false;
        }
        ObjectOutputStream serialOut = new ObjectOutputStream(out);
        serialOut.writeObject(section);
        out.flush();
        serialOut.writeObject(this.sections.get(section));
        out.flush();
        serialOut.writeObject(new Boolean(sendGeneral));
        out.flush();
        if (sendGeneral) {
            serialOut.writeObject(this.general);
        }
        out.flush();
        return true;
    }

    public String unserializeSection(InputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream serialIn = new ObjectInputStream(in);
        String section = (String)serialIn.readObject();
        Hashtable loadedSection = (Hashtable)serialIn.readObject();
        if (!this.sections.containsKey(section) || !this.sections.get(section).equals(loadedSection)) {
            this.sections.put(section, loadedSection);
            this.need2Save = true;
        }
        if (((Boolean)serialIn.readObject()).booleanValue()) {
            this.general = (Hashtable)serialIn.readObject();
        }
        return section;
    }

    public void save(OutputStream oStream) throws IOException {
        int it;
        String value;
        String prop;
        Enumeration<String> props;
        OutputStreamWriter outputStream = new OutputStreamWriter(oStream, "UTF8");
        if (this.general != null) {
            props = this.general.keys();
            while (props.hasMoreElements()) {
                prop = props.nextElement();
                value = this.getGeneralProperty(prop);
                if (value.equals("")) continue;
                it = value.length() + prop.length() + 4 > 255 ? 255 - prop.length() - 4 : value.length();
                outputStream.write(prop + "= " + value.substring(0, it) + "\r\n");
                while (value.length() - it > 251) {
                    outputStream.write(" " + value.substring(it, it + 251) + "\r\n");
                    it += 251;
                }
                if (it >= value.length()) continue;
                outputStream.write(" " + value.substring(it) + "\r\n");
            }
        }
        Enumeration secs = this.sectionNames();
        while (secs.hasMoreElements()) {
            String section = (String)secs.nextElement();
            outputStream.write("\r\n[" + section + "]\r\n");
            props = this.sections.get(section).keys();
            while (props.hasMoreElements()) {
                prop = props.nextElement();
                value = this.getProperty(section, prop);
                if (value.equals("")) continue;
                it = value.length() + prop.length() + 4 > 255 ? 255 - prop.length() - 4 : value.length();
                outputStream.write(prop + "= " + value.substring(0, it) + "\r\n");
                while (value.length() - it > 251) {
                    outputStream.write(" " + value.substring(it, it + 255 - 4) + "\r\n");
                    it += 251;
                }
                if (it >= value.length()) continue;
                outputStream.write(" " + value.substring(it) + "\r\n");
            }
        }
        outputStream.close();
        this.need2Save = false;
    }

    private String readEntryName() throws IOException {
        int offset = 0;
        int car = 0;
        block6: while (car != -1) {
            car = this.inputStream.read();
            switch (car) {
                case 37: 
                case 42: {
                    while ((car = this.inputStream.read()) != 10 && car != 13 && car != -1) {
                    }
                    continue block6;
                }
                case 32: {
                    if (this.entryName == null) {
                        throw new IOException("Invalid entry");
                    }
                    this.sectionEntries.put(this.entryName, (String)this.sectionEntries.get(this.entryName) + this.readEntry());
                    return this.readEntryName();
                }
                case 91: {
                    this.sectionEntries = new Hashtable();
                    String sectionName = this.readEntry();
                    sectionName = sectionName.substring(0, sectionName.length() - 1);
                    this.sections.put(sectionName, this.sectionEntries);
                    this.entryName = null;
                    return this.readEntryName();
                }
                case -1: 
                case 10: 
                case 13: {
                    continue block6;
                }
            }
            this.tempBytes[offset++] = car;
            while ((car = this.inputStream.read()) != 58 && car != 61 && car != -1) {
                this.tempBytes[offset++] = car;
            }
            if (offset == 4 && this.tempBytes[0] == 78 && this.tempBytes[1] == 97 && this.tempBytes[2] == 109 && this.tempBytes[3] == 101) {
                this.sectionEntries = new Hashtable();
                String section = this.readEntry();
                if (section.startsWith("./")) {
                    section = section.substring(2);
                }
                this.sections.put(section, this.sectionEntries);
                this.entryName = null;
                return this.readEntryName();
            }
            return new String(this.tempBytes, 0, offset);
        }
        return null;
    }

    private String readEntry() throws IOException {
        int offset = 0;
        int car = this.inputStream.read();
        if (car == -1) {
            return "";
        }
        while (Character.isWhitespace((char)car)) {
            if (car == 0 || car == 10 || car == 13 || car == -1) {
                return "";
            }
            car = this.inputStream.read();
        }
        this.tempBytes[offset++] = car;
        try {
            while ((car = this.inputStream.read()) != 0 && car != 10 && car != 13 && car != -1) {
                this.tempBytes[offset++] = car;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new String(this.tempBytes, 0, offset);
    }

    public static String removeExtraSpaces(String line) {
        int index;
        if (line == null) {
            return null;
        }
        int lineLength = line.length();
        char[] b = new char[lineLength];
        if (lineLength == 0) {
            return line;
        }
        for (index = 0; index < lineLength && line.charAt(index) == ' '; ++index) {
        }
        int offset = 0;
        while (index < lineLength - 1) {
            if (line.charAt(index) != ' ' || line.charAt(index + 1) != ' ') {
                b[offset++] = line.charAt(index);
            }
            ++index;
        }
        b[offset++] = line.charAt(index);
        return new String(b, 0, offset);
    }

    public static Vector<String> parseLine(String line, String separator) {
        Vector<String> partes = new Vector<String>();
        if (line == null) {
            return partes;
        }
        StringTokenizer tokens = new StringTokenizer(line, separator, false);
        if (!tokens.hasMoreTokens()) {
            return partes;
        }
        String lastToken = tokens.nextToken();
        while (tokens.hasMoreTokens()) {
            String thisToken = tokens.nextToken();
            if (lastToken.startsWith("\"") && (!lastToken.endsWith("\"") || lastToken.length() == 1)) {
                lastToken = lastToken + separator + thisToken;
                continue;
            }
            partes.addElement(lastToken);
            lastToken = thisToken;
        }
        if (lastToken.startsWith("\"") && !lastToken.endsWith("\"")) {
            lastToken = lastToken + "\"";
        }
        partes.addElement(lastToken);
        return partes;
    }
}

