/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.services;

import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.services.ServiceConfigurationException;
import com.genexus.util.Encryption;
import com.genexus.util.GXService;

public class ServiceSettingsReader {
    private static ILogger logger = LogManager.getLogger(ServiceSettingsReader.class);
    private GXService service;
    private String name;
    private String serviceTypeName;

    public ServiceSettingsReader(String serviceType, String instanceName, GXService service) {
        this.name = instanceName;
        this.serviceTypeName = serviceType;
    }

    public String getEncryptedPropertyValue(String propertyName, String alternativePropertyName) throws ServiceConfigurationException {
        String value = this.getEncryptedPropertyValue(propertyName, alternativePropertyName, null);
        if (value == null) {
            String errorMessage = String.format("Service configuration error - Property name %s must be defined", this.resolvePropertyName(propertyName));
            logger.fatal(errorMessage);
            throw new ServiceConfigurationException(errorMessage);
        }
        return value;
    }

    public String getEncryptedPropertyValue(String propertyName, String alternativePropertyName, String defaultValue) {
        String encryptedOrUnEncryptedValue;
        String decryptedValue = encryptedOrUnEncryptedValue = this.getPropertyValue(propertyName, alternativePropertyName, defaultValue);
        if (encryptedOrUnEncryptedValue != null && encryptedOrUnEncryptedValue.length() > 0) {
            try {
                String decryptedTemp = Encryption.tryDecrypt64(encryptedOrUnEncryptedValue);
                decryptedValue = decryptedTemp != null ? decryptedTemp : encryptedOrUnEncryptedValue;
            }
            catch (Exception e) {
                logger.warn("Could not decrypt property name: " + this.resolvePropertyName(propertyName));
            }
        }
        return decryptedValue;
    }

    public String getPropertyValue(String propertyName, String alternativePropertyName) throws ServiceConfigurationException {
        String value = this.getPropertyValue(propertyName, alternativePropertyName, null);
        if (value == null) {
            String errorMessage = String.format("Service configuration error - Property name %s must be defined", this.resolvePropertyName(propertyName));
            logger.fatal(errorMessage);
            throw new ServiceConfigurationException(errorMessage);
        }
        return value;
    }

    public String getPropertyValue(String propertyName, String alternativePropertyName, String defaultValue) {
        String value = this.readFromEnvVars(propertyName, alternativePropertyName);
        if (value != null) {
            return value;
        }
        String resolvedPtyName = this.resolvePropertyName(propertyName);
        if (this.service != null && ((value = this.service.getProperties().get(resolvedPtyName)) == null || value.length() == 0)) {
            value = this.service.getProperties().get(alternativePropertyName);
        }
        return value != null ? value : defaultValue;
    }

    private String readFromEnvVars(String propertyName, String alternativePropertyName) {
        if (this.service != null && !this.service.getAllowOverrideWithEnvVarSettings()) {
            return null;
        }
        String value = System.getenv(this.resolvePropertyName(propertyName));
        if (value == null) {
            value = System.getenv(alternativePropertyName);
        }
        return value;
    }

    private String resolvePropertyName(String propertyName) {
        return String.format("%s_%s_%s", this.serviceTypeName, this.name, propertyName);
    }

    public String getName() {
        return this.name;
    }
}

