/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class Codecs {
    private static byte[] Base64EncMap;
    private static byte[] Base64DecMap;
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;
    static String dfltEncName;

    private Codecs() {
    }

    public static final String base64Encode(String str) {
        return Codecs.base64Encode(str, "GB2312");
    }

    public static final String base64Encode(String str, String encoding) {
        if (str == null) {
            return null;
        }
        try {
            return new String(Codecs.base64Encode(str.getBytes(encoding)), encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new Error(uee.toString());
        }
    }

    public static final byte[] base64Encode(byte[] data) {
        int sidx;
        if (data == null) {
            return null;
        }
        byte[] dest = new byte[(data.length + 2) / 3 * 4];
        int didx = 0;
        for (sidx = 0; sidx < data.length - 2; sidx += 3) {
            dest[didx++] = Base64EncMap[data[sidx] >>> 2 & 0x3F];
            dest[didx++] = Base64EncMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
            dest[didx++] = Base64EncMap[data[sidx + 2] >>> 6 & 3 | data[sidx + 1] << 2 & 0x3F];
            dest[didx++] = Base64EncMap[data[sidx + 2] & 0x3F];
        }
        if (sidx < data.length) {
            dest[didx++] = Base64EncMap[data[sidx] >>> 2 & 0x3F];
            if (sidx < data.length - 1) {
                dest[didx++] = Base64EncMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
                dest[didx++] = Base64EncMap[data[sidx + 1] << 2 & 0x3F];
            } else {
                dest[didx++] = Base64EncMap[data[sidx] << 4 & 0x3F];
            }
        }
        while (didx < dest.length) {
            dest[didx] = 61;
            ++didx;
        }
        return dest;
    }

    public static final String base64Decode(String str, String encoding) {
        if (str == null) {
            return null;
        }
        try {
            return new String(Codecs.base64Decode(str.getBytes(encoding)), encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new Error(uee.toString());
        }
    }

    public static final String base64Decode(String str) {
        return Codecs.base64Decode(str, "GB2312");
    }

    public static final byte[] base64Decode(byte[] data) {
        if (data == null) {
            return null;
        }
        int tail = data.length;
        while (data[tail - 1] == 61) {
            --tail;
        }
        byte[] dest = new byte[tail - data.length / 4];
        for (int idx = 0; idx < data.length; ++idx) {
            data[idx] = Base64DecMap[data[idx]];
        }
        try {
            int didx;
            int sidx = 0;
            for (didx = 0; didx < dest.length - 2; didx += 3) {
                dest[didx] = (byte)(data[sidx] << 2 & 0xFF | data[sidx + 1] >>> 4 & 3);
                dest[didx + 1] = (byte)(data[sidx + 1] << 4 & 0xFF | data[sidx + 2] >>> 2 & 0xF);
                dest[didx + 2] = (byte)(data[sidx + 2] << 6 & 0xFF | data[sidx + 3] & 0x3F);
                sidx += 4;
            }
            if (didx < dest.length) {
                dest[didx] = (byte)(data[sidx] << 2 & 0xFF | data[sidx + 1] >>> 4 & 3);
            }
            if (++didx < dest.length) {
                dest[didx] = (byte)(data[sidx + 1] << 4 & 0xFF | data[sidx + 2] >>> 2 & 0xF);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return dest;
    }

    public static final String URLDecode(String str) {
        if (str == null) {
            return null;
        }
        char[] res = new char[str.length()];
        int didx = 0;
        for (int sidx = 0; sidx < str.length(); ++sidx) {
            char ch = str.charAt(sidx);
            if (ch == '+') {
                res[didx++] = 32;
                continue;
            }
            if (ch == '%') {
                try {
                    res[didx++] = (char)Integer.parseInt(str.substring(sidx + 1, sidx + 3), 16);
                    sidx += 2;
                }
                catch (NumberFormatException e) {
                    System.err.println(str.substring(sidx, sidx + 3) + " is an invalid code");
                }
                continue;
            }
            res[didx++] = ch;
        }
        return String.valueOf(res, 0, didx);
    }

    public static String encode(String s) {
        String str = null;
        try {
            str = Codecs.encode(s, dfltEncName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        boolean wroteUnencodedChar = false;
        int maxBytesPerChar = 10;
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, enc);
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (dontNeedEncoding.get(c)) {
                if (c == 32) {
                    c = 43;
                    needToChange = true;
                }
                out.append((char)c);
                wroteUnencodedChar = true;
                continue;
            }
            try {
                char d;
                if (wroteUnencodedChar) {
                    writer = new OutputStreamWriter((OutputStream)buf, enc);
                    wroteUnencodedChar = false;
                }
                writer.write(c);
                if (c >= 55296 && c <= 56319 && i + 1 < s.length() && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                    writer.write(d);
                    ++i;
                }
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            buf.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }

    public static String decode(String s) {
        String str = null;
        try {
            str = Codecs.decode(s, dfltEncName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static String decode(String s, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        StringBuffer sb = new StringBuffer();
        int numChars = s.length();
        int i = 0;
        if (enc.length() == 0) {
            throw new UnsupportedEncodingException("URLDecoder: empty string enc parameter");
        }
        block6: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    needToChange = true;
                    continue block6;
                }
                case '%': {
                    try {
                        byte[] bytes = new byte[(numChars - i) / 3];
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            bytes[pos++] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, enc));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block6;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }

    static {
        int i;
        byte[] map = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        Base64EncMap = map;
        Base64DecMap = new byte[128];
        for (int idx = 0; idx < Base64EncMap.length; ++idx) {
            Codecs.Base64DecMap[Codecs.Base64EncMap[idx]] = (byte)idx;
        }
        dfltEncName = null;
        dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        dfltEncName = "UTF8";
    }
}

