/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.CommonUtil;
import com.genexus.DecimalUtil;
import com.genexus.IDelimitedFilesSafe;
import com.genexus.IHttpContext;
import com.genexus.ModelContext;
import com.genexus.RunnableThrows;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class DelimitedFilesSafe
implements IDelimitedFilesSafe {
    private static final ILogger logger = LogManager.getLogger(DelimitedFilesSafe.class);
    private static final byte GX_ASCDEL_SUCCESS = 0;
    private static final byte GX_ASCDEL_INVALIDSEQUENCE = -1;
    private static final byte GX_ASCDEL_OPENERROR = -2;
    private static final byte GX_ASCDEL_READERROR = -3;
    private static final byte GX_ASCDEL_ENDOFDATA = -4;
    private static final byte GX_ASCDEL_INVALIDFORMAT = -5;
    private static final byte GX_ASCDEL_OVERFLOW = -6;
    private static final byte GX_ASCDEL_INVALIDDATE = -7;
    private static final byte GX_ASCDEL_NOTENOUGHMEMORY = -8;
    private static final byte GX_ASCDEL_WRITEERROR = -9;
    private static final byte GX_ASCDEL_BADFMTSTR = -10;
    public static final String CRLF = "\r\n";
    protected String filename;
    private int len;
    private String fdel;
    private String sdel;
    protected boolean dfropen_in_use = false;
    protected boolean dfwopen_in_use = false;
    protected BufferedReader bufread;
    protected BufferedWriter bufwrite;
    private StringTokenizer actline;
    private String toWrite;
    private String encoding = "";
    private String newLineBehavior = null;
    private String currString;
    private boolean readingString = false;
    protected boolean lengthInBytes = false;
    private String lastLineRead;
    private boolean lastFieldRead;
    private boolean isCsv;

    private String getFileName(String pfilename) {
        IHttpContext webContext;
        String fileName = pfilename;
        if (!(ModelContext.getModelContext() == null || new File(fileName).isAbsolute() || (webContext = ModelContext.getModelContext().getHttpContext()) == null || !webContext.isHttpContextWeb() && webContext.getDefaultPath().isEmpty())) {
            fileName = ModelContext.getModelContext().getHttpContext().getDefaultPath() + File.separator + fileName;
        }
        return fileName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public byte dftrace(int trace) {
        byte lastTrace = 1;
        return lastTrace;
    }

    @Override
    public byte dfropen(String filename) {
        return this.dfropen(filename, 1024);
    }

    @Override
    public byte dfropen(String filename, int len) {
        return this.dfropen(filename, len, ",");
    }

    @Override
    public byte dfropen(String filename, int len, String fdel) {
        return this.dfropen(filename, len, fdel, "\"");
    }

    @Override
    public byte dfropen(String filename, int len, String fdel, String psdel) {
        return this.dfropen(filename, len, fdel, psdel, "");
    }

    @Override
    public byte dfropen(String pfilename, int plen, String pfdel, String psdel, String enc) {
        int retval = 0;
        if (pfdel.equals("\\t")) {
            pfdel = "\t";
        }
        if (!this.dfropen_in_use) {
            this.encoding = enc;
            this.dfropen_in_use = true;
            this.filename = this.getFileName(pfilename);
            this.len = plen;
            this.fdel = pfdel;
            this.sdel = psdel;
            this.isCsv = pfilename.toUpperCase().endsWith(".CSV");
            try {
                SpecificImplementation.NativeFunctions.getInstance().executeWithPermissions(new RunnableThrows(){

                    @Override
                    public Object run() throws Exception {
                        if (DelimitedFilesSafe.this.encoding != null) {
                            DelimitedFilesSafe.this.encoding = DelimitedFilesSafe.this.encoding.trim();
                            if (DelimitedFilesSafe.this.encoding.equals("")) {
                                DelimitedFilesSafe.this.encoding = "UTF8";
                            }
                            try {
                                DelimitedFilesSafe.this.lengthInBytes = true;
                                String bom = DelimitedFilesSafe.this.getByteOrderMark(DelimitedFilesSafe.this.encoding);
                                DelimitedFilesSafe.this.encoding = CommonUtil.normalizeEncodingName(DelimitedFilesSafe.this.encoding);
                                DelimitedFilesSafe.this.bufread = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(DelimitedFilesSafe.this.filename)), DelimitedFilesSafe.this.encoding));
                                if (bom != null) {
                                    char[] bombuffer = new char[bom.length()];
                                    DelimitedFilesSafe.this.bufread.read(bombuffer);
                                }
                                return null;
                            }
                            catch (UnsupportedEncodingException e) {
                                System.err.println(e.toString());
                            }
                        }
                        DelimitedFilesSafe.this.bufread = new BufferedReader(new FileReader(new File(DelimitedFilesSafe.this.filename)));
                        return null;
                    }
                }, 2);
            }
            catch (Exception e) {
                retval = -2;
                this.dfropen_in_use = false;
                logger.error("Error ADF0001: " + e);
            }
        } else {
            retval = -1;
            logger.error("Error ADF0005: open function in use");
        }
        return (byte)retval;
    }

    @Override
    public byte dfrnext() {
        int retval;
        block5: {
            retval = 0;
            this.readingString = false;
            this.currString = "";
            if (this.dfropen_in_use) {
                try {
                    String line;
                    this.lastLineRead = line = this.bufread.readLine();
                    this.lastFieldRead = false;
                    if (line == null) {
                        retval = -4;
                        break block5;
                    }
                    this.actline = new StringTokenizer(line, this.fdel, true);
                }
                catch (IOException e) {
                    retval = -3;
                    logger.error("Error ADF0002: " + e);
                }
            } else {
                retval = -1;
            }
        }
        return (byte)retval;
    }

    @Override
    public byte dfrgnum(double[] num) {
        byte retval = 0;
        Double retnum = new Double(0.0);
        if (this.dfropen_in_use) {
            try {
                String stringDelimitedField = this.actline.nextToken(this.fdel);
                if (this.fdel.equals(stringDelimitedField) || stringDelimitedField.equals("")) {
                    stringDelimitedField = "";
                }
                retnum = new Double(stringDelimitedField);
            }
            catch (Exception e) {
                retval = -5;
                logger.error("Error ADF0008: " + e);
            }
        } else {
            retval = -1;
            logger.error("Error ADF0004 o ADF0006");
        }
        num[0] = retnum;
        try {
            String string = this.actline.nextToken(this.fdel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    @Override
    public byte dfrgnum(BigDecimal[] num) {
        byte retval = 0;
        BigDecimal retnum = new BigDecimal(0);
        if (this.dfropen_in_use) {
            try {
                String stringDelimitedField = this.actline.nextToken(this.fdel);
                if (this.fdel.equals(stringDelimitedField) || stringDelimitedField.equals("")) {
                    stringDelimitedField = "";
                }
                if (!stringDelimitedField.equals("")) {
                    new BigDecimal(stringDelimitedField);
                }
                retnum = DecimalUtil.stringToDec(stringDelimitedField);
            }
            catch (Exception e) {
                retval = -5;
                logger.error("Error ADF0008: " + e);
            }
        } else {
            retval = -1;
            logger.error("Error ADF0004 o ADF0006");
        }
        num[0] = retnum;
        try {
            String string = this.actline.nextToken(this.fdel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    @Override
    public byte dfrgtxt(String[] str) {
        return this.dfrgtxt(str, 20000);
    }

    @Override
    public byte dfrgtxt(String[] str, int len) {
        byte retval = 0;
        if (!this.fdel.equals("") && !this.actline.hasMoreTokens() && this.lastLineRead.endsWith(this.fdel) && !this.lastFieldRead) {
            this.lastFieldRead = true;
            str[0] = "";
            return retval;
        }
        String retstr = "";
        if (this.dfropen_in_use) {
            try {
                if (!this.readingString) {
                    String stringDelimitedField = this.actline.nextToken(this.fdel);
                    if (this.fdel.equals(this.sdel)) {
                        retstr = this.fdel.equals(stringDelimitedField) ? new String(this.actline.nextToken(this.fdel)) : stringDelimitedField;
                    } else {
                        if (this.fdel.equals(stringDelimitedField) || stringDelimitedField.equals("")) {
                            stringDelimitedField = "";
                            str[0] = retstr;
                            return retval;
                        }
                        int lIndex = 0;
                        int rIndex = stringDelimitedField.length();
                        if (this.sdel.length() != 0 && stringDelimitedField.trim().startsWith(this.sdel)) {
                            lIndex = stringDelimitedField.indexOf(this.sdel) + 1;
                            if (stringDelimitedField.trim().endsWith(this.sdel) && stringDelimitedField.length() == 1) {
                                stringDelimitedField = stringDelimitedField + this.actline.nextToken(this.fdel);
                            }
                            while (!stringDelimitedField.trim().endsWith(this.sdel)) {
                                stringDelimitedField = stringDelimitedField + this.actline.nextToken(this.fdel);
                            }
                            rIndex = stringDelimitedField.lastIndexOf(this.sdel);
                        }
                        retstr = stringDelimitedField.substring(lIndex, rIndex);
                    }
                } else {
                    retstr = this.currString;
                }
                String[] strParm = new String[]{retstr};
                retval = this.processStringToRead(strParm, len);
                retstr = strParm[0];
            }
            catch (Exception e) {
                retval = -5;
                logger.error("Error ADF0009: " + e);
            }
        } else {
            retval = -1;
            logger.error("Error ADF0004 o ADF0006");
        }
        if (this.isCsv && (this.sdel.equals("") || this.sdel.equals("\"")) && (retstr.contains("\"\"") || !this.fdel.equals("") && retstr.contains(this.fdel))) {
            retstr = retstr.replace("\"\"", "\"");
            if (this.sdel.equals("")) {
                retstr = retstr.substring(1, retstr.length() - 1);
            }
        }
        str[0] = retstr;
        try {
            String string = this.actline.nextToken(this.fdel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    private byte processStringToRead(String[] currToken, int len) {
        int retval = 0;
        if (!this.fdel.equals("")) {
            this.readingString = false;
            if (!this.lengthInBytes) {
                int strLength = currToken[0].length();
                if (strLength > len) {
                    retval = -6;
                    currToken[0] = currToken[0].substring(0, len);
                }
            } else {
                try {
                    int bytesLength = currToken[0].getBytes(this.encoding).length;
                    if (bytesLength > len) {
                        retval = -6;
                        byte[] strBytes = currToken[0].getBytes(this.encoding);
                        byte[] tmpBytes = new byte[len];
                        for (int i = 0; i < len; ++i) {
                            tmpBytes[i] = strBytes[i];
                        }
                        currToken[0] = new String(tmpBytes, 0, len, this.encoding);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    System.err.println(e.toString());
                }
            }
        } else if (!this.lengthInBytes) {
            int strLength = currToken[0].length();
            if (strLength > len) {
                this.readingString = true;
                this.currString = currToken[0].substring(len, strLength);
                currToken[0] = currToken[0].substring(0, len);
            } else {
                this.readingString = false;
                this.currString = "";
            }
        } else {
            try {
                int bytesLength = currToken[0].getBytes(this.encoding).length;
                if (bytesLength > len) {
                    this.readingString = true;
                    byte[] strBytes = currToken[0].getBytes(this.encoding);
                    byte[] tmpBytes = new byte[len];
                    byte[] newBytes = new byte[bytesLength - len];
                    for (int i = 0; i < bytesLength; ++i) {
                        if (i < len) {
                            tmpBytes[i] = strBytes[i];
                            continue;
                        }
                        newBytes[i - len] = strBytes[i];
                    }
                    currToken[0] = new String(tmpBytes, 0, len, this.encoding);
                    this.currString = new String(newBytes, 0, bytesLength - len, this.encoding);
                } else {
                    this.readingString = false;
                    this.currString = "";
                }
            }
            catch (UnsupportedEncodingException e) {
                System.err.println(e.toString());
            }
        }
        return (byte)retval;
    }

    public byte dfrgdate(Date[] date) {
        return this.dfrgdate(date, "ymd");
    }

    public byte dfrgdate(Date[] date, String fmt) {
        return this.dfrgdate(date, fmt, "-");
    }

    @Override
    public byte dfrgdate(Date[] date, String fmt, String sep) {
        Date retdate;
        int retval;
        block15: {
            retval = 0;
            retdate = CommonUtil.nullDate();
            int year = 0;
            int month = 0;
            int day = 0;
            if (this.dfropen_in_use) {
                try {
                    String stringDelimitedField = this.actline.nextToken(this.fdel);
                    if (this.fdel.equals(stringDelimitedField) || stringDelimitedField.equals("")) {
                        stringDelimitedField = "";
                    }
                    String retstr = stringDelimitedField;
                    StringTokenizer stok = new StringTokenizer(retstr, sep);
                    block9: for (int i = 0; i < 3; ++i) {
                        int value = new Integer(stok.nextToken());
                        switch (fmt.charAt(i)) {
                            case 'y': {
                                year = value;
                                continue block9;
                            }
                            case 'm': {
                                month = value;
                                continue block9;
                            }
                            case 'd': {
                                day = value;
                                continue block9;
                            }
                            default: {
                                return -10;
                            }
                        }
                    }
                    if (month == 0 && day == 0 && year == 0) {
                        retdate = CommonUtil.nullDate();
                        break block15;
                    }
                    if (month < 1 || month > 12 || day < 1 || day > 31) {
                        retval = -7;
                        logger.error("Error ADF0010");
                        break block15;
                    }
                    Calendar calendar = GregorianCalendar.getInstance();
                    calendar.set(year, month - 1, day);
                    retdate = calendar.getTime();
                }
                catch (Exception e) {
                    retval = -5;
                }
            } else {
                retval = -1;
                logger.error("Error ADF0004 o ADF0006");
            }
        }
        date[0] = retdate;
        try {
            String string = this.actline.nextToken(this.fdel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (byte)retval;
    }

    @Override
    public byte dfrclose() {
        byte retval = 0;
        if (this.dfropen_in_use) {
            try {
                this.bufread.close();
                this.dfropen_in_use = false;
                this.encoding = "";
            }
            catch (Exception exception) {}
        } else {
            retval = -1;
        }
        return retval;
    }

    @Override
    public byte dfwopen(String filename) {
        return this.dfwopen(filename, ",");
    }

    @Override
    public byte dfwopen(String filename, String fdel) {
        return this.dfwopen(filename, fdel, "\"");
    }

    @Override
    public byte dfwopen(String pfilename, String pfdel, String psdel) {
        return this.dfwopen(pfilename, pfdel, psdel, 0);
    }

    @Override
    public byte dfwopen(String pfilename, String pfdel, String psdel, int append) {
        return this.dfwopen(pfilename, pfdel, psdel, append, "");
    }

    @Override
    public byte dfwopen(String pfilename, String fdel, String sdel, final int append, String enc) {
        int retval = 0;
        if (fdel.equals("\\t")) {
            fdel = "\t";
        }
        if (!this.dfwopen_in_use) {
            this.dfwopen_in_use = true;
            this.sdel = sdel;
            this.fdel = fdel;
            this.filename = this.getFileName(pfilename);
            this.encoding = enc;
            this.isCsv = pfilename.toUpperCase().endsWith(".CSV");
            try {
                SpecificImplementation.NativeFunctions.getInstance().executeWithPermissions(new RunnableThrows(){

                    @Override
                    public Object run() throws Exception {
                        if (DelimitedFilesSafe.this.encoding != null) {
                            DelimitedFilesSafe.this.encoding = DelimitedFilesSafe.this.encoding.trim();
                            if (!DelimitedFilesSafe.this.encoding.equals("")) {
                                try {
                                    DelimitedFilesSafe.this.lengthInBytes = true;
                                    String bom = DelimitedFilesSafe.this.getByteOrderMark(DelimitedFilesSafe.this.encoding);
                                    DelimitedFilesSafe.this.encoding = CommonUtil.normalizeEncodingName(DelimitedFilesSafe.this.encoding);
                                    DelimitedFilesSafe.this.bufwrite = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(DelimitedFilesSafe.this.filename, append != 0), DelimitedFilesSafe.this.encoding));
                                    if (bom != null) {
                                        DelimitedFilesSafe.this.bufwrite.write(bom);
                                    }
                                    return null;
                                }
                                catch (UnsupportedEncodingException e) {
                                    System.err.println(e.toString());
                                }
                            }
                        }
                        DelimitedFilesSafe.this.bufwrite = new BufferedWriter(new FileWriter(DelimitedFilesSafe.this.filename, append != 0));
                        return null;
                    }
                }, 2);
            }
            catch (Exception e) {
                retval = -2;
                this.dfwopen_in_use = false;
                logger.error("Error ADF0001: " + e);
            }
        } else {
            retval = -1;
            logger.error("Error ADF0005: open function in use");
        }
        return (byte)retval;
    }

    private String getByteOrderMark(String enc) throws UnsupportedEncodingException {
        if (enc != null && enc.toUpperCase().equals("UTF-8 BOM")) {
            byte[] bom = new byte[]{-17, -69, -65};
            return new String(bom, "UTF8");
        }
        if (enc != null && enc.toUpperCase().equals("UTF-16LE BOM")) {
            byte[] bom = new byte[]{-1, -2};
            return new String(bom, "UTF-16LE");
        }
        if (enc != null && enc.toUpperCase().equals("UTF-16BE BOM")) {
            byte[] bom = new byte[]{-2, -1};
            return new String(bom, "UTF-16BE");
        }
        return null;
    }

    public void setNewLineBehavior(String newLine) {
        this.newLineBehavior = newLine;
    }

    @Override
    public byte dfwnext() {
        int retval = 0;
        if (this.dfwopen_in_use) {
            try {
                if (this.toWrite != null) {
                    this.bufwrite.write(this.toWrite);
                }
                if (this.newLineBehavior == null) {
                    this.bufwrite.newLine();
                } else {
                    this.bufwrite.write(this.newLineBehavior);
                }
                this.toWrite = null;
            }
            catch (IOException e) {
                retval = -9;
                logger.error("Error ADF0003: " + e);
            }
        } else {
            retval = -1;
        }
        return (byte)retval;
    }

    public byte dfwpnum(int num) {
        this.dfwpnum(num, 0);
        return 0;
    }

    @Override
    public byte dfwpnum(double num, int dec) {
        byte retval = 0;
        if (this.dfwopen_in_use) {
            String doubnum = CommonUtil.ltrim(CommonUtil.str(num, 20 + dec, dec));
            int k = doubnum.indexOf(".");
            if (dec == 0) {
                if (k >= 0) {
                    doubnum = doubnum.substring(0, k);
                }
            } else {
                String right;
                String left;
                if (k != -1) {
                    left = doubnum.substring(0, k);
                    right = doubnum.substring(k, doubnum.length());
                } else {
                    left = doubnum;
                    right = ".";
                }
                doubnum = left + CommonUtil.padr(right, dec + 1, "0");
            }
            this.toWrite = this.toWrite == null ? doubnum : this.toWrite + this.fdel + doubnum;
        } else {
            retval = -1;
            logger.error("ADF0004");
        }
        return retval;
    }

    @Override
    public byte dfwptxt(String txt, int len) {
        byte retval = 0;
        if (this.dfwopen_in_use) {
            if (len == 0) {
                int strlen = txt.length();
                try {
                    if (this.lengthInBytes) {
                        strlen = txt.getBytes(this.encoding).length;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    System.err.println(e.toString());
                }
                len = strlen;
            }
            this.toWrite = this.toWrite == null ? this.sdel + this.processStringToWrite(txt, len) + this.sdel : this.toWrite + this.fdel + this.sdel + this.processStringToWrite(txt, len) + this.sdel;
        } else {
            retval = -1;
            logger.error("ADF0004");
        }
        return retval;
    }

    public byte dfwpdate(Date date) {
        return this.dfwpdate(date, "ymd");
    }

    public byte dfwpdate(Date date, String fmt) {
        return this.dfwpdate(date, fmt, "-");
    }

    @Override
    public byte dfwpdate(Date date, String fmt, String sep) {
        byte retval = 0;
        if (this.dfwopen_in_use) {
            String year;
            String month;
            String day;
            if (date.equals(CommonUtil.nullDate())) {
                day = "00";
                month = "00";
                year = "0000";
            } else {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.setTime(date);
                day = CommonUtil.padl(Integer.toString(calendar.get(5)), 2, "0");
                month = CommonUtil.padl(Integer.toString(calendar.get(2) + 1), 2, "0");
                year = CommonUtil.padl(Integer.toString(calendar.get(1)), 4, "0");
            }
            this.toWrite = this.toWrite == null ? "" : this.toWrite + this.fdel;
            block5: for (int i = 0; i < 3; ++i) {
                switch (fmt.charAt(i)) {
                    case 'y': {
                        this.toWrite = this.toWrite + year + (i == 2 ? "" : sep);
                        continue block5;
                    }
                    case 'm': {
                        this.toWrite = this.toWrite + month + (i == 2 ? "" : sep);
                        continue block5;
                    }
                    case 'd': {
                        this.toWrite = this.toWrite + day + (i == 2 ? "" : sep);
                        continue block5;
                    }
                    default: {
                        logger.error("ADF0012");
                        return -10;
                    }
                }
            }
        } else {
            retval = -1;
            logger.error("ADF0004");
        }
        return retval;
    }

    @Override
    public byte dfwclose() {
        byte retval = 0;
        if (this.dfwopen_in_use) {
            try {
                this.bufwrite.close();
                this.dfwopen_in_use = false;
                this.encoding = "";
            }
            catch (IOException e) {
                System.err.println("Error closing");
            }
        } else {
            retval = -1;
        }
        return retval;
    }

    private String processStringToWrite(String currToken, int len) {
        int tokenLength;
        int lenDiff = 0;
        if (!this.lengthInBytes) {
            tokenLength = currToken.length();
            if (tokenLength > len) {
                currToken = currToken.substring(0, len);
            } else {
                lenDiff = len - tokenLength;
            }
        } else {
            try {
                tokenLength = currToken.getBytes(this.encoding).length;
                if (tokenLength > len) {
                    byte[] b1 = currToken.getBytes(this.encoding);
                    byte[] b2 = new byte[len];
                    System.arraycopy(b1, 0, b2, 0, len);
                    currToken = new String(b2, this.encoding);
                } else {
                    lenDiff = len - tokenLength;
                }
            }
            catch (UnsupportedEncodingException e) {
                System.err.println(e.toString());
            }
        }
        for (int i = 0; i < lenDiff; ++i) {
            currToken = currToken.concat(" ");
        }
        if (this.isCsv && (this.sdel.equals("") || this.sdel.equals("\"")) && (currToken.contains("\"") || !this.fdel.equals("") && currToken.contains(this.fdel) || currToken.contains(CRLF))) {
            currToken = currToken.replace("\"", "\"\"");
            if (this.sdel.equals("")) {
                currToken = '\"' + currToken + '\"';
            }
        }
        return currToken;
    }
}

