/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import java.math.BigDecimal;
import java.math.MathContext;

class EvalValue {
    String stringValue;
    BigDecimal decimalValue;

    public EvalValue(BigDecimal d) {
        this.decimalValue = d;
    }

    public EvalValue(String s) {
        this.stringValue = s;
    }

    public BigDecimal getDecimal() {
        return this.decimalValue;
    }

    public String getString() {
        return this.stringValue;
    }

    public static EvalValue add(EvalValue a, EvalValue b) {
        if (a.stringValue == null) {
            return new EvalValue(a.getDecimal().add(b.getDecimal()));
        }
        return new EvalValue(a.getString() + b.getString());
    }

    public static EvalValue subtract(EvalValue a, EvalValue b) {
        if (a.stringValue == null) {
            return new EvalValue(a.getDecimal().subtract(b.getDecimal()));
        }
        throw new IllegalArgumentException("Invalid operation: string - string");
    }

    public static EvalValue multiply(EvalValue a, EvalValue b) {
        if (a.stringValue == null) {
            return new EvalValue(a.getDecimal().multiply(b.getDecimal()));
        }
        throw new IllegalArgumentException("Invalid operation: string * string");
    }

    public static EvalValue divide(EvalValue a, EvalValue b) {
        if (a.stringValue == null) {
            return new EvalValue(a.getDecimal().divide(b.getDecimal(), MathContext.DECIMAL128));
        }
        throw new IllegalArgumentException("Invalid operation: string / string");
    }

    public static boolean greater(EvalValue a, EvalValue b) {
        if (a.stringValue == null) {
            return a.getDecimal().doubleValue() > b.getDecimal().doubleValue();
        }
        throw new IllegalArgumentException("Invalid operation: string > string");
    }

    public static boolean less(EvalValue a, EvalValue b) {
        if (a.stringValue == null) {
            return a.getDecimal().doubleValue() < b.getDecimal().doubleValue();
        }
        throw new IllegalArgumentException("Invalid operation: string < string");
    }

    public static boolean equal(EvalValue a, EvalValue b) {
        if (a.stringValue == null) {
            if (b.getDecimal() == null) {
                return false;
            }
            return a.getDecimal().doubleValue() == b.getDecimal().doubleValue();
        }
        return a.getString().equals(b.getString());
    }

    public static boolean notEqual(EvalValue a, EvalValue b) {
        if (a.stringValue == null) {
            if (b.getDecimal() == null) {
                return true;
            }
            return a.getDecimal().doubleValue() != b.getDecimal().doubleValue();
        }
        return !a.getString().equals(b.getString());
    }

    public static boolean greaterOrEqual(EvalValue a, EvalValue b) {
        if (a.stringValue == null) {
            return a.getDecimal().doubleValue() >= b.getDecimal().doubleValue();
        }
        throw new IllegalArgumentException("Invalid operation: string >= string");
    }

    public static boolean lessOrEqual(EvalValue a, EvalValue b) {
        if (a.stringValue == null) {
            if (b.getDecimal() == null) {
                return false;
            }
            return a.getDecimal().doubleValue() <= b.getDecimal().doubleValue();
        }
        throw new IllegalArgumentException("Invalid operation: string <= string");
    }

    public boolean isTrue() {
        if (this.stringValue == null) {
            return this.getDecimal().doubleValue() != 0.0;
        }
        throw new IllegalArgumentException("Invalid operation: isTrue(" + this.getString() + ")");
    }

    public boolean isFalse() {
        if (this.stringValue == null) {
            return this.getDecimal().doubleValue() == 0.0;
        }
        throw new IllegalArgumentException("Invalid operation: isFalse(" + this.getString() + ")");
    }

    public static EvalValue falseValue() {
        return new EvalValue(new BigDecimal(0));
    }

    public static EvalValue trueValue() {
        return new EvalValue(new BigDecimal(1));
    }
}

