/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.GxUnknownObjectCollection;
import com.genexus.ModelContext;
import com.genexus.db.DynamicExecute;
import com.genexus.util.EvalValue;
import com.genexus.util.FastTokenizer;
import com.genexus.util.GXProperties;
import com.genexus.util.Tokenizer;
import java.math.BigDecimal;
import java.util.NoSuchElementException;
import java.util.Vector;

public class ExpressionEvaluator {
    ModelContext context;
    int handle;
    boolean throwExceptions = false;
    GXProperties parms = new GXProperties();
    short UNKNOWN_ERROR = 1;
    short PARAMETER_ERROR = (short)2;
    short EXPRESSION_ERROR = (short)3;
    short EVALUATION_ERROR = (short)4;
    short EXTERNAL_FUNCTION_ERROR = (short)5;
    boolean iifContext = false;
    String expr;
    short errCode;
    String errDescription;
    private static final char GE = '\u0001';
    private static final char LE = '\u0002';
    private static final char AND = '\u0003';
    private static final char OR = '\u0004';
    private static final char NE = '\u0005';

    public ExpressionEvaluator(ModelContext context, int handle, String varParms) {
        this.handle = handle;
        this.context = context;
        this.setParms(varParms);
    }

    public ExpressionEvaluator(ModelContext context, int handle) {
        this.handle = handle;
        this.context = context;
        this.setParms("");
    }

    public GXProperties getVariables() {
        return this.parms;
    }

    public String getExpression() {
        return this.expr;
    }

    public void setExpression(String value) {
        this.expr = value;
    }

    public short getErrCode() {
        return this.errCode;
    }

    public String getErrDescription() {
        return this.errDescription;
    }

    public BigDecimal evaluate() {
        try {
            this.errCode = 0;
            this.errDescription = "";
            return this.eval(this.expr).getDecimal();
        }
        catch (IllegalArgumentException e) {
            return this.throwException(this.UNKNOWN_ERROR, e.getMessage()).getDecimal();
        }
    }

    public GxUnknownObjectCollection getUsedVariables() {
        FastTokenizer ft = new FastTokenizer(this.getTokenizerExpression(this.expr));
        GxUnknownObjectCollection ls = new GxUnknownObjectCollection();
        String tk = ft.nextToken();
        while (!ft.eof()) {
            if (tk.indexOf("(") == -1 && !Character.isDigit(tk.charAt(0))) {
                ls.add(tk);
            }
            tk = ft.nextToken();
        }
        return ls;
    }

    public void setParms(String varParms) {
        this.parms.clear();
        Tokenizer tokenizer = new Tokenizer(varParms, ";", false);
        while (tokenizer.hasMoreTokens()) {
            String parm = tokenizer.nextToken().trim();
            if (parm.equals("")) continue;
            int index = parm.indexOf(61);
            if (index == -1 || Character.isDigit(parm.charAt(0))) {
                this.throwException(this.PARAMETER_ERROR, "Parm " + parm + " does not comply with format: 'ParmName=ParmValue'");
                continue;
            }
            try {
                String parmName = parm.substring(0, index).trim().toLowerCase();
                String parmValue = parm.substring(index + 1).trim();
                if (parmValue.length() > 0 && !Character.isDigit(parmValue.charAt(0))) {
                    if (this.parms.containsKey(parmValue)) {
                        this.parms.put(parmName, this.parms.get(parmValue));
                        continue;
                    }
                    this.throwException(this.PARAMETER_ERROR, "Unknown parameter '" + parmValue + "'");
                    continue;
                }
                this.parms.put(parmName, parmValue);
            }
            catch (Throwable e) {
                this.throwException(this.PARAMETER_ERROR, "Parm " + parm + " cannot be evaluated: " + e.getMessage());
            }
        }
    }

    public void setThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
    }

    public static BigDecimal eval(ModelContext context, int handle, String expression, String parms) {
        return new ExpressionEvaluator(context, handle, parms).eval(expression).getDecimal();
    }

    public static BigDecimal eval(ModelContext context, int handle, String expression, byte[] err, String[] errMsg, String parms) {
        err[0] = 1;
        errMsg[0] = "";
        try {
            if (expression.trim().equals("")) {
                return new BigDecimal(0);
            }
            ExpressionEvaluator eval = new ExpressionEvaluator(context, handle, parms);
            return eval.eval(expression).getDecimal();
        }
        catch (NumberFormatException e) {
            err[0] = 0;
            errMsg[0] = "Invalid number: " + e.getMessage();
            return new BigDecimal(0);
        }
        catch (Throwable e) {
            err[0] = 0;
            errMsg[0] = e.getMessage();
            return new BigDecimal(0);
        }
    }

    EvalValue eval(String expression) {
        if (expression == "") {
            return this.throwException(this.EXPRESSION_ERROR, "Empty expression");
        }
        if (!this.matchParentesis(expression)) {
            return this.throwException(this.EXPRESSION_ERROR, "The expression '" + expression + "' has unbalanced parenthesis");
        }
        String delim = "'!+-/*><=\u0001\u0002\u0003\u0004\u0005";
        boolean useParentheses = false;
        if (this.iifContext && (expression.contains("\u0003") || expression.contains("\u0004"))) {
            delim = "\u0003\u0004";
            useParentheses = true;
        }
        Tokenizer tokenizer = new Tokenizer(this.getTokenizerExpression(expression), delim, true, useParentheses);
        return this.evaluate(expression, tokenizer);
    }

    private EvalValue throwException(short errCod, String error) {
        if (this.throwExceptions) {
            throw new IllegalArgumentException(error);
        }
        this.errCode = errCod;
        this.errDescription = error;
        return new EvalValue(new BigDecimal(0));
    }

    private String getTokenizerExpression(String expression) {
        int index;
        while ((index = expression.indexOf("==")) != -1) {
            expression = expression.substring(0, index) + expression.substring(index + 1);
        }
        while ((index = expression.indexOf(">=")) != -1) {
            expression = expression.substring(0, index) + '\u0001' + expression.substring(index + 2);
        }
        while ((index = expression.indexOf("<=")) != -1) {
            expression = expression.substring(0, index) + '\u0002' + expression.substring(index + 2);
        }
        while ((index = expression.indexOf("&&")) != -1) {
            expression = expression.substring(0, index) + '\u0003' + expression.substring(index + 2);
        }
        while ((index = expression.indexOf("||")) != -1) {
            expression = expression.substring(0, index) + '\u0004' + expression.substring(index + 2);
        }
        while ((index = expression.indexOf("!=")) != -1) {
            expression = expression.substring(0, index) + '\u0005' + expression.substring(index + 2);
        }
        while ((index = expression.indexOf("<>")) != -1) {
            expression = expression.substring(0, index) + '\u0005' + expression.substring(index + 2);
        }
        while ((index = this.indexOfKeyword(expression, "and", index)) != -1) {
            expression = expression.substring(0, index) + '\u0003' + expression.substring(index + 3);
        }
        while ((index = this.indexOfKeyword(expression, "or", index)) != -1) {
            expression = expression.substring(0, index) + '\u0004' + expression.substring(index + 2);
        }
        return expression;
    }

    private int indexOfKeyword(String expression, String keyw, int nextIndex) {
        String exp = expression.toLowerCase();
        int index = exp.indexOf(keyw.toLowerCase(), nextIndex + 1);
        while (index >= 0) {
            if (this.validKeyword(expression, index, keyw).booleanValue()) {
                return index;
            }
            index = exp.indexOf(keyw.toLowerCase(), index + 1);
        }
        return index;
    }

    private Boolean validKeyword(String expression, int index, String keyw) {
        if (index - 1 >= 0 && (Character.isLetterOrDigit(expression.charAt(index - 1)) || "()!".indexOf(expression.charAt(index - 1)) != -1)) {
            return false;
        }
        if (index + keyw.length() < expression.length() && (Character.isLetterOrDigit(expression.charAt(index + keyw.length())) || "()!".indexOf(expression.charAt(index + keyw.length())) != -1)) {
            return false;
        }
        return true;
    }

    private EvalValue evaluate(String fullExpression, Tokenizer tokenizer) {
        return this.evaluate(fullExpression, tokenizer, false);
    }

    private EvalValue evaluate(String fullExpression, Tokenizer tokenizer, boolean stopOnLowPrecedence) {
        String[] nextOp;
        EvalValue retVal = this.eval(tokenizer);
        EvalValue termino = new EvalValue(new BigDecimal(0));
        block14: while (tokenizer.hasMoreTokens() && (!stopOnLowPrecedence || !tokenizer.peek(nextOp = new String[1]) || nextOp[0].length() < 1 || nextOp[0].charAt(0) != '+' && nextOp[0].charAt(0) != '-')) {
            String soperador = tokenizer.nextToken();
            char operador = soperador.charAt(0);
            switch (operador) {
                case '+': {
                    termino = this.evaluate(fullExpression, tokenizer, true);
                    retVal = EvalValue.add(retVal, termino);
                    continue block14;
                }
                case '-': {
                    termino = this.evaluate(fullExpression, tokenizer, true);
                    retVal = EvalValue.subtract(retVal, termino);
                    continue block14;
                }
                case '*': {
                    termino = this.eval(tokenizer);
                    retVal = EvalValue.multiply(retVal, termino);
                    continue block14;
                }
                case '/': {
                    termino = this.eval(tokenizer);
                    if (termino.isFalse() && this.errCode == 0) {
                        this.throwException(this.EVALUATION_ERROR, "Division by zero");
                    }
                    if (this.errCode != 0) continue block14;
                    retVal = EvalValue.divide(retVal, termino);
                    continue block14;
                }
                case '>': {
                    return EvalValue.greater(retVal, this.evaluate(fullExpression, tokenizer)) ? EvalValue.trueValue() : EvalValue.falseValue();
                }
                case '<': {
                    return EvalValue.less(retVal, this.evaluate(fullExpression, tokenizer)) ? EvalValue.trueValue() : EvalValue.falseValue();
                }
                case '=': {
                    return EvalValue.equal(retVal, this.evaluate(fullExpression, tokenizer)) ? EvalValue.trueValue() : EvalValue.falseValue();
                }
                case '\u0001': {
                    return EvalValue.greaterOrEqual(retVal, this.evaluate(fullExpression, tokenizer)) ? EvalValue.trueValue() : EvalValue.falseValue();
                }
                case '\u0002': {
                    return EvalValue.lessOrEqual(retVal, this.evaluate(fullExpression, tokenizer)) ? EvalValue.trueValue() : EvalValue.falseValue();
                }
                case '\u0003': {
                    return retVal.isTrue() && this.evaluate(fullExpression, tokenizer).isTrue() ? EvalValue.trueValue() : EvalValue.falseValue();
                }
                case '\u0004': {
                    return retVal.isTrue() || this.evaluate(fullExpression, tokenizer).isTrue() ? EvalValue.trueValue() : EvalValue.falseValue();
                }
                case '\u0005': {
                    return EvalValue.notEqual(retVal, this.evaluate(fullExpression, tokenizer)) ? EvalValue.trueValue() : EvalValue.falseValue();
                }
            }
            this.throwException(this.EVALUATION_ERROR, "Unknown operator '" + soperador + "' found in expression '" + fullExpression + "'");
        }
        return retVal;
    }

    private EvalValue eval(Tokenizer tokenizer) {
        String token = this.getNextToken(tokenizer);
        if (token.equalsIgnoreCase("!")) {
            return this.eval(tokenizer).isFalse() ? EvalValue.trueValue() : EvalValue.falseValue();
        }
        if (token.equalsIgnoreCase("-")) {
            return EvalValue.multiply(new EvalValue(new BigDecimal(-1)), this.eval(tokenizer));
        }
        if (token.equalsIgnoreCase("+")) {
            return this.eval(tokenizer);
        }
        if (token.startsWith("(") && token.endsWith(")")) {
            return this.eval(token.substring(1, token.length() - 1).trim());
        }
        if (Character.isDigit(token.charAt(0)) || token.charAt(0) == '.') {
            try {
                return new EvalValue(new BigDecimal(token));
            }
            catch (Exception e) {
                return this.throwException(this.EVALUATION_ERROR, "Invalid variable reference: " + token);
            }
        }
        if (token.startsWith("'")) {
            String s = "";
            String tk = tokenizer.nextToken();
            while (!tk.equals("'")) {
                s = s + tk;
                tk = tokenizer.nextToken();
            }
            return new EvalValue(s);
        }
        if (token.equalsIgnoreCase("PI")) {
            return new EvalValue(new BigDecimal(Math.PI));
        }
        if (this.parms.containsKey(token)) {
            return this.eval(this.parms.get(token));
        }
        int indexLeftParen = token.indexOf(40);
        int indexRightParen = token.lastIndexOf(41);
        if (indexLeftParen == -1 || indexRightParen == -1) {
            return this.throwException(this.EVALUATION_ERROR, "Invalid variable reference: " + token);
        }
        String funcName = token.substring(0, indexLeftParen);
        double result = this.evalFuncCall(funcName, token.substring(indexLeftParen + 1, indexRightParen));
        if (Double.isInfinite(result) || Double.isNaN(result)) {
            return new EvalValue(new BigDecimal(0));
        }
        return new EvalValue(new BigDecimal(result));
    }

    private double evalFuncCall(String funcName, String expr) {
        String sarg2;
        String sarg1;
        Tokenizer paramTokenizer;
        if (funcName.equalsIgnoreCase("rnd")) {
            return Math.random();
        }
        if (funcName.equalsIgnoreCase("abs")) {
            return Math.abs(this.eval(expr).getDecimal().doubleValue());
        }
        if (funcName.equalsIgnoreCase("int")) {
            return this.eval(expr).getDecimal().longValue();
        }
        if (funcName.equalsIgnoreCase("frac")) {
            double value = this.eval(expr).getDecimal().doubleValue();
            return value - (double)((long)value);
        }
        if (funcName.equalsIgnoreCase("sin")) {
            return Math.sin(this.eval(expr).getDecimal().doubleValue());
        }
        if (funcName.equalsIgnoreCase("asin")) {
            return Math.asin(this.eval(expr).getDecimal().doubleValue());
        }
        if (funcName.equalsIgnoreCase("cos")) {
            return Math.cos(this.eval(expr).getDecimal().doubleValue());
        }
        if (funcName.equalsIgnoreCase("acos")) {
            double x = this.eval(expr).getDecimal().doubleValue();
            if (x > 1.0 || x < -1.0) {
                this.throwException(this.EVALUATION_ERROR, "Invalid range");
            }
            return Math.acos(x);
        }
        if (funcName.equalsIgnoreCase("tan")) {
            return Math.tan(this.eval(expr).getDecimal().doubleValue());
        }
        if (funcName.equalsIgnoreCase("atan")) {
            return Math.atan(this.eval(expr).getDecimal().doubleValue());
        }
        if (funcName.equalsIgnoreCase("floor")) {
            return Math.floor(this.eval(expr).getDecimal().doubleValue());
        }
        if (funcName.equalsIgnoreCase("round")) {
            return Math.round(this.eval(expr).getDecimal().doubleValue());
        }
        if (funcName.equalsIgnoreCase("trunc")) {
            return Math.floor(this.eval(expr).getDecimal().doubleValue());
        }
        if (funcName.equalsIgnoreCase("ln") || funcName.equalsIgnoreCase("log")) {
            double val = this.eval(expr).getDecimal().doubleValue();
            if (val <= 0.0) {
                return this.throwException(this.EVALUATION_ERROR, "Illegal argument (" + val + ") to function log(" + expr + ")").getDecimal().doubleValue();
            }
            return Math.log(val);
        }
        if (funcName.equalsIgnoreCase("exp")) {
            return Math.exp(this.eval(expr).getDecimal().doubleValue());
        }
        if (funcName.equalsIgnoreCase("sqrt")) {
            return Math.sqrt(this.eval(expr).getDecimal().doubleValue());
        }
        if (funcName.equalsIgnoreCase("pow") || funcName.equalsIgnoreCase("max") || funcName.equalsIgnoreCase("min")) {
            paramTokenizer = new Tokenizer(expr, ",", true);
            try {
                sarg1 = this.getNextToken(paramTokenizer);
                paramTokenizer.nextToken();
                sarg2 = this.getNextToken(paramTokenizer);
            }
            catch (NoSuchElementException e) {
                return this.throwException(this.EVALUATION_ERROR, "The function " + funcName + " needs 2 arguments").getDecimal().doubleValue();
            }
            double arg1 = this.eval(sarg1).getDecimal().doubleValue();
            double arg2 = this.eval(sarg2).getDecimal().doubleValue();
            if (funcName.equalsIgnoreCase("pow")) {
                return Math.pow(arg1, arg2);
            }
            if (funcName.equalsIgnoreCase("max")) {
                return Math.max(arg1, arg2);
            }
            if (funcName.equalsIgnoreCase("min")) {
                return Math.min(arg1, arg2);
            }
        }
        if (funcName.equalsIgnoreCase("iif")) {
            String sarg3;
            paramTokenizer = new Tokenizer(expr, ",", true);
            try {
                sarg1 = this.getNextToken(paramTokenizer);
                paramTokenizer.nextToken();
                sarg2 = this.getNextToken(paramTokenizer);
                paramTokenizer.nextToken();
                sarg3 = this.getNextToken(paramTokenizer);
            }
            catch (NoSuchElementException e) {
                return this.throwException(this.EVALUATION_ERROR, "The function " + funcName + " needs 3 arguments").getDecimal().doubleValue();
            }
            this.iifContext = true;
            Boolean iif_result = this.eval(sarg1).isTrue();
            this.iifContext = false;
            if (this.errCode != 0) {
                return 0.0;
            }
            double result = iif_result != false ? this.eval(sarg2).getDecimal().doubleValue() : this.eval(sarg3).getDecimal().doubleValue();
            return result;
        }
        return this.evalExternalFunctionCall(funcName, expr);
    }

    private double evalExternalFunctionCall(String funcName, String expr) {
        Tokenizer paramTokenizer = new Tokenizer(expr.trim(), ",", true);
        Vector<Object> functionParms = new Vector<Object>();
        while (paramTokenizer.hasMoreTokens()) {
            String arg = this.getNextToken(paramTokenizer).trim();
            if ((arg.startsWith("\"") || arg.startsWith("'")) && (arg.endsWith("\"") || arg.endsWith("'"))) {
                functionParms.addElement(arg.substring(1, arg.length() - 1));
            } else {
                EvalValue eValue = this.eval(arg);
                if (eValue.getString() == null) {
                    functionParms.addElement(new Double(eValue.getDecimal().doubleValue()));
                } else {
                    functionParms.addElement(new String(eValue.getString()));
                }
            }
            if (!paramTokenizer.hasMoreTokens()) continue;
            paramTokenizer.nextToken();
        }
        functionParms.addElement(new Double(0.0));
        Object[] callParms = new Object[functionParms.size()];
        functionParms.copyInto(callParms);
        try {
            funcName = funcName.toLowerCase();
            DynamicExecute.dynamicExecute(this.context, this.handle, ExpressionEvaluator.class, funcName, callParms);
        }
        catch (Exception e) {
            return this.throwException(this.EXTERNAL_FUNCTION_ERROR, e.toString()).getDecimal().doubleValue();
        }
        return (Double)callParms[callParms.length - 1];
    }

    private String getNextToken(Tokenizer tokenizer) {
        String token = "";
        while (!this.matchParentesis(token = token + tokenizer.nextToken()) || token.trim().equals("") && tokenizer.hasMoreTokens()) {
        }
        if (tokenizer.useParentheses() && !token.startsWith("(") && !token.startsWith("IIF")) {
            return "(" + token.trim() + ")";
        }
        return token.trim();
    }

    private boolean matchParentesis(String token) {
        int cantLeft = 0;
        int cantRight = 0;
        char[] cars = new char[token.length()];
        token.getChars(0, token.length(), cars, 0);
        for (int i = 0; i < cars.length; ++i) {
            char c = cars[i];
            if (c == '(') {
                ++cantLeft;
            }
            if (c != ')') continue;
            ++cantRight;
        }
        return cantLeft == cantRight;
    }
}

