/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.CommonUtil;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.db.driver.ExternalProvider;
import com.genexus.db.driver.ExternalProviderCommon;
import com.genexus.db.driver.ResourceAccessControlList;
import com.genexus.util.GXDirectory;
import com.genexus.util.GXDirectoryCollection;
import com.genexus.util.GXFileCollection;
import com.genexus.util.IGXFileInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class GXExternalFileInfo
implements IGXFileInfo {
    private static int DEFAULT_OBJECT_EXPIRATION_MINUTES = -1;
    String name;
    String providerObjectName;
    ExternalProvider provider;
    String url;
    boolean isFile;
    ResourceAccessControlList fileAcl = ResourceAccessControlList.Private;

    public GXExternalFileInfo(String storageObjectFullName, String url, ExternalProvider provider) {
        this.setName(storageObjectFullName);
        this.url = url;
        this.provider = provider;
        this.isFile = true;
    }

    public GXExternalFileInfo(String storageObjectFullName, String url, ExternalProvider provider, ResourceAccessControlList acl) {
        this.url = url;
        this.provider = provider;
        this.fileAcl = acl;
        this.isFile = true;
        this.setName(storageObjectFullName);
    }

    public GXExternalFileInfo(String storageObjectFullName, ExternalProvider provider, boolean isFile) {
        this.url = "";
        this.provider = provider;
        this.isFile = isFile;
        this.setName(storageObjectFullName);
    }

    public GXExternalFileInfo(String storageObjectFullName, ExternalProvider provider, boolean isFile, ResourceAccessControlList acl) {
        this.url = "";
        this.provider = provider;
        this.isFile = isFile;
        this.fileAcl = acl;
        this.setName(storageObjectFullName);
    }

    public GXExternalFileInfo(String storageObjectFullName, ExternalProvider provider) {
        this.url = "";
        this.provider = provider;
        this.isFile = true;
        this.setName(storageObjectFullName);
    }

    private void setName(String objectNameOrUrl) {
        this.name = ExternalProviderCommon.getProviderObjectAbsoluteUriSafe(this.provider, objectNameOrUrl);
        this.providerObjectName = !CommonUtil.isAbsoluteURL(objectNameOrUrl) ? objectNameOrUrl : ExternalProviderCommon.getProviderObjectName(this.provider, objectNameOrUrl);
    }

    @Override
    public String getPath() {
        if (this.isDirectory()) {
            return this.provider.getDirectory(this.providerObjectName);
        }
        return this.getParent();
    }

    @Override
    public boolean exists() {
        if (this.isFile) {
            return this.provider != null && this.provider.exists(this.providerObjectName, this.fileAcl);
        }
        return this.provider != null && this.provider.existsDirectory(this.providerObjectName);
    }

    @Override
    public boolean isFile() {
        return this.isFile;
    }

    public void setIsFile(boolean isFile) {
        this.isFile = isFile;
    }

    @Override
    public boolean isDirectory() {
        return !this.isFile;
    }

    @Override
    public boolean mkdir() {
        return false;
    }

    @Override
    public String[] list() {
        return new String[0];
    }

    @Override
    public boolean createNewFile() throws IOException {
        if (this.isDirectory()) {
            this.provider.createDirectory(this.providerObjectName);
            return true;
        }
        return false;
    }

    @Override
    public boolean createNewFile(InputStream input) throws IOException {
        if (this.isFile()) {
            this.provider.upload(this.providerObjectName, input, this.fileAcl);
            return true;
        }
        return false;
    }

    @Override
    public boolean delete() {
        if (this.isFile) {
            this.provider.delete(this.providerObjectName, this.fileAcl);
        } else {
            this.provider.deleteDirectory(this.providerObjectName);
        }
        return true;
    }

    @Override
    public String getParent() {
        if (this.name.contains("/")) {
            return this.name.substring(0, this.name.lastIndexOf("/"));
        }
        return "";
    }

    @Override
    public boolean renameTo(String fileName) {
        if (this.isFile) {
            this.provider.rename(this.name, fileName, this.fileAcl);
            this.name = fileName;
        } else {
            this.provider.renameDirectory(this.name, fileName);
            this.name = fileName;
        }
        return true;
    }

    @Override
    public String getName() {
        if (this.isDirectory() || !this.name.contains("/")) {
            return this.name;
        }
        return this.name.substring(this.name.lastIndexOf("/") + 1, this.name.length());
    }

    @Override
    public String getFilePath() {
        return this.name;
    }

    @Override
    public String getAbsolutePath() {
        if (this.url.isEmpty()) {
            if (this.isDirectory()) {
                return this.provider.getDirectory(this.providerObjectName);
            }
            return this.provider.get(this.providerObjectName, this.fileAcl, DEFAULT_OBJECT_EXPIRATION_MINUTES);
        }
        return this.url;
    }

    @Override
    public long length() {
        return this.provider.getLength(this.providerObjectName, this.fileAcl);
    }

    @Override
    public Date lastModified() {
        return this.provider.getLastModified(this.providerObjectName, this.fileAcl);
    }

    @Override
    public GXFileCollection listFiles(String filter) {
        return (GXFileCollection)SpecificImplementation.GXExternalFileInfo.listFiles(filter, this.provider, this.providerObjectName);
    }

    @Override
    public GXFileCollection listFiles() {
        return (GXFileCollection)SpecificImplementation.GXExternalFileInfo.listFiles(null, this.provider, this.providerObjectName);
    }

    @Override
    public GXDirectoryCollection listDirectories() {
        GXDirectoryCollection dirs = new GXDirectoryCollection();
        for (String dir : this.provider.getSubDirectories(this.providerObjectName)) {
            dirs.add(new GXDirectory(new GXExternalFileInfo(dir, this.provider, false)));
        }
        return dirs;
    }

    @Override
    public InputStream getStream() {
        return this.provider.getStream(this.providerObjectName, this.fileAcl);
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public byte[] toBytes() throws IOException {
        InputStream stream = this.getStream();
        byte[] bytes = SpecificImplementation.GXutil.toByteArray(stream);
        stream.close();
        return bytes;
    }

    @Override
    public void fromBytes(byte[] data) throws IOException {
    }

    @Override
    public String readAllText(String encoding) throws IOException {
        return "";
    }

    @Override
    public List<String> readLines(String encoding) throws IOException {
        return null;
    }

    @Override
    public void writeStringToFile(String value, String encoding, boolean append) throws Exception {
    }

    @Override
    public void writeLines(String encoding, Vector value, boolean append) throws Exception {
    }

    @Override
    public File getFileInstance() {
        return null;
    }

    @Override
    public void copy(String origin, String destination) {
        this.provider.copy(origin, destination, this.fileAcl);
    }
}

