/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.CommonUtil;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.db.driver.ResourceAccessControlList;
import com.genexus.util.GXDirectory;
import com.genexus.util.GXDirectoryCollection;
import com.genexus.util.GXFileCollection;
import com.genexus.util.IGXFileInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class GXFileInfo
implements IGXFileInfo {
    private File fileSource;
    private boolean isDirectory;

    public GXFileInfo(File file) {
        this(file, false);
    }

    public GXFileInfo(File file, boolean isDirectory) {
        this.fileSource = file;
        this.isDirectory = isDirectory;
    }

    @Override
    public String getPath() {
        if (this.fileSource.isFile()) {
            String absoluteName = this.getAbsolutePath();
            if (!absoluteName.equals("")) {
                return new File(absoluteName).getParent();
            }
            return "";
        }
        return this.fileSource.getPath();
    }

    @Override
    public boolean exists() {
        if (this.isDirectory && this.fileSource.isDirectory() || !this.isDirectory && this.fileSource.isFile()) {
            return this.fileSource.exists();
        }
        return false;
    }

    @Override
    public boolean isFile() {
        return this.fileSource.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.fileSource.isDirectory();
    }

    @Override
    public boolean mkdir() {
        return this.fileSource.mkdirs();
    }

    @Override
    public String[] list() {
        return this.fileSource.list();
    }

    @Override
    public boolean createNewFile() throws IOException {
        return this.fileSource.createNewFile();
    }

    @Override
    public boolean createNewFile(InputStream input) throws IOException {
        this.fromBytes(SpecificImplementation.GXutil.toByteArray(input));
        return true;
    }

    @Override
    public boolean delete() {
        return this.fileSource.delete();
    }

    @Override
    public String getParent() {
        return this.fileSource.getParent();
    }

    @Override
    public boolean renameTo(String fileName) {
        boolean ok = this.fileSource.renameTo(new File(fileName));
        if (ok) {
            this.fileSource = new File(fileName);
        }
        return ok;
    }

    @Override
    public String getName() {
        return this.fileSource.getName();
    }

    @Override
    public String getFilePath() {
        return this.fileSource.getAbsolutePath();
    }

    @Override
    public String getAbsolutePath() {
        return this.fileSource.getAbsolutePath();
    }

    @Override
    public long length() {
        return this.fileSource.length();
    }

    @Override
    public Date lastModified() {
        return new Date(this.fileSource.lastModified());
    }

    @Override
    public void copy(String origin, String destination) throws IOException {
        SpecificImplementation.FileUtils.copyFile(new File(origin), new File(destination));
    }

    @Override
    public GXFileCollection listFiles(String strFilter) {
        File[] files;
        GXFileCollection gxfiles = null;
        if (strFilter.isEmpty()) {
            files = this.fileSource.listFiles();
        } else {
            strFilter = "*" + strFilter;
            WildcardFileFilter fileFilter = new WildcardFileFilter(strFilter, IOCase.INSENSITIVE);
            files = this.fileSource.listFiles((FileFilter)fileFilter);
        }
        if (files != null) {
            gxfiles = new GXFileCollection();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile()) continue;
                gxfiles.add(SpecificImplementation.FileUtils.createFile(files[i].getAbsolutePath(), ResourceAccessControlList.Default, true));
            }
        }
        return gxfiles;
    }

    @Override
    public GXFileCollection listFiles() {
        return this.listFiles(null);
    }

    @Override
    public GXDirectoryCollection listDirectories() {
        GXDirectoryCollection gxdirectories = null;
        File[] files = this.fileSource.listFiles();
        if (files != null) {
            gxdirectories = new GXDirectoryCollection();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                gxdirectories.add(new GXDirectory(files[i].getAbsolutePath()));
            }
        }
        return gxdirectories;
    }

    @Override
    public InputStream getStream() {
        try {
            return new FileInputStream(this.fileSource);
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }

    @Override
    public String getSeparator() {
        return File.separator;
    }

    @Override
    public byte[] toBytes() throws IOException {
        byte[] data = new byte[]{};
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.fileSource));){
            data = CommonUtil.readToByteArray(bis);
            bis.close();
            byte[] byArray = data;
            return byArray;
        }
    }

    @Override
    public void fromBytes(byte[] data) throws IOException {
        try (BufferedOutputStream destination = new BufferedOutputStream(new FileOutputStream(this.fileSource));){
            ((OutputStream)destination).write(data, 0, data.length);
        }
    }

    @Override
    public String readAllText(String encoding) throws IOException {
        return SpecificImplementation.FileUtils.readFileToString(this.fileSource, CommonUtil.normalizeEncodingName(encoding));
    }

    @Override
    public List<String> readLines(String encoding) throws IOException {
        return SpecificImplementation.FileUtils.readLines(this.fileSource, CommonUtil.normalizeEncodingName(encoding));
    }

    @Override
    public void writeStringToFile(String value, String encoding, boolean append) throws Exception {
        SpecificImplementation.FileUtils.writeStringToFile(this.fileSource, value, encoding, append);
    }

    @Override
    public void writeLines(String encoding, Vector value, boolean append) throws Exception {
        SpecificImplementation.FileUtils.writeLines(this.fileSource, encoding, value, append);
    }

    @Override
    public File getFileInstance() {
        return this.fileSource;
    }
}

