/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.CommonUtil;
import com.genexus.GXBaseCollection;
import com.genexus.SdtMessages_Message;
import com.genexus.internet.IGxJSONSerializable;
import com.genexus.util.GXProperty;
import java.util.Iterator;
import java.util.Vector;
import json.org.json.JSONException;
import json.org.json.JSONObject;

public class GXProperties
implements IGxJSONSerializable {
    private Vector<GXProperty> vector = new Vector();
    private boolean eof;
    private int lastElement;

    public void set(String name, String value) {
        this.put(name, value);
    }

    public void add(String name, String value) {
        this.addToTheEnd(name, value);
    }

    public void put(String name, String value) {
        int index = this.findElement(name);
        if (index >= 0) {
            this.vector.elementAt(index).setValue(value);
        } else {
            this.addToTheEnd(name, value);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (GXProperty property : this.vector) {
            builder.append(property.getValue());
        }
        return builder.toString();
    }

    private void addToTheEnd(String name, String value) {
        GXProperty prop = new GXProperty();
        prop.setKey(name);
        prop.setValue(value);
        this.vector.addElement(prop);
    }

    public String get(String name) {
        int index = this.findElement(name);
        if (index >= 0) {
            return this.vector.elementAt(index).getValue();
        }
        return "";
    }

    public void remove(String name) {
        int index = this.findElement(name);
        if (index >= 0) {
            this.vector.removeElementAt(index);
        }
    }

    public boolean containsKey(String name) {
        return this.findElement(name) != -1;
    }

    private int findElement(String name) {
        for (int i = 0; this.count() > i; ++i) {
            if (!this.item(i).getKey().equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public GXProperty item(int i) {
        return this.vector.elementAt(i);
    }

    public int getCount() {
        return this.count();
    }

    public int count() {
        return this.vector.size();
    }

    public void clear() {
        this.vector.removeAllElements();
    }

    public GXProperty first() {
        this.eof = false;
        if (this.count() > 0) {
            this.lastElement = 0;
            return this.vector.elementAt(0);
        }
        this.eof = true;
        return null;
    }

    public boolean eof() {
        return this.eof;
    }

    public GXProperty next() {
        ++this.lastElement;
        if (this.count() > this.lastElement) {
            return this.vector.elementAt(this.lastElement);
        }
        this.eof = true;
        return null;
    }

    @Override
    public Object GetJSONObject() {
        JSONObject jObj = new JSONObject();
        for (int i = 0; this.count() > i; ++i) {
            GXProperty prop = this.item(i);
            try {
                jObj.put(prop.getKey(), prop.getValue());
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return jObj;
    }

    @Override
    public String toJSonString() {
        JSONObject jObj = (JSONObject)this.GetJSONObject();
        return jObj.toString();
    }

    @Override
    public boolean fromJSonString(String s) {
        return this.fromJSonString(s, null);
    }

    @Override
    public boolean fromJSonString(String s, GXBaseCollection<SdtMessages_Message> messages) {
        this.clear();
        if (!s.equals("")) {
            try {
                JSONObject jObj = new JSONObject(s);
                Iterator<String> keys = jObj.keys();
                while (keys.hasNext()) {
                    String key = keys.next();
                    this.put(key, jObj.get(key).toString());
                }
                return true;
            }
            catch (JSONException ex) {
                CommonUtil.ErrorToMessages("fromjson error", ex.getMessage(), messages);
                return false;
            }
        }
        CommonUtil.ErrorToMessages("fromjson error", "empty string", messages);
        return false;
    }
}

