/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.util.Comparer;
import com.genexus.util.FastVector;
import java.util.Vector;

public class Quicksort {
    public static void sort(FastVector array, Comparer comparer) {
        Quicksort.sort(array, 0, array.size() - 1, comparer);
    }

    public static void sort(FastVector array, int start, int end, Comparer comparer) {
        if (end > start) {
            int p = Quicksort.partition(array, start, end, comparer);
            Quicksort.sort(array, start, p - 1, comparer);
            Quicksort.sort(array, p + 1, end, comparer);
        }
    }

    protected static int partition(FastVector array, int start, int end, Comparer comparer) {
        Object partitionElement = array.elementAt(end);
        int left = start - 1;
        int right = end;
        while (true) {
            if (comparer.compare(partitionElement, array.elementAt(++left)) >= 1 && left != end) {
                continue;
            }
            while (comparer.compare(partitionElement, array.elementAt(--right)) <= -1 && right != start) {
            }
            if (left >= right) break;
            Quicksort.swap(array, left, right);
        }
        Quicksort.swap(array, left, end);
        return left;
    }

    protected static void swap(FastVector array, int i, int j) {
        Object temp = array.elementAt(i);
        array.setElementAt(array.elementAt(j), i);
        array.setElementAt(temp, j);
    }

    public static void sort(Vector array, Comparer comparer) {
        Quicksort.sort(array, 0, array.size() - 1, comparer);
    }

    public static void sort(Vector array, int start, int end, Comparer comparer) {
        if (end > start) {
            int p = Quicksort.partition(array, start, end, comparer);
            Quicksort.sort(array, start, p - 1, comparer);
            Quicksort.sort(array, p + 1, end, comparer);
        }
    }

    protected static int partition(Vector array, int start, int end, Comparer comparer) {
        Object partitionElement = array.elementAt(end);
        int left = start - 1;
        int right = end;
        while (true) {
            if (comparer.compare(partitionElement, array.elementAt(++left)) >= 1 && left != end) {
                continue;
            }
            while (comparer.compare(partitionElement, array.elementAt(--right)) <= -1 && right != start) {
            }
            if (left >= right) break;
            Quicksort.swap(array, left, right);
        }
        Quicksort.swap(array, left, end);
        return left;
    }

    protected static void swap(Vector array, int i, int j) {
        Object temp = array.elementAt(i);
        array.setElementAt(array.elementAt(j), i);
        array.setElementAt(temp, j);
    }
}

