/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.xml;

import com.genexus.xml.NamedBasic;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;

public class ElementNode
extends NamedBasic {
    XMLAttributes m_attributes;
    String m_value;
    int[] indexMapping = new int[10];
    int indexMappingCount;
    boolean isReadRawXML;

    ElementNode(String name, String prefix, String local, String uri, XMLAttributes atts) {
        this(name, prefix, local, uri, atts, false);
    }

    ElementNode(String name, String prefix, String local, String uri, XMLAttributes atts, boolean isReadRaw) {
        super(name, prefix, local, uri);
        this.isReadRawXML = isReadRaw;
        this.setValue("");
        this.setAttributes(atts);
    }

    public void setAttributes(XMLAttributes atts) {
        int i;
        int length = atts.getLength();
        if (this.m_attributes == null) {
            this.m_attributes = new XMLAttributesImpl();
        }
        this.m_attributes.removeAllAttributes();
        for (i = 0; i < length; ++i) {
            QName iqname = new QName();
            atts.getName(i, iqname);
            this.m_attributes.addAttribute(iqname, atts.getType(i), atts.getValue(i));
        }
        this.indexMappingCount = 0;
        if (this.indexMapping == null || this.indexMapping.length < length) {
            this.indexMapping = new int[length];
        }
        for (i = 0; i < length; ++i) {
            String qname = this.m_attributes.getQName(i);
            if (!this.isReadRawXML && (qname.startsWith("xmlns:") || qname.equals("xmlns"))) continue;
            this.indexMapping[this.indexMappingCount++] = i;
        }
    }

    @Override
    public String getValue() {
        return this.m_value;
    }

    @Override
    public void setValue(String value) {
        this.m_value = value != null ? value : "";
    }

    @Override
    public int getNodeType() {
        return 1;
    }

    @Override
    public int getAttributeCount() {
        return this.indexMappingCount;
    }

    @Override
    public String getAttributeByIndex(int Index) {
        if (Index < 0 || Index >= this.indexMappingCount) {
            return "";
        }
        String res = this.m_attributes.getValue(this.indexMapping[Index]);
        return res != null ? res : "";
    }

    @Override
    public String getAttributeByName(String name) {
        String res = this.m_attributes.getValue(name);
        return res != null ? res : "";
    }

    @Override
    public int existsAttribute(String name) {
        return this.m_attributes.getValue(name) != null ? 1 : 0;
    }

    @Override
    public String getAttributeName(int Index) {
        if (Index < 0 || Index >= this.indexMappingCount) {
            return "";
        }
        String res = this.m_attributes.getQName(this.indexMapping[Index]);
        return res != null ? res : "";
    }

    @Override
    public String getAttributePrefix(int Index) {
        String qname = this.getAttributeName(Index);
        int pos = qname.indexOf(":");
        if (pos >= 0) {
            return qname.substring(0, pos);
        }
        return "";
    }

    @Override
    public String getAttributeLocalName(int Index) {
        if (Index < 0 || Index >= this.indexMappingCount) {
            return "";
        }
        String res = this.m_attributes.getLocalName(this.indexMapping[Index]);
        return res != null ? res : "";
    }

    @Override
    public String getAttributeURI(int Index) {
        if (Index < 0 || Index >= this.indexMappingCount) {
            return "";
        }
        String res = this.m_attributes.getURI(this.indexMapping[Index]);
        return res != null ? res : "";
    }

    @Override
    public String getAttEntityNotationByName(String name) {
        return "";
    }

    @Override
    public String getAttEntityNotationByIndex(int index) {
        return "";
    }
}

