/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.xml;

import com.genexus.CommonUtil;
import com.genexus.ResourceReader;
import com.genexus.internet.HttpClient;
import com.genexus.internet.IHttpRequest;
import com.genexus.xml.ElementNode;
import com.genexus.xml.EndTagNode;
import com.genexus.xml.EntityDeclaration;
import com.genexus.xml.Node;
import com.genexus.xml.NodesQueue;
import com.genexus.xml.PInstructionNode;
import com.genexus.xml.Pool;
import com.genexus.xml.ValuedNode;
import com.genexus.xml.XMLWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Hashtable;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDTDSource;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;

public class XMLReader
implements XMLDocumentHandler,
XMLErrorHandler,
XMLDTDHandler {
    private final int ERROR_FILE_NOT_FOUND = 1;
    private final int ERROR_TYPE_MISMATCH = 2;
    private final int ERROR_IO = 3;
    private final int ERROR_MEM = 4;
    private final int ERROR_PARSING = 5;
    public final int ValidationNone = 0;
    public final int ValidationAuto = 1;
    public final int ValidationDTD = 2;
    public final int ValidationSchema = 3;
    public final int ValidationXDR = 4;
    Node node;
    protected StandardParserConfiguration parserConfiguration;
    private NodesQueue nodesQueue;
    private XMLInputSource inputSource = null;
    private Pool elementsPool = new Pool();
    private Pool endtagsPool = new Pool();
    private Pool valuedNodesPool = new Pool();
    private Pool pinstructionsPool = new Pool();
    Hashtable<String, EntityDeclaration> entities = new Hashtable();
    private StringBuffer normalizationBuffer = new StringBuffer();
    private StringBuffer textBuffer = new StringBuffer(1024);
    private boolean pendingText = false;
    private boolean inCDATA = false;
    private int errCode;
    private String errDescription = "";
    private int errLineNumber = 0;
    private int errLinePos = 0;
    private boolean eof;
    private int simpleElements = 1;
    private int nextSimpleElements = 1;
    private boolean UTF8NodeEncoding = false;
    private int removeWhiteNodes = 1;
    private int removeWhiteSpaces = 1;
    private int linesNormalization = 1;
    private String documentEncoding = "";
    private int validationType = 0;
    private int readExternalEntities = 1;
    private boolean inDocument = false;
    private InputStream streamToClose = null;
    private XMLDTDSource xmlDtdSource;

    private void reset() {
        if (this.inputSource != null) {
            this.close();
        }
        this.eof = false;
        this.inCDATA = false;
        this.pendingText = false;
        this.textBuffer.setLength(0);
        this.errCode = 0;
        this.errDescription = "";
        this.errLineNumber = 0;
        this.errLinePos = 0;
        this.nodesQueue.deleteAll();
        this.inDocument = false;
        this.node = null;
    }

    public void startDocument(XMLLocator locator, String encoding, Augmentations a) throws XNIException {
    }

    public void startDocument(XMLLocator locator, String encoding) throws XNIException {
    }

    public void endDocument(Augmentations a) throws XNIException {
    }

    public void endDocument() throws XNIException {
    }

    public void startElement(QName qelement, XMLAttributes attrs, Augmentations a) throws XNIException {
        this.startElement(qelement, attrs);
    }

    public void startElement(QName qelement, XMLAttributes attrs) throws XNIException {
        this.inDocument = true;
        this.flushTextBuffer();
        ElementNode element = (ElementNode)this.elementsPool.getFree();
        if (element == null) {
            element = new ElementNode(qelement.rawname, qelement.prefix, qelement.localpart, qelement.uri, attrs, true);
            this.elementsPool.add(element);
        } else {
            element.setName(qelement.rawname);
            element.setPrefix(qelement.prefix);
            element.setLocalName(qelement.localpart);
            element.setNamespaceURI(qelement.uri);
            element.setAttributes(attrs);
            element.setValue("");
        }
        this.nodesQueue.addElement(element);
    }

    public void endElement(QName qelement, Augmentations a) throws XNIException {
        this.endElement(qelement);
    }

    public void endElement(QName qelement) throws XNIException {
        this.flushTextBuffer();
        EndTagNode tag = (EndTagNode)this.endtagsPool.getFree();
        if (tag == null) {
            tag = new EndTagNode(qelement.rawname, qelement.prefix, qelement.localpart, qelement.uri);
        } else {
            tag.setName(qelement.rawname);
            tag.setPrefix(qelement.prefix);
            tag.setLocalName(qelement.localpart);
            tag.setNamespaceURI(qelement.uri);
        }
        this.nodesQueue.addElement(tag);
    }

    public void emptyElement(QName qelement, XMLAttributes attrs, Augmentations a) throws XNIException {
        this.emptyElement(qelement, attrs);
    }

    public void emptyElement(QName qelement, XMLAttributes attrs) throws XNIException {
        this.startElement(qelement, attrs);
        this.endElement(qelement);
    }

    public void startPrefixMapping(String prefix, String uri, Augmentations a) throws XNIException {
    }

    public void startPrefixMapping(String prefix, String uri) throws XNIException {
    }

    public void endPrefixMapping(String prefix, Augmentations a) throws XNIException {
    }

    public void endPrefixMapping(String prefix) throws XNIException {
    }

    private String removeWhiteSpaces(String value) {
        int i;
        if (!this.isSpace(value.charAt(0)) && !this.isSpace(value.charAt(value.length() - 1))) {
            return value;
        }
        int begin = 0;
        int end = value.length() - 1;
        for (i = begin; i < value.length(); ++i) {
            if (this.isSpace(value.charAt(i))) continue;
            begin = i;
            break;
        }
        for (i = end; i >= begin; --i) {
            if (this.isSpace(value.charAt(i))) continue;
            end = i;
            break;
        }
        return value.substring(begin, end + 1);
    }

    private boolean isSpace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\t' || ch == '\r';
    }

    private boolean isWhiteSpace(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (this.isSpace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void flushTextBuffer() {
        if (this.pendingText) {
            String value = this.textBuffer.toString();
            int nodeType = this.inCDATA ? 32 : (this.isWhiteSpace(value) ? 16 : 4);
            ValuedNode vnode = (ValuedNode)this.valuedNodesPool.getFree();
            if (vnode != null) {
                vnode.setValue(value);
                vnode.setNodeType(nodeType);
            } else {
                vnode = new ValuedNode(nodeType, value);
            }
            this.nodesQueue.addElement(vnode);
            this.textBuffer.setLength(0);
            this.pendingText = false;
        }
    }

    public void startCDATA(Augmentations a) throws XNIException {
        this.startCDATA();
    }

    public void startCDATA() throws XNIException {
        this.flushTextBuffer();
        this.pendingText = true;
        this.inCDATA = true;
    }

    public void endCDATA(Augmentations a) throws XNIException {
        this.endCDATA();
    }

    public void endCDATA() throws XNIException {
        this.flushTextBuffer();
        this.inCDATA = false;
    }

    public void characters(XMLString text, Augmentations a) throws XNIException {
        this.characters(text);
    }

    public void characters(XMLString text) throws XNIException {
        if (!this.inDocument) {
            return;
        }
        this.pendingText = true;
        this.textBuffer.append(text.toString());
    }

    public void ignorableWhitespace(XMLString text, Augmentations a) throws XNIException {
        this.ignorableWhitespace(text);
    }

    public void ignorableWhitespace(XMLString text) throws XNIException {
        this.characters(text);
    }

    public void processingInstruction(String target, XMLString data, Augmentations a) throws XNIException {
        this.processingInstruction(target, data);
    }

    public void processingInstruction(String target, XMLString data) throws XNIException {
        this.flushTextBuffer();
        PInstructionNode pinode = (PInstructionNode)this.pinstructionsPool.getFree();
        if (pinode == null) {
            pinode = new PInstructionNode(target, data.toString());
        } else {
            pinode.setName(target);
            pinode.setValue(data.toString());
        }
        this.nodesQueue.addElement(pinode);
    }

    public void comment(XMLString text, Augmentations a) throws XNIException {
        this.comment(text);
    }

    public void comment(XMLString text) throws XNIException {
        this.flushTextBuffer();
        ValuedNode vnode = (ValuedNode)this.valuedNodesPool.getFree();
        if (vnode != null) {
            vnode.setValue(text.toString());
            vnode.setNodeType(8);
        } else {
            vnode = new ValuedNode(8, text.toString());
        }
        this.nodesQueue.addElement(vnode);
    }

    public void startEntity(String name, String publicId, String systemId, String baseSystemId, String encoding) throws XNIException {
    }

    public void endEntity(String name) throws XNIException {
    }

    public void textDecl(String version, String encoding, Augmentations a) throws XNIException {
    }

    public void textDecl(String version, String encoding) throws XNIException {
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations a) throws XNIException {
    }

    public void xmlDecl(String version, String encoding, String standalone) throws XNIException {
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations a) throws XNIException {
        this.doctypeDecl(rootElement, publicId, systemId);
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId) throws XNIException {
        this.flushTextBuffer();
        ValuedNode vnode = (ValuedNode)this.valuedNodesPool.getFree();
        if (vnode != null) {
            vnode.setValue(rootElement);
            vnode.setNodeType(128);
        } else {
            vnode = new ValuedNode(128, rootElement);
        }
        this.nodesQueue.addElement(vnode);
    }

    public void warning(String domain, String key, XMLParseException ex) throws XNIException {
        this.errCode = 5;
        this.errDescription = ex.getMessage();
        this.errLineNumber = ex.getLineNumber();
        this.errLinePos = ex.getColumnNumber();
        throw new XNIException((Exception)ex);
    }

    public void error(String domain, String key, XMLParseException ex) throws XNIException {
        this.errCode = 5;
        this.errDescription = ex.getMessage();
        this.errLineNumber = ex.getLineNumber();
        this.errLinePos = ex.getColumnNumber();
        throw new XNIException((Exception)ex);
    }

    public void fatalError(String domain, String key, XMLParseException ex) throws XNIException {
        this.errCode = 5;
        this.errDescription = ex.getMessage();
        this.errLineNumber = ex.getLineNumber();
        this.errLinePos = ex.getColumnNumber();
        throw new XNIException((Exception)ex);
    }

    public void attributeDecl(String elementName, String attributeName, String type, String[] enumeration, String defaultType, XMLString defaultValue) {
    }

    public void elementDecl(String name, String contentModel, Augmentations a) {
    }

    public void elementDecl(String name, String contentModel) {
    }

    public void endAttlist(Augmentations a) {
    }

    public void endAttlist() {
    }

    public void endConditional(Augmentations a) {
    }

    public void endConditional() {
    }

    public void endDTD(Augmentations a) {
    }

    public void endDTD() {
    }

    public void externalEntityDecl(String name, String publicId, String systemId, String baseSystemId, Augmentations a) {
    }

    public void externalEntityDecl(String name, String publicId, String systemId, String baseSystemId) {
    }

    public void internalEntityDecl(String name, XMLString text, XMLString text2, Augmentations a) {
    }

    public void internalEntityDecl(String name, XMLString text, XMLString text2) {
    }

    public void internalEntityDecl(String name, XMLString text) {
    }

    public void notationDecl(String name, String publicId, String systemId, Augmentations a) {
    }

    public void notationDecl(String name, String publicId, String systemId) {
    }

    public void startAttlist(String elementName, Augmentations a) {
    }

    public void startAttlist(String elementName) {
    }

    public void startConditional(short type, Augmentations a) {
    }

    public void startConditional(short type) {
    }

    public void startDTD(XMLLocator locator, Augmentations a) {
    }

    public void startDTD(XMLLocator locator) {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notation) {
        EntityDeclaration entity = new EntityDeclaration(name, publicId, systemId, notation);
        this.entities.put(name, entity);
    }

    private String unicodeToUTF8(String source) {
        if (source == null) {
            return source;
        }
        int length = source.length();
        char[] buf = new char[length * 3];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch <= '\u007f') {
                buf[j++] = ch;
                continue;
            }
            if (ch <= '\u07ff') {
                buf[j++] = (char)(0xC0 | ch >> 6);
                buf[j++] = (char)(0x80 | ch & 0x3F);
                continue;
            }
            buf[j++] = (char)(0xE0 | ch >> 12);
            buf[j++] = (char)(0x80 | ch >> 6 & 0x3F);
            buf[j++] = (char)(0x80 | ch & 0x3F);
        }
        return String.copyValueOf(buf, 0, j);
    }

    public short getNodeType() {
        return this.node != null ? (short)this.node.getNodeType() : (short)0;
    }

    public String getName() {
        if (this.node == null) {
            return "";
        }
        return this.UTF8NodeEncoding ? this.unicodeToUTF8(this.node.getName()) : this.node.getName();
    }

    public String getPrefix() {
        if (this.node == null) {
            return "";
        }
        return this.UTF8NodeEncoding ? this.unicodeToUTF8(this.node.getPrefix()) : this.node.getPrefix();
    }

    public String getLocalName() {
        if (this.node == null) {
            return "";
        }
        return this.UTF8NodeEncoding ? this.unicodeToUTF8(this.node.getLocalName()) : this.node.getLocalName();
    }

    public String getNamespaceURI() {
        if (this.node == null) {
            return "";
        }
        return this.UTF8NodeEncoding ? this.unicodeToUTF8(this.node.getNamespaceURI()) : this.node.getNamespaceURI();
    }

    public int getAttributeCount() {
        if (this.node == null) {
            return 0;
        }
        return this.node.getAttributeCount();
    }

    private String normalize_n_to_rn(String s) {
        this.normalizationBuffer.setLength(0);
        this.normalizationBuffer.append(s);
        int count = 0;
        int index = s.indexOf(10, 0);
        while (index >= 0) {
            this.normalizationBuffer.insert(index + count++, '\r');
            index = s.indexOf(10, index + 1);
        }
        return this.normalizationBuffer.toString();
    }

    public String getValue() {
        if (this.node == null) {
            return "";
        }
        String value = this.removeWhiteSpaces > 0 && this.getNodeType() == 4 ? this.removeWhiteSpaces(this.node.getValue()) : this.node.getValue();
        if (this.linesNormalization == 2) {
            value = this.normalize_n_to_rn(value);
        }
        return this.UTF8NodeEncoding ? this.unicodeToUTF8(value) : value;
    }

    public String getAttributeByIndex(int index) {
        if (this.node == null) {
            return "";
        }
        return this.UTF8NodeEncoding ? this.unicodeToUTF8(this.node.getAttributeByIndex(index - 1)) : this.node.getAttributeByIndex(index - 1);
    }

    public String getAttributeByName(String name) {
        if (this.node == null) {
            return "";
        }
        return this.UTF8NodeEncoding ? this.unicodeToUTF8(this.node.getAttributeByName(name)) : this.node.getAttributeByName(name);
    }

    public short existsAttribute(String name) {
        if (this.node == null) {
            return 0;
        }
        return (short)this.node.existsAttribute(name);
    }

    public String getAttributeName(int index) {
        if (this.node == null) {
            return "";
        }
        String value = this.UTF8NodeEncoding ? this.unicodeToUTF8(this.node.getAttributeName(index - 1)) : this.node.getAttributeName(index - 1);
        return value == null ? "" : value;
    }

    public String getAttributePrefix(int index) {
        if (this.node == null) {
            return "";
        }
        String value = this.UTF8NodeEncoding ? this.unicodeToUTF8(this.node.getAttributePrefix(index - 1)) : this.node.getAttributePrefix(index - 1);
        return value == null ? "" : value;
    }

    public String getAttributeLocalName(int index) {
        if (this.node == null) {
            return "";
        }
        String value = this.UTF8NodeEncoding ? this.unicodeToUTF8(this.node.getAttributeLocalName(index - 1)) : this.node.getAttributeLocalName(index - 1);
        return value == null ? "" : value;
    }

    public String getAttributeURI(int index) {
        if (this.node == null) {
            return "";
        }
        String value = this.UTF8NodeEncoding ? this.unicodeToUTF8(this.node.getAttributeURI(index - 1)) : this.node.getAttributeURI(index - 1);
        return value == null ? "" : value;
    }

    public String getAttEntityValueByName(String name) {
        if (this.node == null) {
            return "";
        }
        String attvalue = this.getAttributeByName(name);
        EntityDeclaration declaration = this.entities.get(attvalue);
        if (declaration == null) {
            return "";
        }
        String value = declaration.getSystemID();
        return value.length() > 0 ? value : declaration.getPublicID();
    }

    public String getAttEntityNotationByName(String name) {
        if (this.node == null) {
            return "";
        }
        String attvalue = this.getAttributeByName(name);
        EntityDeclaration declaration = this.entities.get(attvalue);
        if (declaration == null) {
            return "";
        }
        return declaration.getNotation();
    }

    public String getAttEntityValueByIndex(int Index) {
        if (this.node == null) {
            return "";
        }
        String attvalue = this.getAttributeByIndex(Index);
        EntityDeclaration declaration = this.entities.get(attvalue);
        if (declaration == null) {
            return "";
        }
        String value = declaration.getSystemID();
        return value.length() > 0 ? value : declaration.getPublicID();
    }

    public String getAttEntityNotationByIndex(int Index) {
        if (this.node == null) {
            return "";
        }
        String attvalue = this.getAttributeByIndex(Index);
        EntityDeclaration declaration = this.entities.get(attvalue);
        if (declaration == null) {
            return "";
        }
        return declaration.getNotation();
    }

    public XMLReader() {
        this.nodesQueue = new NodesQueue();
        this.parserConfiguration = new StandardParserConfiguration();
        this.parserConfiguration.setDocumentHandler((XMLDocumentHandler)this);
        this.parserConfiguration.setErrorHandler((XMLErrorHandler)this);
        this.parserConfiguration.setDTDHandler((XMLDTDHandler)this);
        this.setReadExternalEntities(0);
        this.reset();
    }

    public void open(String url) {
        this.reset();
        try {
            this.inputSource = new XMLInputSource(null, url, null, (InputStream)new FileInputStream(new File(url)), null);
            if (this.documentEncoding.length() > 0) {
                this.inputSource.setEncoding(CommonUtil.normalizeEncodingName(this.documentEncoding));
            }
            this.parserConfiguration.setInputSource(this.inputSource);
        }
        catch (IOException e) {
            this.errCode = 3;
            this.errDescription = e.getMessage();
        }
    }

    public void openResource(String url) {
        InputStream stream;
        this.reset();
        this.streamToClose = stream = ResourceReader.getFile(url);
        try {
            if (stream == null) {
                this.errCode = 3;
                this.errDescription = "File not found: " + url;
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            this.inputSource = this.documentEncoding.length() > 0 ? new XMLInputSource(null, null, null, (Reader)reader, this.documentEncoding) : new XMLInputSource(null, null, null, (Reader)reader, null);
            this.parserConfiguration.setInputSource(this.inputSource);
        }
        catch (IOException e) {
            this.errCode = 3;
            this.errDescription = e.getMessage();
        }
    }

    public void openFromString(String s) {
        this.reset();
        try {
            this.inputSource = this.documentEncoding.length() > 0 ? new XMLInputSource(null, null, null, (Reader)new StringReader(s), this.documentEncoding) : new XMLInputSource(null, null, null, (Reader)new StringReader(s), null);
            this.parserConfiguration.setInputSource(this.inputSource);
        }
        catch (IOException e) {
            this.errCode = 3;
            this.errDescription = e.getMessage();
        }
    }

    public void openResponse(HttpClient client) {
        this.reset();
        try {
            InputStream is = client.getInputStream();
            this.inputSource = this.documentEncoding.length() > 0 ? new XMLInputSource(null, null, null, is, this.documentEncoding) : new XMLInputSource(null, null, null, is, null);
            this.parserConfiguration.setInputSource(this.inputSource);
        }
        catch (IOException e) {
            this.errCode = 3;
            this.errDescription = e.getMessage();
        }
    }

    public void openRequest(IHttpRequest client) {
        this.reset();
        try {
            InputStream is = client.getInputStream();
            this.inputSource = this.documentEncoding.length() > 0 ? new XMLInputSource(null, null, null, is, this.documentEncoding) : new XMLInputSource(null, null, null, is, null);
            this.parserConfiguration.setInputSource(this.inputSource);
        }
        catch (IOException e) {
            this.errCode = 3;
            this.errDescription = e.getMessage();
        }
    }

    public void close() {
        try {
            if (this.streamToClose != null) {
                this.streamToClose.close();
            }
            if (this.inputSource != null) {
                Reader reader = this.inputSource.getCharacterStream();
                if (reader != null) {
                    reader.close();
                } else {
                    InputStream is = this.inputSource.getByteStream();
                    if (is != null) {
                        is.close();
                    }
                }
            }
            if (this.parserConfiguration != null) {
                this.parserConfiguration.cleanup();
            }
        }
        catch (IOException e) {
            this.errCode = 3;
            this.errDescription = e.getMessage();
        }
        this.inputSource = null;
    }

    protected void finalize() {
        this.close();
    }

    public void addSchema(String url, String schema) {
        url = url.replaceAll(" ", "%20");
        String externalSchema = schema + " " + url;
        this.parserConfiguration.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)externalSchema);
    }

    public void addSchema(String url) {
        this.addSchema(url, "");
    }

    public void setRemoveWhiteNodes(int value) {
        this.removeWhiteNodes = value;
    }

    public byte getRemoveWhiteNodes() {
        return (byte)this.removeWhiteNodes;
    }

    public void setRemoveWhiteSpaces(int value) {
        this.removeWhiteSpaces = value;
    }

    public byte getRemoveWhiteSpaces() {
        return (byte)this.removeWhiteSpaces;
    }

    public void setLinesNormalization(int Normalization) {
        this.linesNormalization = Normalization;
        if (this.linesNormalization == 0) {
            this.parserConfiguration.setFeature("http:www.genexus.com.uy/java/xmlreader/linesNormalization", false);
        } else {
            this.parserConfiguration.setFeature("http:www.genexus.com.uy/java/xmlreader/linesNormalization", true);
        }
    }

    public short getLinesNormalization() {
        return (short)this.linesNormalization;
    }

    public byte getSimpleElements() {
        return (byte)this.nextSimpleElements;
    }

    public void setSimpleElements(int value) {
        this.nextSimpleElements = value;
    }

    public void setDocEncoding(String encoding) {
        this.documentEncoding = encoding;
    }

    public void setNodeEncoding(String encoding) {
        if (encoding.equals("UTF-8")) {
            this.UTF8NodeEncoding = true;
        } else if (encoding.equals("ANSI")) {
            this.UTF8NodeEncoding = false;
        }
    }

    private int getNodeExtent() {
        int size = this.nodesQueue.size();
        if (size == 0) {
            return 0;
        }
        if (this.simpleElements == 0) {
            return 1;
        }
        int i = 0;
        Node currentNode = this.nodesQueue.elementAt(i);
        if (currentNode.getNodeType() != 1) {
            return 1;
        }
        if (++i >= size) {
            return 0;
        }
        currentNode = this.nodesQueue.elementAt(i);
        if (currentNode.getNodeType() == 2) {
            return i + 1;
        }
        if (currentNode.getNodeType() != 4 && currentNode.getNodeType() != 16) {
            return 1;
        }
        if (++i >= size) {
            return 0;
        }
        currentNode = this.nodesQueue.elementAt(i);
        if (currentNode.getNodeType() == 2) {
            return i + 1;
        }
        return 1;
    }

    private void fillQueue() {
        block4: {
            try {
                boolean ret;
                while (this.errCode == 0 && this.getNodeExtent() == 0 && (ret = this.parserConfiguration.parse(false))) {
                }
                this.eof = this.getNodeExtent() == 0;
            }
            catch (IOException e) {
                this.errCode = 3;
                this.errDescription = e.getMessage();
            }
            catch (XNIException ex) {
                if (this.errCode != 0) break block4;
                this.errCode = 5;
                this.errDescription = ex.getMessage();
            }
        }
    }

    public short getIsSimple() {
        return this.getNodeExtent() > 1 ? (short)1 : 0;
    }

    private void deleteFirstNode() {
        Node deleted = this.nodesQueue.elementAt(0);
        switch (deleted.getNodeType()) {
            case 1: {
                this.elementsPool.free(deleted);
                break;
            }
            case 2: {
                this.endtagsPool.free(deleted);
                break;
            }
            case 64: {
                this.pinstructionsPool.free(deleted);
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 128: {
                this.valuedNodesPool.free(deleted);
            }
        }
        this.nodesQueue.deleteFirst();
    }

    public short read() {
        short ret;
        while ((ret = this.readOne()) > 0 && this.removeWhiteNodes != 0 && this.getNodeType() == 16) {
        }
        return ret;
    }

    private short readOne() {
        if (this.errCode > 0) {
            return 0;
        }
        int extent = this.getNodeExtent();
        for (int i = 0; i < extent; ++i) {
            this.deleteFirstNode();
        }
        this.simpleElements = this.nextSimpleElements;
        this.fillQueue();
        extent = this.getNodeExtent();
        if (extent > 0) {
            this.node = this.nodesQueue.elementAt(0);
            if (extent > 2) {
                this.node.setValue(this.nodesQueue.elementAt(1).getValue());
            }
        }
        return extent > 0 ? (short)1 : 0;
    }

    public short readType(int nodeType) {
        return this.readType(nodeType, "");
    }

    public short readType(int nodeType, String name) {
        short ret;
        name = name.trim();
        while ((ret = this.read()) == 1 && ((this.node.getNodeType() & nodeType) <= 0 || name.length() != 0 && !this.getName().equals(name))) {
        }
        return ret;
    }

    public byte getValidationType() {
        return (byte)this.validationType;
    }

    public void setValidationType(int value) {
        this.validationType = value;
        switch (value) {
            case 0: {
                this.parserConfiguration.setFeature("http://xml.org/sax/features/validation", false);
                break;
            }
            case 1: {
                this.parserConfiguration.setFeature("http://xml.org/sax/features/validation", true);
                this.parserConfiguration.setFeature("http://apache.org/xml/features/validation/dynamic", true);
                break;
            }
            case 2: {
                this.parserConfiguration.setFeature("http://apache.org/xml/features/validation/dynamic", false);
                this.parserConfiguration.setFeature("http://xml.org/sax/features/validation", true);
                break;
            }
            case 3: {
                this.parserConfiguration.setFeature("http://apache.org/xml/features/validation/dynamic", false);
                this.parserConfiguration.setFeature("http://xml.org/sax/features/validation", true);
                this.parserConfiguration.setFeature("http://apache.org/xml/features/validation/schema", true);
                break;
            }
            default: {
                this.parserConfiguration.setFeature("http://xml.org/sax/features/validation", false);
                this.validationType = 0;
            }
        }
    }

    public byte getReadExternalEntities() {
        return (byte)this.readExternalEntities;
    }

    public void setReadExternalEntities(int value) {
        this.readExternalEntities = value;
        this.parserConfiguration.setFeature("http://xml.org/sax/features/external-general-entities", value != 0);
        this.parserConfiguration.setFeature("http://xml.org/sax/features/external-parameter-entities", value != 0);
        try {
            this.parserConfiguration.setFeature("http://apache.org/xml/features/disallow-doctype-decl", value == 0);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        this.parserConfiguration.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", value != 0);
    }

    private String SkipAndReadRaw(boolean GenerateXML) {
        String sRet = null;
        String AttName = null;
        byte OldRemoveWhiteSpaces = 0;
        StringWriter sWriter = null;
        XMLWriter xmlWriter = null;
        if (this.getNodeType() != 1) {
            return "";
        }
        if (GenerateXML) {
            sWriter = new StringWriter();
            xmlWriter = new XMLWriter();
            xmlWriter.setWriter(new PrintWriter(sWriter));
            OldRemoveWhiteSpaces = this.getRemoveWhiteSpaces();
            this.setRemoveWhiteSpaces(0);
        }
        int Level2 = 0;
        block11: do {
            switch (this.getNodeType()) {
                case 1: {
                    int i;
                    if (GenerateXML) {
                        if (this.getIsSimple() > 0) {
                            xmlWriter.writeElement(this.getName(), this.getValue());
                        } else {
                            ++Level2;
                            xmlWriter.writeStartElement(this.getName());
                        }
                        i = 1;
                        while (xmlWriter.getErrCode() == 0 && (AttName = this.getAttributeName(i)).length() > 0) {
                            xmlWriter.writeAttribute(AttName, this.getAttributeByIndex(i));
                            ++i;
                        }
                        continue block11;
                    }
                    if (this.getIsSimple() > 0) break;
                    ++Level2;
                    continue block11;
                }
                case 2: {
                    if (GenerateXML) {
                        xmlWriter.writeEndElement();
                    }
                    --Level2;
                    break;
                }
                case 16: {
                    break;
                }
                case 4: {
                    int i;
                    if (!GenerateXML) break;
                    String sValue = this.getValue();
                    if (sValue.startsWith("\r\n")) {
                        sValue = sValue.substring(2);
                    } else if (sValue.startsWith("\n")) {
                        sValue = sValue.substring(1);
                    }
                    for (i = sValue.length() - 1; i >= 0 && (sValue.charAt(i) == ' ' || sValue.charAt(i) == '\t'); --i) {
                    }
                    if (i < sValue.length() - 1) {
                        xmlWriter.writeText(sValue.substring(0, i));
                        break;
                    }
                    xmlWriter.writeText(sValue);
                    break;
                }
                case 8: {
                    if (!GenerateXML) break;
                    xmlWriter.writeComment(this.getValue());
                    break;
                }
                case 32: {
                    if (!GenerateXML) break;
                    xmlWriter.writeCData(this.getValue());
                    break;
                }
                case 64: {
                    if (!GenerateXML) break;
                    xmlWriter.writeProcessingInstruction(this.getName(), this.getValue());
                }
            }
        } while (this.read() > 0 && Level2 > 0);
        if (GenerateXML) {
            xmlWriter.close();
            sRet = this.getErrCode() == 0 ? sWriter.toString() : "";
            try {
                sWriter.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (sRet == null) {
                sRet = "";
            }
            this.setRemoveWhiteSpaces(OldRemoveWhiteSpaces);
        }
        return sRet;
    }

    public void skip() {
        this.SkipAndReadRaw(false);
    }

    public String readRawXML() {
        return this.SkipAndReadRaw(true);
    }

    public boolean getEof() {
        return this.eof || this.errCode > 0;
    }

    public short getErrCode() {
        return (short)this.errCode;
    }

    public short getErrLineNumber() {
        return (short)this.errLineNumber;
    }

    public short getErrLinePos() {
        return (short)this.errLinePos;
    }

    public String getErrDescription() {
        return this.errDescription;
    }

    private void setErrDescription(String s) {
        this.errDescription = s;
        if (s.length() > 0) {
            System.err.println(s);
        }
    }

    public short getElementType() {
        return 1;
    }

    public short getEndTagType() {
        return 2;
    }

    public short getTextType() {
        return 4;
    }

    public short getCommentType() {
        return 8;
    }

    public short getWhiteSpaceType() {
        return 16;
    }

    public short getCDataType() {
        return 32;
    }

    public short getProcessingInstructionType() {
        return 64;
    }

    public short getDoctypeType() {
        return 128;
    }

    public void startDocument(XMLLocator p1, String p2, NamespaceContext p3, Augmentations p4) {
    }

    public void startGeneralEntity(String p1, XMLResourceIdentifier p2, String p3, Augmentations a) {
    }

    public void endGeneralEntity(String p1, Augmentations a) {
    }

    public void endExternalSubset(Augmentations a) {
    }

    public void endParameterEntity(Augmentations a) {
    }

    public void endParameterEntity(String p1, Augmentations a) {
    }

    public void externalEntityDecl(String p1, XMLResourceIdentifier p2, Augmentations a) {
    }

    public void ignoredCharacters(XMLString p1, Augmentations a) {
    }

    public void notationDecl(String p1, XMLResourceIdentifier p2, Augmentations a) {
    }

    public void startExternalSubset(XMLResourceIdentifier p1, Augmentations a) {
    }

    public void startParameterEntity(String p1, XMLResourceIdentifier p2, String p3, Augmentations a) {
    }

    public void unparsedEntityDecl(String p1, XMLResourceIdentifier p2, String p3, Augmentations a) {
        System.err.println("XMLReader.unparsedEntityDecl");
    }

    public void setDocumentSource(XMLDocumentSource s) {
    }

    public XMLDocumentSource getDocumentSource() {
        return null;
    }

    public void attributeDecl(String elementName, String attributeName, String type, String[] enumeration, String defaultType, XMLString defaultValue, XMLString nonNormalizedDefaultValue, Augmentations augmentations) throws XNIException {
    }

    public void setDTDSource(XMLDTDSource xmlDtdSource) {
        this.xmlDtdSource = xmlDtdSource;
    }

    public XMLDTDSource getDTDSource() {
        return this.xmlDtdSource;
    }
}

