/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.genexus.opentelemetry.OpenTelemetryHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import json.org.json.JSONException;
import json.org.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WrapperUtils {
    private static Logger log = LogManager.getLogger(WrapperUtils.class);
    public static ThreadLocal<String> requestBodyThreadLocal = new ThreadLocal();

    public static String getJsonFromRestException(int[] statusCode, String reasonPhrase, boolean applicationException, Throwable ex) {
        OpenTelemetryHelper.recordException((Throwable)ex);
        int localStatusCode = statusCode[0];
        if (!applicationException) {
            localStatusCode = 500;
            reasonPhrase = "Internal Server Error";
            if (ex instanceof JsonProcessingException) {
                localStatusCode = 400;
                reasonPhrase = "Bad Request";
            }
        }
        log.error("Error executing REST service", ex);
        JSONObject errorJson = new JSONObject();
        try {
            JSONObject obj = new JSONObject();
            obj.put("code", localStatusCode);
            obj.put("message", (Object)reasonPhrase);
            errorJson.put("error", (Object)obj);
        }
        catch (JSONException e) {
            log.error("Invalid JSON", (Throwable)e);
        }
        statusCode[0] = localStatusCode;
        return errorJson.toString();
    }

    public static InputStream storeRestRequestBody(InputStream is) throws IOException {
        String body = new BufferedReader(new InputStreamReader(is, "UTF-8")).lines().collect(Collectors.joining("\n"));
        requestBodyThreadLocal.set(body);
        return IOUtils.toInputStream((String)body, (String)"UTF-8");
    }
}

