/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.diagnostics.core.provider;

import com.genexus.diagnostics.core.ILogger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Log4J2Logger
implements ILogger {
    private Logger log;

    public Log4J2Logger(Class<?> clazz) {
        this.log = LogManager.getLogger(clazz);
    }

    public Log4J2Logger(String clazz) {
        this.log = LogManager.getLogger((String)clazz);
    }

    public void fatal(String msg) {
        this.log.fatal(msg);
    }

    public void fatal(String msg, Throwable ex) {
        this.log.fatal(msg, ex);
    }

    public void fatal(String msg1, String msg2, Throwable ex) {
        if (this.log.isFatalEnabled()) {
            this.log.fatal(msg1 + msg2, ex);
        }
    }

    public void fatal(Throwable ex, String[] list) {
        if (this.log.isFatalEnabled()) {
            for (String parm : list) {
                this.log.fatal(parm);
            }
        }
    }

    public void fatal(String[] list) {
        this.fatal(null, list);
    }

    public void error(String msg, Throwable ex) {
        this.log.error(msg, ex);
    }

    public void error(String msg1, String msg2, Throwable ex) {
        if (this.log.isErrorEnabled()) {
            this.log.error(msg1 + msg2, ex);
        }
    }

    public void error(Throwable ex, String[] list) {
        if (this.log.isErrorEnabled()) {
            for (String parm : list) {
                this.log.error(parm);
            }
        }
    }

    public void error(String[] list) {
        this.error(null, list);
    }

    public void error(String msg) {
        this.log.error(msg);
    }

    public void warn(Throwable ex, String[] list) {
        if (this.log.isWarnEnabled()) {
            StringBuilder msg = new StringBuilder();
            for (String parm : list) {
                msg.append(parm);
            }
            if (ex != null) {
                this.log.warn((CharSequence)msg, ex);
            } else {
                this.log.warn((CharSequence)msg);
            }
        }
    }

    public void warn(String[] list) {
        this.warn(null, list);
    }

    public void warn(String msg, Throwable ex) {
        this.log.warn(msg, ex);
    }

    public void debug(String msg) {
        this.log.debug(msg);
    }

    public void debug(Throwable ex, String[] list) {
        if (this.log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            for (String parm : list) {
                msg.append(parm);
            }
            if (ex != null) {
                this.log.debug((CharSequence)msg, ex);
            } else {
                this.log.debug((CharSequence)msg);
            }
        }
    }

    public void debug(String[] list) {
        this.debug(null, list);
    }

    public void debug(String msg1, String msg2, Throwable ex) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(msg1 + msg2, ex);
        }
    }

    public void debug(String msg, Throwable ex) {
        this.log.debug(msg, ex);
    }

    public void info(String[] list) {
        if (this.log.isInfoEnabled()) {
            StringBuilder msg = new StringBuilder();
            for (String parm : list) {
                msg.append(parm);
            }
            this.log.info((CharSequence)msg);
        }
    }

    public void info(String msg) {
        this.log.info(msg);
    }

    public void warn(String msg) {
        this.log.warn(msg);
    }

    public void trace(String msg) {
        this.log.trace(msg);
    }

    public void trace(Throwable ex, String[] list) {
        if (this.log.isTraceEnabled()) {
            StringBuilder msg = new StringBuilder();
            for (String parm : list) {
                msg.append(parm);
            }
            if (ex != null) {
                this.log.trace((CharSequence)msg, ex);
            } else {
                this.log.trace((CharSequence)msg);
            }
        }
    }

    public void trace(String[] list) {
        this.trace(null, list);
    }

    public void trace(String msg1, String msg2, Throwable ex) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(msg1 + msg2, ex);
        }
    }

    public void trace(String msg, Throwable ex) {
        this.log.trace(msg, ex);
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }
}

