/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.specific.java;

import com.genexus.common.interfaces.IExtensionLogManager;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.provider.Log4J2Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.lookup.MapLookup;
import org.apache.logging.log4j.status.StatusLogger;

public class LogManager
implements IExtensionLogManager {
    private static boolean initialized;

    public static void configure(String logBasePath) {
        MapLookup.setMainArguments((String[])new String[]{logBasePath});
        StatusLogger.getLogger().setLevel(Level.OFF);
    }

    public static void initialize(String logBasePath) {
        if (!initialized) {
            initialized = true;
            LogManager.configure(logBasePath);
            if (SpecificImplementation.LogManager == null) {
                SpecificImplementation.LogManager = new LogManager();
            }
        }
    }

    public static ILogger initialize(String logBasePath, Class<?> clazz) {
        LogManager.initialize(logBasePath);
        return SpecificImplementation.LogManager.getLogger(clazz);
    }

    public ILogger getLogger(Class<?> clazz) {
        return new Log4J2Logger(clazz);
    }

    public ILogger getLogger(String className) {
        return new Log4J2Logger(className);
    }

    static {
        LogManager.configure(".");
    }
}

