/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.ApplicationContext;
import com.genexus.CacheFactory;
import com.genexus.ClientContext;
import com.genexus.ClientPreferences;
import com.genexus.CommonUtil;
import com.genexus.DebugFlag;
import com.genexus.GXProcedure;
import com.genexus.GXSmartCacheProvider;
import com.genexus.GXutil;
import com.genexus.ICacheService;
import com.genexus.ICleanedup;
import com.genexus.LocalUtil;
import com.genexus.Messages;
import com.genexus.ModelContext;
import com.genexus.Preferences;
import com.genexus.PrivateUtilities;
import com.genexus.ServerPreferences;
import com.genexus.common.interfaces.IGxEjbContext;
import com.genexus.db.DBConnectionManager;
import com.genexus.db.DynamicExecute;
import com.genexus.db.IDataStoreProvider;
import com.genexus.db.Namespace;
import com.genexus.db.UserInformation;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.ExternalProvider;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.reports.GXReportViewerThreaded;
import com.genexus.specific.java.Connect;
import com.genexus.util.GXQueue;
import com.genexus.util.GXService;
import com.genexus.util.GXServices;
import com.genexus.util.PropertiesManager;
import com.genexus.util.ReorgSubmitThreadPool;
import com.genexus.util.SubmitThreadPool;
import com.genexus.xml.XMLWriter;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class Application {
    public static ILogger logger;
    public static boolean usingQueue;
    public static Object realMainProgram;
    public static Object nullObject;
    private static final String UNKNOWN_CALLER = "<unknown>";
    static Properties ORBproperties;
    private static Boolean isJMXEnabled;
    public static Class gxCfg;
    private static Vector<ICleanedup> toCleanup;
    static LocalUtil localUtil;
    static Class ClassName;
    private static volatile ExternalProvider externalProvider;
    private static volatile ExternalProvider externalProviderAPI;
    private static Object objectLock;
    private static volatile boolean initialized;
    static Date startDateTime;
    private static String dbmsVersion;
    private static boolean showConnectError;
    public static boolean executingGeneratorTool;
    static boolean useSmartCache;

    public static void onExitCleanup() {
        if (toCleanup != null) {
            for (int i = 0; i < toCleanup.size(); ++i) {
                try {
                    ICleanedup cleanedUp = toCleanup.elementAt(i);
                    if (cleanedUp instanceof GXReportViewerThreaded) continue;
                    cleanedUp.cleanup();
                    continue;
                }
                catch (Throwable e) {
                    logger.error("onExitCleanup", e);
                }
            }
            toCleanup.removeAllElements();
        }
        DBConnectionManager.getInstance().disconnectAll();
    }

    public static void cleanupConnection(int handle) {
        try {
            Application.getConnectionManager().disconnect(handle);
        }
        catch (Throwable e) {
            logger.error("cleanupConnection/Can't disconnect " + handle, e);
        }
    }

    private static void setORBProperties(String host) {
        ORBproperties = new Properties();
        ORBproperties.put("SVCnameroot", "NameService");
        if (!ApplicationContext.getInstance().isApplicationServer() && host.length() != 0) {
            ORBproperties.put("ORBagentAddr", host);
            ORBproperties.put("org.omg.CORBA.ORBInitialHost", host);
        }
    }

    public static Properties getORBProperties() {
        if (ORBproperties == null) {
            Application.setORBProperties(ServerPreferences.getInstance(gxCfg).getNAME_HOST());
        }
        return ORBproperties;
    }

    public static boolean getUserIdServerAsUserId(int handle) {
        if (ApplicationContext.getInstance().isApplicationServer()) {
            return Application.getConnectionManager().getUserInformation(handle).getProperty("USERIDSERVER_AS_USERID").equals(String.valueOf(true));
        }
        return Application.getClientPreferences().getLOGIN_AS_USERID();
    }

    public static void init(Class gxCfg) {
        Application.init(gxCfg, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Class gxCfg, boolean doLogin) {
        if (!initialized) {
            Object object = objectLock;
            synchronized (object) {
                if (!initialized) {
                    Application.gxCfg = gxCfg;
                    ClientContext.setModelContext((ModelContext)new ModelContext(gxCfg));
                    DebugFlag.DEBUG = ClientContext.getModelContext().getClientPreferences().getJDBC_LOGEnabled();
                    Namespace.createNamespaces(ClientContext.getModelContext().getPreferences().getIniFile());
                    XMLWriter.setUseTagToCloseElement((boolean)ClientContext.getModelContext().getClientPreferences().getProperty("UseTagToCloseElement", "0").equals("1"));
                    startDateTime = new Date();
                    initialized = true;
                }
            }
        }
    }

    public static GXServices getGXServices() {
        return GXServices.getInstance();
    }

    public static ExternalProvider getExternalProviderAPI() {
        if (externalProviderAPI == null && (externalProviderAPI = Application.getExternalProviderImpl("StorageAPI")) == null) {
            externalProviderAPI = Application.getExternalProvider();
        }
        return externalProviderAPI;
    }

    public static ExternalProvider getExternalProvider() {
        if (externalProvider == null) {
            externalProvider = Application.getExternalProviderImpl("Storage");
        }
        return externalProvider;
    }

    private static ExternalProvider getExternalProviderImpl(String service) {
        ExternalProvider externalProviderImpl = null;
        GXService providerService = Application.getGXServices().get(service);
        if (providerService != null) {
            Class<?> providerClass;
            try {
                providerClass = Class.forName(providerService.getClassName());
            }
            catch (ClassNotFoundException e) {
                logger.fatal("Unrecognized External Provider class (ClassNotFound) : " + providerService.getName() + " / " + providerService.getClassName(), (Throwable)e);
                throw new InternalError("Unrecognized External Provider class (ClassNotFound) : " + providerService.getName() + " / " + providerService.getClassName());
            }
            try {
                externalProviderImpl = (ExternalProvider)providerClass.getConstructor(String.class).newInstance(service);
            }
            catch (Exception e) {
                logger.fatal("Unable to Initialize External Provider Class: " + providerService.getClassName(), (Throwable)e);
                throw new InternalError("Unable to Initialize External Provider Class: " + providerService.getClassName(), e);
            }
        }
        return externalProviderImpl;
    }

    public static Date getStartDateTime() {
        return startDateTime;
    }

    public static ModelContext getClientContext() {
        return ClientContext.getModelContext();
    }

    public static void exitApplet() {
        if (ApplicationContext.getInstance().getReorganization()) {
            ReorgSubmitThreadPool.waitForEnd();
        } else {
            SubmitThreadPool.waitForEnd();
        }
        try {
            if (ApplicationContext.getInstance().isMsgsToUI()) {
                logger.debug("Exiting VM (1)...");
                Application.onExitCleanup();
                if (ApplicationContext.getInstance().getReorganization() && ReorgSubmitThreadPool.hasAnyError()) {
                    System.exit(1);
                } else {
                    System.exit(0);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static void exitAppletOnError() {
        if (ApplicationContext.getInstance().getReorganization()) {
            ReorgSubmitThreadPool.waitForEnd();
        } else {
            SubmitThreadPool.waitForEnd();
        }
        try {
            logger.debug("Exiting VM (2)...");
            System.exit(0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static void exit() {
        Application.exitApplet();
    }

    public static ClientPreferences getClientPreferences() {
        return (ClientPreferences)ClientContext.getModelContext().getClientPreferences();
    }

    public static void addCleanup(ICleanedup o) {
        toCleanup.addElement(o);
    }

    public static void cleanupElements() {
        ICacheService cacheService;
        PropertiesManager.getInstance().flushProperties();
        for (int i = 0; i < toCleanup.size(); ++i) {
            toCleanup.elementAt(i).cleanup();
        }
        toCleanup.removeAllElements();
        if (Preferences.getDefaultPreferences().getCACHING() && (cacheService = CacheFactory.getInstance()) instanceof Closeable) {
            try {
                ((Closeable)cacheService).close();
            }
            catch (IOException ioex) {
                logger.error("Can\u00b4t close cache service", (Throwable)ioex);
            }
        }
    }

    public static void cleanupOnError() {
        Application.cleanupElements();
        Application.exitAppletOnError();
    }

    public static void cleanup() {
        Application.cleanupElements();
        Application.exit();
    }

    public static void cleanup(ModelContext context, Object o, int remoteHandle) {
        if (realMainProgram == o) {
            if (!Application.getClientContext().getClientPreferences().getMDI_FORMS() && Application.getClientContext().getClientPreferences().getSDI_CLOSING_FIX()) {
                Application.cleanupConnection(remoteHandle);
                Application.cleanup();
                realMainProgram = null;
            } else {
                Object tmp = realMainProgram;
                realMainProgram = nullObject;
                realMainProgram = tmp;
                Application.cleanupConnection(remoteHandle);
                Application.cleanup();
                realMainProgram = null;
            }
        }
        if (o instanceof GXProcedure) {
            ((GXProcedure)o).endExecute(o.getClass().getName());
        }
    }

    public static DBConnectionManager getConnectionManager() {
        return DBConnectionManager.getInstance();
    }

    public static DBConnectionManager getConnectionManager(ModelContext context) {
        return DBConnectionManager.getInstance(context);
    }

    public static void setCurrentLocation(String location) {
        ApplicationContext.getInstance().setCurrentLocation(location);
    }

    public static int getNewRemoteHandle(ModelContext context) {
        return Application.getConnectionManager().createUserInformation(Namespace.getNamespace(context.getNAME_SPACE())).getHandle();
    }

    public static void printWarning(String text, Exception e) {
        logger.warn(text, (Throwable)e);
    }

    public static void GXLocalException(ModelContext context, int handle, String text, SQLException ex) {
        Application.GXLocalException(context, handle, text, (Exception)ex);
    }

    public static void GXLocalException(ModelContext context, int handle, String text, Exception ex) {
        Application.GXLocalException(handle, text, ex);
    }

    public static void GXLocalException(int handle, String text, Exception ex) {
        ApplicationContext.getInstance().getErrorManager().runtimeError(handle, (Throwable)ex, "runtimedb", text, 0);
    }

    public static boolean isRemoteProcedure(ModelContext context, int handle, String location) {
        return !ApplicationContext.getInstance().getCurrentLocation().equals(location) && location.length() > 0;
    }

    public static LocalUtil getClientLocalUtil() {
        return ClientContext.getLocalUtil();
    }

    public static Messages getClientMessages() {
        return ClientContext.getMessages();
    }

    public static String getDBMSUser(ModelContext context, int handle, String dataSource) {
        UserInformation info = Application.getConnectionManager().getUserInformation(handle);
        String dbmsUser = null;
        try {
            dbmsUser = Application.getConnectionManager(context).getUserName(context, handle, dataSource);
        }
        catch (SQLException ex) {
            PrivateUtilities.errorHandler("getDBMSUser()" + ex.getErrorCode() + " SQLState " + ex.getSQLState() + " Statement", ex);
        }
        return dbmsUser;
    }

    public static boolean canConnect(ModelContext context, int remoteHandle, String location) {
        try {
            UserInformation info = Application.getConnectionManager().getUserInformation(remoteHandle);
            Application.getConnectionManager(context).getServerDateTime(context, remoteHandle, "DEFAULT");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Date getServerDateTime(ModelContext context, int handle, String dataSource) {
        UserInformation info = Application.getConnectionManager().getUserInformation(handle);
        Date dateTime = null;
        try {
            dateTime = Application.getConnectionManager(context).getServerDateTime(context, handle, dataSource);
        }
        catch (SQLException ex) {
            PrivateUtilities.errorHandler("getDBMSUser()" + ex.getErrorCode() + " SQLState " + ex.getSQLState() + " Statement", ex);
            dateTime = CommonUtil.resetTime((Date)CommonUtil.nullDate());
        }
        return dateTime;
    }

    public static String getDBMSVersion(ModelContext context, int handle, String dataSource) {
        if (dbmsVersion == null) {
            try {
                dbmsVersion = Application.getConnectionManager(context).getDBMSVersion(context, handle, dataSource);
            }
            catch (SQLException ex) {
                PrivateUtilities.errorHandler("getDBMSVersion()" + ex.getErrorCode() + " SQLState " + ex.getSQLState() + " Statement", ex);
            }
        }
        return dbmsVersion;
    }

    public static String getDatabaseName(ModelContext context, int handle, String dataSource) {
        String databaseName = null;
        try {
            databaseName = Application.getConnectionManager(context).getDatabaseName(context, handle, dataSource);
        }
        catch (SQLException ex) {
            ReorgSubmitThreadPool.setAnError();
            PrivateUtilities.errorHandler("getDatabaseName()" + ex.getErrorCode() + " SQLState " + ex.getSQLState() + " Statement", ex);
        }
        return databaseName;
    }

    private static void executeEvent(ModelContext context, UserInformation info, String objName, String eventName, String dataSourceName) {
        if (dataSourceName.equals("DEFAULT")) {
            String proc = context.getPreferences().getEvent(eventName);
            if (info != null && !proc.equals("")) {
                try {
                    if (!DynamicExecute.dynamicExecute((ModelContext)context, (int)info.getHandle(), (Class)gxCfg, (String)GXutil.getClassName(proc.toLowerCase()), (Object[])new Object[]{objName})) {
                        Application.GXLocalException(context, info.getHandle(), "EventHandling(" + eventName + ")", new RuntimeException(" Can't execute dynamic call " + GXutil.getClassName(proc.toLowerCase())));
                    }
                }
                catch (Exception e) {
                    System.err.println("Event" + eventName + " -> " + e.toString());
                    Application.GXLocalException(context, info.getHandle(), "EventHandling(" + eventName + ")", e);
                }
            }
        }
    }

    public static void commit(ModelContext context, int remoteHandle, String dataSourceName, IDataStoreProvider dataStore) {
        Application.commit(context, remoteHandle, dataSourceName, dataStore, UNKNOWN_CALLER);
    }

    public static void commit(ModelContext context, int remoteHandle, String objName) {
        Application.commitDataStores(context, remoteHandle, null, objName);
    }

    public static void commitDataStores(ModelContext context, int remoteHandle, IDataStoreProvider dataStore, String objName) {
        UserInformation info = Application.getConnectionManager().getUserInformation(remoteHandle);
        Enumeration<DataSource> en = info.getNamespace().getDataSources();
        while (en.hasMoreElements()) {
            String dataSourceName = en.nextElement().getName();
            Application.commit(context, remoteHandle, dataSourceName, dataStore, objName);
        }
    }

    public static void commit(ModelContext context, int remoteHandle, String dataSourceName, IDataStoreProvider dataStore, String objName) {
        boolean doCommit = true;
        if (context.getSessionContext() != null) {
            try {
                InitialContext initCtx = new InitialContext();
                String trnType = (String)initCtx.lookup("java:comp/env/GX/TrnType");
                if (trnType.equals("CONTAINER")) {
                    doCommit = false;
                }
            }
            catch (NamingException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        if (usingQueue) {
            GXQueue.commitAll();
        }
        if (doCommit) {
            UserInformation info = Application.getConnectionManager().getUserInformation(remoteHandle);
            if (!context.inBeforeCommit) {
                context.inBeforeCommit = true;
                Application.executeEvent(context, info, objName, "before_commit", dataSourceName);
                context.inBeforeCommit = false;
            }
            try {
                if (dataStore != null && !context.inErrorHandler) {
                    dataStore.commit(dataSourceName);
                } else {
                    Application.getConnectionManager(context).commit(context, remoteHandle, dataSourceName);
                }
                if (!context.inAfterCommit) {
                    context.inAfterCommit = true;
                    Application.executeEvent(context, info, objName, "after_commit", dataSourceName);
                    context.inAfterCommit = false;
                }
            }
            catch (SQLException e) {
                Application.GXLocalException(context, remoteHandle, "Application.commit", e);
            }
        }
        if (useSmartCache && !ApplicationContext.getInstance().getReorganization()) {
            Application.getSmartCacheProvider(remoteHandle).recordUpdates();
        }
    }

    public static void rollback(ModelContext context, int remoteHandle, String dataSourceName, IDataStoreProvider dataStore) {
        Application.rollback(context, remoteHandle, dataSourceName, dataStore, UNKNOWN_CALLER);
    }

    public static void rollbackDataStores(ModelContext context, int remoteHandle, IDataStoreProvider dataStore, String objName) {
        UserInformation info = Application.getConnectionManager().getUserInformation(remoteHandle);
        Enumeration<DataSource> en = info.getNamespace().getDataSources();
        while (en.hasMoreElements()) {
            String dataSourceName = en.nextElement().getName();
            Application.rollback(context, remoteHandle, dataSourceName, dataStore, objName);
        }
    }

    public static void rollback(ModelContext context, int remoteHandle, String dataSourceName, IDataStoreProvider dataStore, String objName) {
        UserInformation info;
        boolean doRollback = true;
        if (context.getSessionContext() != null) {
            try {
                InitialContext initCtx = new InitialContext();
                String trnType = (String)initCtx.lookup("java:comp/env/GX/TrnType");
                if (trnType.equals("CONTAINER")) {
                    doRollback = false;
                }
            }
            catch (NamingException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        if (usingQueue) {
            GXQueue.rollbackAll();
        }
        if (doRollback) {
            info = Application.getConnectionManager().getUserInformation(remoteHandle);
            if (!context.inBeforeRollback) {
                context.inBeforeRollback = true;
                Application.executeEvent(context, info, objName, "before_rollback", dataSourceName);
                context.inBeforeRollback = false;
            }
            try {
                if (dataStore != null && !context.inErrorHandler) {
                    dataStore.rollback(dataSourceName);
                } else {
                    Application.getConnectionManager(context).rollback(context, remoteHandle, dataSourceName);
                }
                if (!context.inAfterRollback) {
                    context.inAfterRollback = true;
                    Application.executeEvent(context, info, objName, "after_rollback", dataSourceName);
                    context.inAfterRollback = false;
                }
            }
            catch (SQLException e) {
                Application.GXLocalException(context, remoteHandle, "Application.commit", e);
            }
        } else {
            info = Application.getConnectionManager().getUserInformation(remoteHandle);
            if (!context.inBeforeRollback) {
                context.inBeforeRollback = true;
                Application.executeEvent(context, info, objName, "before_rollback", dataSourceName);
                context.inBeforeRollback = false;
            }
            ((IGxEjbContext)context.getSessionContext()).setRollback();
            if (!context.inAfterRollback) {
                context.inAfterRollback = true;
                Application.executeEvent(context, info, objName, "after_rollback", dataSourceName);
                context.inAfterRollback = false;
            }
        }
        if (useSmartCache) {
            Application.getSmartCacheProvider(remoteHandle).discardUpdates();
        }
    }

    public static void setContextClassName(Class Name2) {
        ClassName = Name2;
    }

    public static Class getContextClassName() {
        return ClassName;
    }

    public static boolean isJMXEnabled() {
        if (isJMXEnabled == null) {
            if (!initialized) {
                return false;
            }
            Preferences preferences = (Preferences)ClientContext.getModelContext().getPreferences();
            isJMXEnabled = !preferences.getProperty("ENABLE_MANAGEMENT", "0").equals("0") ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return isJMXEnabled;
    }

    public static void setShowConnectError(boolean showConnError) {
        showConnectError = showConnError;
    }

    public static boolean getShowConnectError() {
        return showConnectError;
    }

    public static GXSmartCacheProvider getSmartCacheProvider(int handle) {
        useSmartCache = true;
        return Application.getConnectionManager().getUserInformation(handle).getSmartCacheProvider();
    }

    static {
        Connect.init();
        logger = LogManager.getLogger(Application.class);
        usingQueue = false;
        nullObject = new Object();
        gxCfg = ApplicationContext.getInstance().getClass();
        toCleanup = new Vector();
        ClassName = null;
        externalProvider = null;
        externalProviderAPI = null;
        objectLock = new Object();
        initialized = false;
        showConnectError = true;
        executingGeneratorTool = false;
        useSmartCache = false;
    }
}

