/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.Application;
import com.genexus.ApplicationContext;
import com.genexus.ICacheService;
import com.genexus.Preferences;
import com.genexus.db.CacheValue;
import com.genexus.db.InProcessCache;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.util.GXService;

public class CacheFactory {
    public static final ILogger logger = LogManager.getLogger(CacheFactory.class);
    private static volatile ICacheService instance;
    private static Object syncRoot;
    private static boolean forceHighestTimetoLive;
    public static String FORCE_HIGHEST_TIME_TO_LIVE;
    public static String CACHE_SD;
    public static String CACHE_DB;
    public static String CACHE_FL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICacheService getInstance() {
        if (instance == null) {
            Object object = syncRoot;
            synchronized (object) {
                if (instance == null) {
                    GXService providerService = Application.getGXServices().get("Cache");
                    if (providerService != null) {
                        String warnMsg = "Couldn't create CACHE_PROVIDER as ICacheService: " + providerService.getClassName();
                        try {
                            logger.info("Loading providerService:" + providerService.getClassName());
                            Class<?> type = Class.forName(providerService.getClassName());
                            if (type != null) {
                                ICacheService cacheInstance = (ICacheService)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                if (cacheInstance != null) {
                                    instance = cacheInstance;
                                    if (providerService.getProperties().containsKey(FORCE_HIGHEST_TIME_TO_LIVE) && Integer.parseInt(providerService.getProperties().get(FORCE_HIGHEST_TIME_TO_LIVE)) == 1) {
                                        forceHighestTimetoLive = true;
                                    }
                                } else {
                                    logger.error(warnMsg);
                                    System.err.println(warnMsg);
                                }
                            }
                        }
                        catch (Exception ex) {
                            logger.error(warnMsg, (Throwable)ex);
                            System.err.println(warnMsg);
                            ex.printStackTrace();
                        }
                    }
                    if (instance == null) {
                        instance = new InProcessCache();
                    }
                    CacheFactory.LoadTTLFromPreferences();
                }
            }
        }
        return instance;
    }

    private static void LoadTTLFromPreferences() {
        Preferences prefs = Preferences.getDefaultPreferences();
        for (int i = 0; i < 4; ++i) {
            Preferences.TTL[i] = prefs.getCACHE_TTL(i, -1);
            if (Preferences.TTL[i] != -1) {
                int n = i;
                Preferences.TTL[n] = Preferences.TTL[n] * 60;
            }
            Preferences.HTL[i] = prefs.getCACHE_HTL(i, 0);
        }
    }

    public static CacheValue createCacheValue(String key, Object[] parms, int cacheableLevel) {
        if (Preferences.TTL[cacheableLevel] <= -1) {
            return null;
        }
        CacheValue cacheValue = new CacheValue(key, parms);
        cacheValue.setExpiryTime(Preferences.TTL[cacheableLevel]);
        cacheValue.setExpiryHits(Preferences.HTL[cacheableLevel]);
        return cacheValue;
    }

    public static void restartCache() {
        if (instance != null) {
            logger.debug("Restarting cache...");
            instance.clearAllCaches();
        }
    }

    public static boolean getForceHighestTimetoLive() {
        if (!ApplicationContext.getInstance().getReorganization() && CacheFactory.getInstance() != null) {
            return forceHighestTimetoLive;
        }
        return false;
    }

    static {
        syncRoot = new Object();
        forceHighestTimetoLive = false;
        FORCE_HIGHEST_TIME_TO_LIVE = "FORCE_HIGHEST_TIME_TO_LIVE";
        CACHE_SD = "SD";
        CACHE_DB = "DB";
        CACHE_FL = "FL";
    }
}

