/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.Application;
import com.genexus.ApplicationContext;
import com.genexus.CommonUtil;
import com.genexus.HTMLDocType;
import com.genexus.Preferences;
import com.genexus.PrivateUtilities;
import com.genexus.common.interfaces.IClientPreferences;
import com.genexus.util.IniFile;
import java.io.File;
import java.util.Hashtable;

public final class ClientPreferences
extends Preferences
implements IClientPreferences {
    public static final byte CHANGE_NEVER = 0;
    public static final byte CHANGE_ALWAYS = 1;
    public static final byte FIELD_EXIT_TAB = 0;
    public static final byte FIELD_EXIT_ENTER = 1;
    public static final byte FIELD_EXIT_ADD = 2;
    public static final byte FIELD_EXIT_LAST_CHAR = 3;
    public static final byte FIELD_EXIT_TAB_ENTER = 4;
    public static final byte LF_NATIVE = 0;
    public static final byte LF_CROSSPLATFORM = 1;
    public static final byte PREFERRED_UI_BEST = 0;
    public static final byte PREFERRED_UI_AWT = 1;
    public static final byte PREFERRED_UI_JFC = 2;
    public static final byte PREFERRED_UI_WFC = 3;
    public static final byte PREFERRED_UI_SWT = 4;
    public static final byte ESCAPE_EXIT_NONE = 0;
    public static final byte ESCAPE_EXIT_FORM = 1;
    public Boolean CS_REORGJAVA;
    private Byte YEAR_LIMIT;
    private String GXDB_LOCATION;
    public Boolean CS_CONNECT;
    public String LANGUAGE;
    private Character DECIMAL_POINT;
    public String DATE_FMT;
    public String TIME_FMT;
    public Byte REMOTE_CALLS;
    private Byte IMAGE_SUBST;
    private Byte FIELD_EXIT;
    private Boolean FIELD_EXIT_GRID;
    private Boolean SDI_CLOSING_FIX;
    private Integer KEY_REFRESH;
    private Boolean MDI_FORMS;
    private Integer KEY_PROMPT;
    private Byte JFC_LF;
    private Byte MODEL_NUM;
    private String PREFERRED_UI;
    private Boolean SUBFILE_ORDER;
    private Byte ESCAPE_FUNCTION;
    private Boolean FC_READONLY;
    private HTMLDocType docType = HTMLDocType.UNDEFINED;
    private static Integer HTTP_BUFFER_SIZE = -1;
    private static ClientPreferences instance;
    private static Hashtable<String, ClientPreferences> preferences;
    static Integer storageTimezone;
    public static final int StorageTimeZonePty_Undefined = 0;
    public static final int StorageTimeZonePty_Utc = 1;
    public static final int StorageTimeZonePty_Local = 2;

    public ClientPreferences(IniFile iniFile) {
        super(iniFile, "Client");
    }

    private ClientPreferences(Class resourceClass, String name) {
        super(resourceClass, name, "Client");
    }

    public static void resetPreferences() {
        preferences = new Hashtable();
    }

    public static ClientPreferences getInstance(Class resourceClass) {
        String packageName = PrivateUtilities.getPackageName(resourceClass);
        ClientPreferences ret = preferences.get(packageName);
        if (ret == null) {
            ret = new ClientPreferences(resourceClass, ApplicationContext.getInstance().getReorganization() ? "reorg.cfg" : "client.cfg");
            preferences.put(packageName, ret);
        }
        return ret;
    }

    public static void endClientPreferences() {
        preferences = null;
    }

    public int getMODEL_NUM() {
        return (int)CommonUtil.val((String)this.getProperty("MODEL_NUM"));
    }

    public int getGENERATOR_NUM() {
        return (int)CommonUtil.val((String)this.getProperty("GENERATOR_NUM", "11"));
    }

    public boolean getODBC_CALLS() {
        return this.getProperty("ODBC_CALLS").equals("1");
    }

    public boolean getUSE_JNDI() {
        return this.getProperty("USE_JNDI", "0").equals("1");
    }

    public boolean getSHOW_STATUS() {
        if (ApplicationContext.getInstance().isGXUtility() || ApplicationContext.getInstance().isDeveloperMenu()) {
            return true;
        }
        return this.getProperty("SHOW_STATUS", "1").equals("1");
    }

    public byte getJFC_LF() {
        if (this.JFC_LF == null) {
            String prop = this.getProperty("JFC_LF", "N").toUpperCase();
            this.JFC_LF = prop.substring(0, 1).equals("N") ? new Byte(0) : new Byte(1);
        }
        return this.JFC_LF;
    }

    public String getPACKAGE() {
        return this.getProperty("PACKAGE");
    }

    public boolean getFC_READONLY() {
        if (this.FC_READONLY == null) {
            this.FC_READONLY = new Boolean(this.getProperty("FC_READONLY", "ORIGINAL").equalsIgnoreCase("ORIGINAL"));
        }
        return this.FC_READONLY;
    }

    public boolean getMDI_FORMS() {
        if (Application.executingGeneratorTool) {
            return false;
        }
        return this.booleanPreference(this.MDI_FORMS, "MDI_FORMS", "0");
    }

    public boolean getSUBFILE_ORDER() {
        if (this.SUBFILE_ORDER == null) {
            this.SUBFILE_ORDER = new Boolean(this.getProperty("SUBFILE_ORDER", "Y").equalsIgnoreCase("Y"));
        }
        return this.SUBFILE_ORDER;
    }

    public byte getPREFERRED_UI() {
        if (this.PREFERRED_UI == null) {
            this.PREFERRED_UI = this.getProperty("PREFERRED_UI", "BEST").toUpperCase();
        }
        if (this.PREFERRED_UI.substring(0, 1).equals("A")) {
            return 1;
        }
        if (this.PREFERRED_UI.substring(0, 1).equals("J")) {
            return 2;
        }
        if (this.PREFERRED_UI.substring(0, 1).equals("W")) {
            return 3;
        }
        if (this.PREFERRED_UI.substring(0, 1).equals("S")) {
            return 4;
        }
        return 0;
    }

    public byte getIMAGE_SUBST() {
        if (this.IMAGE_SUBST == null) {
            this.IMAGE_SUBST = new Byte((byte)CommonUtil.val((String)this.getProperty("IMAGE_SUBST", "1")));
        }
        return this.IMAGE_SUBST;
    }

    public byte getFIELD_EXIT() {
        if (this.FIELD_EXIT == null) {
            String aux = this.getProperty("FIELD_EXIT", "TAB").toUpperCase();
            this.FIELD_EXIT = aux.equals("TAB") ? new Byte(0) : (aux.equals("ENTER") ? new Byte(1) : (aux.equals("LAST_CHAR") ? new Byte(3) : (aux.equals("TABENTER") ? new Byte(4) : new Byte(2))));
        }
        return this.FIELD_EXIT;
    }

    public boolean getFIELD_EXIT_GRID() {
        if (this.FIELD_EXIT_GRID == null) {
            this.FIELD_EXIT_GRID = new Boolean(this.getProperty("FIELD_EXIT_GRID", "").toUpperCase().equals("FOXPRO"));
        }
        return this.FIELD_EXIT_GRID;
    }

    public boolean getSDI_CLOSING_FIX() {
        if (this.SDI_CLOSING_FIX == null) {
            this.SDI_CLOSING_FIX = new Boolean(this.getProperty("SDI_CLOSING_FIX", "N").equalsIgnoreCase("Y"));
        }
        return this.SDI_CLOSING_FIX;
    }

    public byte getESCAPE_FUNCTION() {
        if (this.ESCAPE_FUNCTION == null) {
            String aux = this.getProperty("ESCAPE_FUNCTION", "Exit_form");
            if (aux.equals("None")) {
                this.ESCAPE_FUNCTION = new Byte(0);
            } else if (aux.equals("Exit_form")) {
                this.ESCAPE_FUNCTION = new Byte(1);
            }
        }
        return this.ESCAPE_FUNCTION;
    }

    public char getDECIMAL_POINT() {
        if (this.DECIMAL_POINT == null) {
            this.DECIMAL_POINT = ApplicationContext.getInstance().isGXUtility() ? new Character(this.getProperty("DECIMAL_POINT", ".").charAt(0)) : new Character(this.getProperty("DECIMAL_POINT").charAt(0));
        }
        return this.DECIMAL_POINT.charValue();
    }

    public byte getYEAR_LIMIT() {
        if (ApplicationContext.getInstance().isGXUtility()) {
            return this.bytePreference(this.YEAR_LIMIT, "YEAR_LIMIT", "40");
        }
        return this.bytePreference(this.YEAR_LIMIT, "YEAR_LIMIT");
    }

    public boolean getConnectFirstRequest() {
        if (this.CS_CONNECT == null) {
            String value = this.getProperty("CS_CONNECT");
            this.CS_CONNECT = new Boolean(value.equalsIgnoreCase("FIRST"));
        }
        return this.CS_CONNECT;
    }

    public boolean getCS_REORGJAVA() {
        return this.booleanPreference(this.CS_REORGJAVA, "CS_REORG");
    }

    public String getModelLANGUAGE() {
        return this.getProperty("LANGUAGE");
    }

    public String getHELP_BASEURL() {
        return PrivateUtilities.addLastChar(this.getProperty("HELP_BASEURL", ""), "/");
    }

    public String getHELP_MODE() {
        return this.getProperty("HELP_MODE", "WINHTML");
    }

    public String getLANGUAGE() {
        if (ApplicationContext.getInstance().isGXUtility()) {
            return this.getProperty("LANGUAGE", "eng");
        }
        return this.getProperty("LANGUAGE");
    }

    public String getTIME_FMT() {
        if (ApplicationContext.getInstance().isGXUtility()) {
            return this.getProperty("TIME_FMT", "");
        }
        String prop = this.getProperty("TIME_FMT");
        if (prop.equals("default")) {
            return "";
        }
        return prop;
    }

    public String getDATE_FMT() {
        if (ApplicationContext.getInstance().isGXUtility()) {
            return this.getProperty("DATE_FMT", "");
        }
        return this.getProperty("DATE_FMT").toLowerCase();
    }

    public boolean getBLANK_EMPTY_DATE() {
        return this.iniFile.getProperty(this.defaultSection, "BLANK_EMPTY_DATE", "0").equals("1");
    }

    public String getBUILD_NUMBER(int buildN) {
        String buildNumber = this.iniFile.getProperty(this.defaultSection, "GX_BUILD_NUMBER", Integer.toString(buildN));
        buildNumber = Integer.toString(Math.max(buildN, Integer.parseInt(buildNumber)));
        return buildNumber;
    }

    public String getGXDB_LOCATION() {
        return this.getIniFile().getProperty(this.getNAME_SPACE(), "GXDB_LOCATION", "");
    }

    public boolean getCOMPRESS_HTML() {
        return this.iniFile.getProperty(this.defaultSection, "COMPRESS_HTML", "1").equals("1");
    }

    public String getIE_COMPATIBILITY() {
        return this.iniFile.getProperty(this.defaultSection, "IE_COMPATIBILITY_VIEW", "edge");
    }

    public String getWEB_IMAGE_DIR() {
        String dir = this.iniFile.getProperty(this.defaultSection, "WEB_IMAGE_DIR", "");
        if (!(dir.endsWith("/") || dir.endsWith("\\") || dir.equals(""))) {
            return dir + "/";
        }
        return dir;
    }

    public boolean useTimezoneFix() {
        return this.getStorageTimezonePty() != 0;
    }

    public int getStorageTimezonePty() {
        if (storageTimezone != null) {
            return storageTimezone;
        }
        String sOffset = this.iniFile.getProperty(this.defaultSection, "StorageTimeZone", "0");
        try {
            storageTimezone = new Integer(Integer.parseInt(sOffset));
        }
        catch (NumberFormatException e) {
            storageTimezone = new Integer(0);
        }
        return storageTimezone;
    }

    public String getWEB_STATIC_DIR() {
        String dir = this.iniFile.getProperty(this.defaultSection, "WEB_STATIC_DIR", "");
        if (!(dir.endsWith("/") || dir.endsWith("\\") || dir.equals(""))) {
            return dir + "/";
        }
        return dir;
    }

    public String getUSE_ENCRYPTION() {
        String key = this.iniFile.getProperty(this.defaultSection, "USE_ENCRYPTION", "");
        return key;
    }

    public String getTMPMEDIA_DIR() {
        String separator;
        String dir = this.iniFile.getProperty(this.defaultSection, "TMPMEDIA_DIR", "");
        if (!dir.endsWith(separator = File.separator) && !dir.equals("")) {
            return dir + separator;
        }
        return dir;
    }

    public String getGOOGLE_API_KEY() {
        String key = this.iniFile.getProperty(this.defaultSection, "GoogleApiKey", "");
        return key;
    }

    public String getPRINT_LAYOUT_METADATA_DIR() {
        String separator;
        String dir = this.iniFile.getProperty(this.defaultSection, "PRINT_LAYOUT_METADATA_DIR", "");
        if (!dir.endsWith(separator = File.separator) && !dir.equals("")) {
            return dir + separator;
        }
        return dir;
    }

    public boolean getUSE_CALENDAR() {
        return this.iniFile.getProperty(this.defaultSection, "CALENDAR", "1").equals("1");
    }

    public boolean getUSE_VB_CALENDAR() {
        return this.iniFile.getProperty(this.defaultSection, "CALENDAR", "1").equals("2");
    }

    public boolean getUSE_CALCULATOR() {
        return this.iniFile.getProperty(this.defaultSection, "CALC", "1").equals("1");
    }

    public String getREORG_TIME_STAMP() {
        return this.getProperty("VER_STAMP");
    }

    public boolean getDOCTYPE_DTD() {
        return this.iniFile.getProperty(this.defaultSection, "DocumentTypeDTD", "1").equals("1");
    }

    public HTMLDocType getDOCTYPE() {
        if (this.docType == HTMLDocType.UNDEFINED) {
            this.docType = HTMLDocType.NONE;
            String value = this.iniFile.getProperty(this.defaultSection, "DocumentType", "");
            if (value.startsWith("XHTML")) {
                this.docType = HTMLDocType.XHTML1;
            } else if (value.startsWith("HTML4S")) {
                this.docType = HTMLDocType.HTML4S;
            } else if (value.startsWith("HTML4")) {
                this.docType = HTMLDocType.HTML4;
            } else if (value.startsWith("HTML5")) {
                this.docType = HTMLDocType.HTML5;
            }
        }
        return this.docType;
    }

    public boolean getJDBC_LOGEnabled() {
        String name = this.iniFile.getProperty(this.defaultSection, "Namespace1");
        return this.iniFile.getProperty(name, "JDBCLogEnabled", "0").equals("1");
    }

    public int getHttpBufferSize() {
        if (HTTP_BUFFER_SIZE >= 0) {
            return HTTP_BUFFER_SIZE;
        }
        HTTP_BUFFER_SIZE = 0;
        String bSizeS = "";
        this.getProperty("HTTP_BUFFER_SIZE", bSizeS);
        if (bSizeS != null && bSizeS.length() > 0) {
            HTTP_BUFFER_SIZE = Integer.parseInt(bSizeS);
        }
        return HTTP_BUFFER_SIZE;
    }

    public String getPDF_RPT_LIBRARY() {
        return this.iniFile.getProperty(this.defaultSection, "PDF_RPT_LIBRARY", "ITEXT");
    }

    static {
        preferences = new Hashtable();
    }
}

