/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.ApplicationContext;
import com.genexus.ClientContext;
import com.genexus.ResourceReader;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.util.IniFile;
import com.genexus.util.IniFileMultiple;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class ConfigFileFinder {
    public static final ILogger logger = LogManager.getLogger(ConfigFileFinder.class);
    private static final String CRYPTO_CFG = "crypto.cfg";
    private static final String PROD_ENV_SUFFIX = ".prod";
    private static final String DEV_ENV_SUFFIX = ".dev";

    public static IniFile getConfigFile(Class resourceClassParm, String fileName, Class defaultResourceClass) {
        IniFileStream iniFileStream = new IniFileStream(resourceClassParm, fileName, defaultResourceClass).invoke();
        InputStream is = iniFileStream.getIs();
        InputStream crypto = iniFileStream.getCrypto();
        IniFileStream configurationOverride = new IniFileStream(resourceClassParm, fileName + DEV_ENV_SUFFIX, defaultResourceClass);
        if (configurationOverride == null || configurationOverride.invoke().getIs() == null) {
            configurationOverride = new IniFileStream(resourceClassParm, fileName + PROD_ENV_SUFFIX, defaultResourceClass);
        }
        IniFileMultiple iniFile = null;
        try {
            iniFile = new IniFileMultiple(is);
            iniFile.addConfigurationSource(configurationOverride.fileName, configurationOverride.invoke().getIs());
        }
        catch (IOException e) {
            String userDir;
            if (ApplicationContext.getInstance().isGXUtility()) {
                iniFile = new IniFile(fileName);
            }
            try {
                userDir = System.getProperty("user.dir") + "\\";
            }
            catch (SecurityException ex) {
                userDir = "";
            }
            String errMessage = "Can't open " + userDir + fileName;
            logger.fatal(errMessage, (Throwable)e);
            throw new InternalError(errMessage + " / " + e.getMessage());
        }
        iniFile.setEncryptionStream(crypto);
        return iniFile;
    }

    private static class IniFileStream {
        private Class resourceClassParm;
        private String fileName;
        private Class defaultResourceClass;
        private InputStream is;
        private InputStream crypto;

        public IniFileStream(Class resourceClassParm, String fileName, Class defaultResourceClass) {
            this.resourceClassParm = resourceClassParm;
            this.fileName = fileName;
            this.defaultResourceClass = defaultResourceClass;
        }

        public InputStream getIs() {
            return this.is;
        }

        public InputStream getCrypto() {
            return this.crypto;
        }

        public IniFileStream invoke() {
            this.is = null;
            this.crypto = null;
            Class resourceClass = this.resourceClassParm;
            if (ClientContext.getModelContext() != null) {
                resourceClass = ClientContext.getModelContext().getPackageClass();
            }
            if (this.is == null && resourceClass != null) {
                this.is = ResourceReader.getResourceAsStream((Class)resourceClass, (String)this.fileName);
                if (this.is != null) {
                    this.crypto = ResourceReader.getResourceAsStream((Class)resourceClass, (String)ConfigFileFinder.CRYPTO_CFG);
                }
            }
            if (this.is == null && this.defaultResourceClass != null) {
                this.is = ResourceReader.getResourceAsStream((Class)this.defaultResourceClass, (String)this.fileName);
                if (this.is != null) {
                    this.crypto = ResourceReader.getResourceAsStream((Class)resourceClass, (String)ConfigFileFinder.CRYPTO_CFG);
                }
            }
            if (this.is == null) {
                try {
                    this.is = new BufferedInputStream(new FileInputStream(this.fileName));
                    if (this.is != null) {
                        this.crypto = new BufferedInputStream(new FileInputStream(ConfigFileFinder.CRYPTO_CFG));
                    }
                }
                catch (FileNotFoundException e) {
                    try {
                        this.is = new BufferedInputStream(new FileInputStream(this.fileName));
                        if (this.is != null) {
                            this.crypto = new BufferedInputStream(new FileInputStream(ConfigFileFinder.CRYPTO_CFG));
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
            }
            if (this.is == null && ApplicationContext.getInstance().isGXUtility()) {
                try {
                    this.is = new FileInputStream(this.fileName);
                    if (this.is != null) {
                        this.crypto = new FileInputStream(this.fileName);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this;
        }
    }
}

