/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.Application;
import com.genexus.CommonUtil;
import com.genexus.IHttpContext;
import com.genexus.ModelContext;
import com.genexus.Preferences;
import com.genexus.PrivateUtilities;
import com.genexus.internet.HttpContext;
import com.genexus.internet.HttpContextNull;
import com.genexus.util.GXFile;
import java.io.File;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GXDbFile {
    private static Pattern schemeRegex = Pattern.compile("(^" + GXDbFile.getScheme() + ":)(.+)");

    public static String getScheme() {
        return "gxdbfile";
    }

    public static String getMultimediaDirectory() {
        return "multimedia";
    }

    public static String getFileName(String uri) {
        try {
            return CommonUtil.getFileName((String)uri);
        }
        catch (Exception e) {
            System.err.println("Bad File URI " + uri + " : " + e.getMessage());
            return uri;
        }
    }

    public static String getFileType(String uri) {
        try {
            return CommonUtil.getFileType((String)uri);
        }
        catch (Exception e) {
            System.err.println("Bad File URI " + uri + " : " + e.getMessage());
            return uri;
        }
    }

    public static String addTokenToFileName(String name, String type) {
        if (name.trim().length() == 0) {
            return "";
        }
        String guid = UUID.randomUUID().toString().replaceAll("-", "");
        return name + "_" + guid + (type.trim().length() == 0 ? "" : ".") + type;
    }

    public static String removeTokenFromFileName(String fileName) {
        Pattern pattern;
        Matcher matcher;
        if (fileName.trim().length() == 0) {
            return "";
        }
        String name = GXDbFile.getFileName(fileName);
        String type = GXDbFile.getFileType(fileName);
        String cleanName = name;
        int sepIdx = name.lastIndexOf(95);
        if (sepIdx > 0 && (matcher = (pattern = Pattern.compile("(_[0-9a-zA-Z]{32})$")).matcher(name.substring(sepIdx))).find()) {
            cleanName = name.substring(0, sepIdx);
        }
        return type.trim().length() == 0 ? cleanName : cleanName + "." + type;
    }

    public static Boolean hasToken(String fileName) {
        File file = new File(fileName);
        return file.getName().compareTo(GXDbFile.removeTokenFromFileName(file.getName())) != 0;
    }

    public static String getFileNameFromUri(String uriString) {
        if (uriString.trim().length() == 0) {
            return "";
        }
        Matcher matcher = schemeRegex.matcher(uriString);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return uriString;
    }

    public static String resolveUri(String uriString) {
        return GXDbFile.resolveUri(uriString, true);
    }

    public static String resolveUri(String uriString, boolean absPath) {
        if (uriString.trim().length() == 0) {
            return "";
        }
        Matcher matcher = schemeRegex.matcher(uriString);
        if (matcher.matches()) {
            String fileName = matcher.group(2);
            String filePath = "";
            if (Application.getGXServices().get("Storage") == null) {
                String multimediaDir = Preferences.getDefaultPreferences().getMultimediaPath();
                filePath = multimediaDir + File.separator + fileName;
            } else {
                filePath = Preferences.getDefaultPreferences().getProperty("CS_BLOB_PATH", "").trim() + "/" + GXDbFile.getMultimediaDirectory() + "/" + fileName;
            }
            GXFile file = new GXFile(filePath);
            return GXDbFile.pathToUrl(file.getAbsolutePath(), absPath);
        }
        return uriString;
    }

    public static String generateUri(String file, Boolean addToken, Boolean addScheme) {
        String name = GXDbFile.getFileName(file);
        String type = GXDbFile.getFileType(file);
        if (file.toLowerCase().startsWith("http://") || file.toLowerCase().startsWith("https://")) {
            name = PrivateUtilities.encodeFileName(name);
        }
        name = PrivateUtilities.checkFileNameLength(file.replace(name, ""), name, type);
        if (!addScheme.booleanValue()) {
            return GXDbFile.addTokenToFileName(name, type);
        }
        if (addToken.booleanValue()) {
            return GXDbFile.getScheme() + ":" + GXDbFile.addTokenToFileName(name, type);
        }
        return GXDbFile.getScheme() + ":" + name + (type.trim().length() == 0 ? "" : ".") + type;
    }

    public static String getNameFromURL(String uri) {
        return GXDbFile.getFileName(uri) + "." + GXDbFile.getFileType(uri);
    }

    public static boolean isFileExternal(String uriString) {
        if (uriString.trim().length() == 0) {
            return true;
        }
        return !schemeRegex.matcher(uriString).matches();
    }

    private static String getUriFromFile(String name, String type) {
        String cleanName = name.trim();
        String cleanType = type.trim();
        return (cleanName.length() == 0 ? "multimedia-file" : cleanName) + "." + (cleanType.length() == 0 ? "tmp" : cleanType);
    }

    public static String getUriFromFile(String name, String type, String path) {
        if (name.length() == 0 && type.length() == 0 && path.length() != 0) {
            if (CommonUtil.isUploadPrefix((String)path)) {
                return new GXFile(path).getName();
            }
            String fromPathType = GXDbFile.getFileType(path);
            if (fromPathType.length() != 0 && !fromPathType.equals("tmp")) {
                return new File(path).getName();
            }
        }
        return GXDbFile.getUriFromFile(name, type);
    }

    public static String getUrlFromUri(String blob, String uri) {
        return blob.trim().length() == 0 ? uri : "";
    }

    public static String pathToUrl(String path, IHttpContext webContext) {
        return GXDbFile.pathToUrl(path, webContext, true);
    }

    public static String pathToUrl(String path, IHttpContext webContext, boolean forceAbsPath) {
        if (path.startsWith("http:") || path.startsWith("https:") || path.startsWith("data:")) {
            return path;
        }
        if (webContext instanceof HttpContextNull) {
            try {
                File file = new File(path);
                return file.toURI().toURL().toString();
            }
            catch (Exception exception) {
                return path;
            }
        }
        if (forceAbsPath) {
            return ((HttpContext)webContext).getResource(webContext.convertURL(path));
        }
        return ((HttpContext)webContext).getResourceRelative(webContext.convertURL(path), false);
    }

    public static String pathToUrl(String path) {
        return GXDbFile.pathToUrl(path, true);
    }

    public static String pathToUrl(String path, boolean forceAbsPath) {
        ModelContext context = ModelContext.getModelContext();
        HttpContext webContext = (HttpContext)context.getHttpContext();
        return GXDbFile.pathToUrl(path, webContext, forceAbsPath);
    }
}

