/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.Application;
import com.genexus.ApplicationContext;
import com.genexus.CommonUtil;
import com.genexus.DefaultErrorHandler;
import com.genexus.GXObjectHelper;
import com.genexus.GXRestServiceWrapper;
import com.genexus.GXWebReport;
import com.genexus.GXutil;
import com.genexus.IErrorHandler;
import com.genexus.IHttpContext;
import com.genexus.ISubmitteable;
import com.genexus.LocalUtil;
import com.genexus.ModelContext;
import com.genexus.URLRouter;
import com.genexus.db.Namespace;
import com.genexus.db.UserInformation;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.internet.HttpContext;
import com.genexus.util.SubmitThreadPool;
import com.genexus.webpanels.HttpContextWeb;
import com.genexus.webpanels.WebApplicationStartup;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;

public abstract class GXObjectBase
extends GXRestServiceWrapper
implements IErrorHandler,
ISubmitteable {
    public static final ILogger logger = LogManager.getLogger(GXObjectBase.class);
    protected ModelContext context;
    protected HttpContext httpContext;
    protected LocalUtil localUtil;
    protected int remoteHandle = -1;
    protected UserInformation ui;
    protected static final int SECURITY_GXOBJECT = 3;
    protected static final int SECURITY_HIGH = 2;
    protected static final int SECURITY_LOW = 1;

    public abstract void webExecute();

    public GXObjectBase() {
    }

    public GXObjectBase(HttpContext httpContext) {
        this.init(httpContext, ((Object)((Object)this)).getClass());
    }

    public GXObjectBase(int remoteHandle, ModelContext context) {
        this.context = context;
        this.ui = (UserInformation)GXObjectHelper.getUserInformation((ModelContext)context, (int)remoteHandle);
        this.remoteHandle = this.ui.getHandle();
        this.initState(context, this.ui);
    }

    protected void init(HttpContext httpContext, Class contextClass) {
        this.context = new ModelContext(contextClass);
        this.context.setHttpContext((IHttpContext)httpContext);
        new WebApplicationStartup();
        WebApplicationStartup.init(contextClass, httpContext);
        ApplicationContext.getInstance().setPoolConnections(!Namespace.createNamespace(this.context).isRemoteGXDB());
        this.ui = (UserInformation)GXObjectHelper.getUserInformation((ModelContext)this.context, (int)-1);
        this.ui.setAutoDisconnect(false);
        this.remoteHandle = this.ui.getHandle();
        this.initState(this.context, this.ui);
    }

    protected void initState(ModelContext context, UserInformation ui) {
        this.localUtil = ui.getLocalUtil();
        this.httpContext = (HttpContext)context.getHttpContext();
        this.httpContext.setContext(context);
        this.httpContext.setCompression(this.getCompressionMode());
    }

    protected boolean getCompressionMode() {
        return this.context.getClientPreferences().getCOMPRESS_HTML();
    }

    public int setLanguage(String language) {
        int res = GXutil.setLanguage(language, this.context, this.ui);
        this.localUtil = this.ui.getLocalUtil();
        return res;
    }

    public int setTheme(String theme) {
        int res = GXutil.setTheme(theme, this.context);
        return res;
    }

    public void doExecute() throws Exception {
        try {
            this.preExecute();
            this.sendCacheHeaders();
            this.webExecute();
            this.httpContext.flushStream();
        }
        catch (Throwable e) {
            this.cleanup();
            throw e;
        }
        finally {
            this.finallyCleanup();
        }
    }

    protected void preExecute() {
        this.httpContext.responseContentType("text/html");
        this.httpContext.initClientId();
    }

    protected void sendCacheHeaders() {
        this.httpContext.getResponse().addDateHeader("Expires", 0L);
        this.httpContext.getResponse().addDateHeader("Last-Modified", 0L);
        if (this instanceof GXWebReport && ((GXWebReport)this).getOutputType() == 2) {
            this.httpContext.getResponse().addHeader("Cache-Control", "must-revalidate,post-check=0, pre-check=0");
        } else {
            this.httpContext.getResponse().addHeader("Cache-Control", "max-age=0, no-cache, no-store, must-revalidate");
        }
    }

    protected void finallyCleanup() {
        try {
            if (this.ui != null) {
                this.ui.disconnect();
            }
        }
        catch (SQLException e) {
            logger.error("Exception while disconecting ", (Throwable)e);
        }
        if (this.httpContext != null) {
            this.httpContext.cleanup();
        }
        this.cleanModelContext();
    }

    private void cleanModelContext() {
        try {
            ((ThreadLocal)CommonUtil.threadCalendar).getClass().getMethod("remove", new Class[0]).invoke((Object)CommonUtil.threadCalendar, (Object[])new Class[0]);
            ((ThreadLocal)ModelContext.threadModelContext).getClass().getMethod("remove", new Class[0]).invoke((Object)ModelContext.threadModelContext, (Object[])new Class[0]);
        }
        catch (NoSuchMethodException e) {
            logger.error("cleanModelContext", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("cleanModelContext", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error("cleanModelContext " + e.getTargetException(), (Throwable)e);
        }
    }

    protected void cleanup() {
        Application.cleanupConnection(this.remoteHandle);
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = (HttpContextWeb)httpContext;
    }

    public ModelContext getModelContext() {
        return this.context;
    }

    public int getRemoteHandle() {
        return this.remoteHandle;
    }

    public ModelContext getContext() {
        return this.context;
    }

    public void handleError() {
        new DefaultErrorHandler().handleError(this.context, this.remoteHandle);
    }

    public Object getParm(Object[] parms, int index) {
        return parms[index];
    }

    protected String formatLink(String jumpURL) {
        return this.formatLink(jumpURL, new String[0]);
    }

    protected String formatLink(String jumpURL, String[] parms) {
        return this.formatLink(jumpURL, parms, new String[0]);
    }

    protected String formatLink(String jumpURL, String[] parms, String[] parmsName) {
        return URLRouter.getURLRoute((String)jumpURL, (String[])parms, (String[])parmsName, (String)this.httpContext.getRequest().getContextPath(), (String)this.context.getPackageName());
    }

    public void callSubmit(int id, Object[] submitParms) {
        SubmitThreadPool.submit(this, id, submitParms, this.context.submitCopy());
    }

    public void submit(int id, Object[] submitParms, ModelContext ctx) {
    }

    public void submit(int id, Object[] submitParms) {
    }

    public void submitReorg(int id, Object[] submitParms) throws SQLException {
    }
}

