/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.Application;
import com.genexus.ApplicationContext;
import com.genexus.ClientPreferences;
import com.genexus.DefaultErrorHandler;
import com.genexus.GXReorganization;
import com.genexus.GXutil;
import com.genexus.IErrorHandler;
import com.genexus.ISubmitteable;
import com.genexus.LocalUtil;
import com.genexus.ModelContext;
import com.genexus.Preferences;
import com.genexus.ServerPreferences;
import com.genexus.URLRouter;
import com.genexus.db.Namespace;
import com.genexus.db.UserInformation;
import com.genexus.diagnostics.GXDebugInfo;
import com.genexus.diagnostics.GXDebugManager;
import com.genexus.internet.HttpContext;
import com.genexus.performance.ProcedureInfo;
import com.genexus.performance.ProceduresInfo;
import com.genexus.util.ReorgSubmitThreadPool;
import com.genexus.util.SubmitThreadPool;
import java.sql.SQLException;
import java.util.Date;

public abstract class GXProcedure
implements IErrorHandler,
ISubmitteable {
    protected transient int remoteHandle;
    public transient ModelContext context;
    protected transient LocalUtil localUtil;
    protected transient String location = "";
    protected HttpContext httpContext;
    protected boolean isRemote;
    protected boolean disconnectUserAtCleanup = false;
    protected boolean ejbMessageCall = false;
    UserInformation ui = null;
    private Date beginExecute = new Date();
    public static final int IN_NEW_UTL = -2;
    private GXDebugInfo dbgInfo = null;

    public abstract void initialize();

    public GXProcedure(int remoteHandle, ModelContext context, String location) {
        this(false, remoteHandle, context, location);
    }

    public GXProcedure(boolean inNewUTL, int remoteHandle, ModelContext context, String location) {
        ProcedureInfo pInfo = ProceduresInfo.addProcedureInfo(this.getClass().getName());
        pInfo.incCount();
        this.remoteHandle = remoteHandle;
        this.context = context;
        this.location = location;
        int parentHandle = remoteHandle;
        if (inNewUTL) {
            remoteHandle = -2;
        }
        if (context != null && context.getSessionContext() != null) {
            ApplicationContext.getInstance().setEJB(true);
            ApplicationContext.getInstance().setPoolConnections(true);
        }
        switch (remoteHandle) {
            case -1: {
                this.ui = Application.getConnectionManager().createUserInformation(Namespace.getNamespace(context.getNAME_SPACE()));
                this.remoteHandle = this.ui.getHandle();
                ApplicationContext.getInstance().setMsgsToUI(false);
                this.ui.setAutoDisconnect(true);
                break;
            }
            case -2: {
                Preferences specificPrefs;
                if (context.prefs == null && ApplicationContext.getInstance().isApplicationServer()) {
                    if (parentHandle == -2) {
                        context.prefs = ClientPreferences.getInstance(context.packageClass);
                    } else {
                        context.prefs = ServerPreferences.getInstance(context.packageClass);
                        specificPrefs = (Preferences)context.getPreferences();
                        specificPrefs.iniFile.setProperty(specificPrefs.defaultSection, "NAME_SPACE", Application.getConnectionManager().getUserInformation(parentHandle).getNamespace().getName());
                    }
                }
                if (ApplicationContext.getInstance().isApplicationServer() && context.prefs.getProperty("NAME_SPACE", "").equals("")) {
                    specificPrefs = (Preferences)context.getPreferences();
                    specificPrefs.iniFile.setProperty(specificPrefs.defaultSection, "NAME_SPACE", Application.getConnectionManager().getUserInformation(parentHandle).getNamespace().getName());
                }
                this.ui = Application.getConnectionManager().createUserInformation(Namespace.getNamespace(context.getNAME_SPACE()));
                this.remoteHandle = this.ui.getHandle();
                this.disconnectUserAtCleanup = true;
                break;
            }
            default: {
                this.ui = Application.getConnectionManager().getUserInformation(remoteHandle);
            }
        }
        this.localUtil = this.ui.getLocalUtil();
        if (context != null) {
            this.httpContext = (HttpContext)context.getHttpContext();
            this.httpContext.initClientId();
        }
    }

    public Object me() {
        return this;
    }

    public void handleError() {
        new DefaultErrorHandler().handleError(this.context, this.remoteHandle);
    }

    public int getHandle() {
        return this.remoteHandle;
    }

    public ModelContext getContext() {
        return this.context;
    }

    protected boolean isRemoteProcedure() {
        return Application.isRemoteProcedure(this.context, this.remoteHandle, this.location);
    }

    protected boolean batchCursorHolder() {
        return false;
    }

    protected void exitApp() {
        this.exitApplication(this.batchCursorHolder());
    }

    protected void exitApplication() {
        this.exitApplication(true);
    }

    private void exitApplication(boolean flushBuffers) {
        if (this.dbgInfo != null && Application.realMainProgram == this) {
            this.dbgInfo.onExit();
        }
        if (flushBuffers) {
            try {
                Application.getConnectionManager().flushBuffers(this.remoteHandle, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.disconnectUserAtCleanup) {
            try {
                Application.getConnectionManager().disconnect(this.remoteHandle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Application.cleanup(this.context, this, this.remoteHandle);
    }

    public void endExecute(String name) {
        ProcedureInfo pInfo = ProceduresInfo.getProcedureInfo(name);
        pInfo.setTimeExecute(System.currentTimeMillis() - this.beginExecute.getTime());
        if (this.context != null && this.context.getSessionContext() != null) {
            ApplicationContext.getInstance().setEJB(false);
            ApplicationContext.getInstance().setPoolConnections(false);
        }
    }

    public void release() {
    }

    protected String formatLink(String jumpURL) {
        return this.formatLink(jumpURL, new String[0], new String[0]);
    }

    protected String formatLink(String jumpURL, String[] parms, String[] parmsName) {
        String contextPath = this.httpContext.getRequest() == null ? "" : this.httpContext.getRequest().getContextPath();
        return URLRouter.getURLRoute((String)jumpURL, (String[])parms, (String[])parmsName, (String)contextPath, (String)this.context.getPackageName());
    }

    public void callSubmit(int id, Object[] submitParms) {
        SubmitThreadPool.submit(this, id, submitParms, this.context.submitCopy());
    }

    public void callSubmit(String blockName, String message, int id, Object[] submitParms) {
        ReorgSubmitThreadPool.submitReorg((String)blockName, (String)message, (ISubmitteable)this, (int)id);
    }

    public void submit(int id, Object[] submitParms, ModelContext ctx) {
    }

    public void submit(int id, Object[] submitParms) {
    }

    public void submitReorg(int id, Object[] submitParms) throws SQLException {
    }

    public void setejbMessageCall() {
        this.ejbMessageCall = true;
    }

    public void SetCreateDataBase() {
        GXReorganization.setCreateDataBase();
    }

    public int setLanguage(String language) {
        int res = GXutil.setLanguage(language, this.context, this.ui);
        this.localUtil = this.ui.getLocalUtil();
        return res;
    }

    protected void callWebObject(String url) {
        this.httpContext.wjLoc = url;
    }

    protected void cleanup() {
    }

    public void handleException(String gxExceptionType, String gxExceptionDetails, String gxExceptionStack) {
    }

    protected void trkCleanup() {
        if (this.dbgInfo != null) {
            this.dbgInfo.onCleanup();
        }
    }

    protected void initialize(int objClass, int objId, int dbgLines, long hash) {
        this.dbgInfo = GXDebugManager.getInstance().getDbgInfo(this.context, objClass, objId, dbgLines, hash);
    }

    protected void trk(int lineNro) {
        if (this.dbgInfo != null) {
            this.dbgInfo.trk(lineNro);
        }
    }

    protected void trk(int lineNro, int lineNro2) {
        if (this.dbgInfo != null) {
            this.dbgInfo.trk(lineNro, lineNro2);
        }
    }

    protected void trkrng(int lineNro, int lineNro2) {
        this.trkrng(lineNro, 0, lineNro2, 0);
    }

    protected void trkrng(int lineNro, int colNro, int lineNro2, int colNro2) {
        if (this.dbgInfo != null) {
            this.dbgInfo.trkRng(lineNro, colNro, lineNro2, colNro2);
        }
    }
}

