/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.Application;
import com.genexus.ApplicationContext;
import com.genexus.CommonUtil;
import com.genexus.ExecuteDirectSQL;
import com.genexus.GXProcedure;
import com.genexus.GXRuntimeException;
import com.genexus.Messages;
import com.genexus.ModelContext;
import com.genexus.ServerPreferences;
import com.genexus.db.Namespace;
import com.genexus.db.UserInformation;
import com.genexus.platform.NativeFunctions;
import com.genexus.util.ReorgSubmitThreadPool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Vector;

public abstract class GXReorganization {
    protected File reorganizationFlag;
    protected boolean working = false;
    protected boolean autoCommit = true;
    int handle;
    private static final String replyIgnore = "CALL QSYS/QCMDEXC('QSYS/CHGJOB INQMSGRPY(*SYSRPYL)',0000000031.00000)";
    private static final String ReoFlagGen = "REORGPGM.GEN";
    protected static final String ReoFlagExp = "REORGPGM.EXP";
    private GXProcedure reorgProcedure;
    protected static Messages msg;
    protected ModelContext context;
    private static boolean force;
    private static boolean recordcount;
    private static boolean ignoreresume;
    private static boolean noprecheck;
    private static boolean notexecute;
    boolean doReorganization;
    protected boolean returnValue;
    private static final String resumeFileName = "resumereorg.txt";
    private static Vector<String> executedStatements;
    private static boolean executingResume;
    private boolean inavlidResumeVersion = false;
    private static boolean createDataBase;
    static Object lock;
    private static FileWriter output;
    private static boolean checkError;
    private static String errorMessage;

    public abstract void execute();

    public abstract String getPackageDir();

    public GXReorganization(Class gxCfg) {
        ApplicationContext.getInstance().setReorganization(true);
        Application.init(gxCfg);
        ServerPreferences.fileName = "reorg.cfg";
        this.context = new ModelContext(gxCfg);
        this.handle = Application.getConnectionManager().createUserInformation(Namespace.getNamespace(this.context.getNAME_SPACE())).getHandle();
        msg = Application.getConnectionManager().getUserInformation(this.handle).getLocalUtil().getMessages();
    }

    public static String getMainDBName(ModelContext context, int handle) {
        UserInformation ui = Application.getConnectionManager().getUserInformation(handle);
        return ui.getNamespace().getDataSource((String)"DEFAULT").jdbcDBName;
    }

    protected void cleanup() {
        Application.exitApplet();
    }

    protected int getHandle() {
        return this.handle;
    }

    private void processParameters(String[] args) {
        for (int i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            if (args[i].toLowerCase().startsWith("-force")) {
                force = true;
            }
            if (args[i].toLowerCase().startsWith("-recordcount")) {
                recordcount = true;
            }
            if (args[i].toLowerCase().startsWith("-ignoreresume")) {
                ignoreresume = true;
            }
            if (args[i].toLowerCase().startsWith("-noverifydatabaseschema")) {
                noprecheck = true;
            }
            if (!args[i].toLowerCase().startsWith("-donotexecute")) continue;
            notexecute = true;
        }
    }

    public static boolean getRecordCount() {
        return recordcount;
    }

    public static void printRecordCount(String tableName, int recordCount) {
        if (!executingResume) {
            GXReorganization.addMsg(msg.getMessage("GXM_table_recordcount", new Object[]{tableName, recordCount}));
        }
    }

    public void executeReorg(String[] args, boolean isCreateDataBase) {
        createDataBase = isCreateDataBase;
        this.processParameters(args);
        if (notexecute) {
            GXReorganization.addMsg(msg.getMessage("GXM_dbnotreorg"));
        } else {
            ApplicationContext.getInstance().setMsgsToUI(false);
            this.executeReorg();
        }
    }

    public boolean ExecDataInitialization() {
        boolean isOK = true;
        try {
            Class<?> reorgClass;
            Method method;
            if (this.reorgProcedure != null && (method = (reorgClass = this.reorgProcedure.getClass()).getMethod("ExecDataInitialization", new Class[0])) != null) {
                method.invoke((Object)this.reorgProcedure, (Object[])null);
            }
        }
        catch (NoSuchMethodException reorgClass) {
        }
        catch (Exception ex) {
            isOK = false;
            ex.printStackTrace();
        }
        return isOK;
    }

    protected void setReorgProcedure(GXProcedure reorgProcedure) {
        this.reorgProcedure = reorgProcedure;
    }

    protected void executeReorg() {
        this.reorganizationFlag = new File(ReoFlagGen);
        this.doReorganization = Application.getClientContext().getClientPreferences().getCS_REORGJAVA();
        Application.realMainProgram = this;
        if (!force) {
            this.returnValue = true;
            NativeFunctions.getInstance().executeWithPermissions((Runnable)new ReorgEnabled1(), 1);
            if (!this.returnValue) {
                return;
            }
        }
        if (this.doReorganization) {
            if (!recordcount) {
                this.beginResume();
                if (!this.inavlidResumeVersion) {
                    try {
                        this.processExternalScript("beforeReorganizationScript.txt");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (!this.inavlidResumeVersion) {
                try {
                    this.execute();
                }
                catch (GXRuntimeException e) {
                    e.printStackTrace();
                }
            }
        } else {
            GXReorganization.addMsg(msg.getMessage("GXM_dbnotreorg"));
            GXReorganization.addMsg(msg.getMessage("GXM_reorgpref"));
        }
        ReorgSubmitThreadPool.waitForEnd();
        if (this.success() && !ReorgSubmitThreadPool.hasAnyError()) {
            boolean isOK = true;
            if (!recordcount) {
                isOK = this.ExecDataInitialization();
                this.deleteResumeFile();
                try {
                    this.processExternalScript("afterReorganizationScript.txt");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (isOK) {
                    GXReorganization.addMsg(msg.getMessage("GXM_reorgsuccess"));
                } else {
                    GXReorganization.addMsg(msg.getMessage("GXM_reorgnotsuccess"));
                }
            }
            Application.commit(this.context, this.getHandle(), "GXReorganization");
            if (!isOK) {
                System.exit(2);
            }
        } else {
            GXReorganization.addMsg(msg.getMessage("GXM_reorgnotsuccess"));
            System.exit(1);
        }
        System.exit(0);
    }

    private void msg(String text) {
        System.out.println("! " + text);
    }

    public boolean success() {
        if (checkError) {
            GXReorganization.addMsg(msg.getMessage("GXM_error_in_schema_verification"));
            GXReorganization.addMsg(errorMessage);
            this.deleteResumeFile();
            return false;
        }
        if (this.inavlidResumeVersion) {
            return false;
        }
        this.returnValue = true;
        if (!force) {
            NativeFunctions.getInstance().executeWithPermissions((Runnable)new ProcessFiles(), 2);
        }
        return this.returnValue;
    }

    public static void addMsg(String msg) {
        System.out.println(msg);
    }

    public static void addMsg(int index, String msg) {
        System.out.println(msg);
    }

    public static void replaceMsg(int index, String msg) {
        System.out.println(msg);
    }

    private void processExternalScript(String fileName) throws Exception {
        try (BufferedReader input = new BufferedReader(new FileReader(fileName));){
            String line = this.readSentence(input);
            while (!line.equals("")) {
                if (!GXReorganization.executedBefore(line)) {
                    GXReorganization.addMsg(msg.getMessage("GXM_executing", new Object[]{line}));
                    ExecuteDirectSQL.executeWithThrow((ModelContext)this.context, (int)this.getHandle(), (String)"DEFAULT", (String)line);
                }
                line = this.readSentence(input);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private String readSentence(BufferedReader is) throws Exception {
        StringBuffer result = new StringBuffer();
        boolean inLiteral = false;
        int caracter = is.read();
        while (caracter != 59 || inLiteral) {
            if (caracter == -1) {
                return "";
            }
            if (caracter != 13 && caracter != 10) {
                if (caracter == 34) {
                    inLiteral = !inLiteral;
                }
                result.append((char)caracter);
            }
            caracter = is.read();
        }
        return result.toString();
    }

    public static void setCreateDataBase() {
        createDataBase = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginResume() {
        InputStreamReader reader = null;
        BufferedReader input = null;
        try {
            String statement;
            if (createDataBase || ignoreresume) {
                try {
                    new File(resumeFileName).delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((statement = (input = new BufferedReader(reader = new FileReader(resumeFileName))).readLine()) != null && !statement.equals(Application.getClientContext().getClientPreferences().getREORG_TIME_STAMP())) {
                this.inavlidResumeVersion = true;
                GXReorganization.addMsg(msg.getMessage("GXM_lastreorg_failed1"));
                GXReorganization.addMsg(msg.getMessage("GXM_lastreorg_failed2"));
                GXReorganization.addMsg(msg.getMessage("GXM_lastreorg_failed3"));
                input.close();
                return;
            }
            while (statement != null) {
                executedStatements.addElement(statement);
                statement = input.readLine();
            }
            input.close();
            reader.close();
            executingResume = true;
        }
        catch (FileNotFoundException ioe) {
        }
        catch (IOException ioe) {
        }
        finally {
            GXReorganization.serializeExecutedStatements();
            try {
                if (reader != null) {
                    reader.close();
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static boolean executedBefore(String statement) {
        if (executingResume) {
            return executedStatements.contains(statement);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExecutedStatement(String statement) {
        String newline = CommonUtil.newLine();
        if (statement.trim().startsWith(replyIgnore)) {
            return;
        }
        if (!recordcount) {
            Object object = lock;
            synchronized (object) {
                try {
                    output.write(statement);
                    output.write(newline);
                    output.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static void serializeExecutedStatements() {
        String newline = CommonUtil.newLine();
        try {
            output = new FileWriter(resumeFileName, true);
            if (!executingResume) {
                output.write(Application.getClientContext().getClientPreferences().getREORG_TIME_STAMP());
                output.write(newline);
                output.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void deleteResumeFile() {
        try {
            output.close();
            new File(resumeFileName).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setCheckError(String checkErrorMessage) {
        errorMessage = checkErrorMessage;
        checkError = true;
    }

    public static boolean isResumeMode() {
        return executingResume;
    }

    public static boolean mustRunCheck() {
        return !executingResume && !noprecheck;
    }

    public static String getSchemaName() {
        String section = Application.getClientPreferences().getNAME_SPACE() + "|DEFAULT";
        String schema = Application.getClientPreferences().getIniFile().getProperty(section, "CS_SCHEMA", "");
        if (schema.equals("")) {
            return Application.getClientPreferences().getIniFile().getPropertyEncrypted(section, "USER_ID", "");
        }
        return schema;
    }

    static {
        force = false;
        recordcount = false;
        ignoreresume = false;
        noprecheck = false;
        notexecute = false;
        executedStatements = new Vector();
        executingResume = false;
        createDataBase = false;
        lock = new Object();
        checkError = false;
    }

    class ProcessFiles
    implements Runnable {
        ProcessFiles() {
        }

        @Override
        public void run() {
            if (new File(GXReorganization.ReoFlagExp).exists()) {
                new File(GXReorganization.ReoFlagExp).delete();
            }
            if (!GXReorganization.this.reorganizationFlag.renameTo(new File(GXReorganization.ReoFlagExp))) {
                GXReorganization.addMsg(msg.getMessage("GXM_reorgrenre"));
                GXReorganization.this.returnValue = false;
                return;
            }
        }
    }

    class ReorgEnabled1
    implements Runnable {
        ReorgEnabled1() {
        }

        @Override
        public void run() {
            if (!GXReorganization.this.reorganizationFlag.exists()) {
                GXReorganization.this.msg(msg.getMessage("GXM_noreorg"));
                GXReorganization.this.returnValue = false;
                GXReorganization.this.cleanup();
                return;
            }
        }
    }
}

